/*
 * Created on Oct 15, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.sap.caf.rt.ui.cool.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import com.sap.caf.rt.services.serviceaccess.ICategoryFieldService;
import com.sap.caf.rt.services.serviceaccess.ITypedFieldService;
import com.sap.dictionary.runtime.DdDataType;
import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.DdSimpleType;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.ISimpleType;
import com.sap.dictionary.runtime.ISimpleTypeModifiable;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.dictionary.types.services.NamingService.Structure;
import com.sap.tc.webdynpro.repository.DataTypeBroker;
import com.sap.typeservices.ISimpleValueServices;
import com.sap.typeservices.ITextServices;

/**
 * @author Alexey_Bloudov
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TypedFieldDescriptor extends FieldDescriptor {
	public static final int SERVICE_REQUIRED_NONE = 0;
	public static final int SERVICE_REQUIRED_TYPED_FIELD_SRV = 1;
	public static final int SERVICE_REQUIRED_CATEGORY_FIELD_SRV = 2;

	protected IDataType m_dataType;
	protected String m_customType;
	//is used as param for DataTypeBroker.getSimpleType and getDataType 
	private ClassLoader m_classLoader;
	//no access except set/get from this class
	private boolean m_loadOnDemand;
	private Locale mLocale;
	private int serviceRequired = SERVICE_REQUIRED_NONE;
	private ISimpleValueServices simpleValueService;
	private String m_categoryID;

	private String CUST_ENUM_NAME = "customtypes";
	//this variables are for caching
	private boolean isCustomTypeEnum;
	private boolean isCustomTypeCategory;

	/**
	 * An internal map of data Types
	 */
	private static Map dataTypes =
		Collections.synchronizedMap(new HashMap(23, 0.5f));

	public TypedFieldDescriptor(String name, String type, ClassLoader cl) {
		//2
		this(name, type, null, "", "", cl, null);
	}

	public TypedFieldDescriptor(
		String name,
		String type,
		boolean loadOnDemand,
		ClassLoader cl) {
		//f	
		this(name, type, null, "", "", false, loadOnDemand, cl, null);
	}
	//custom
	public TypedFieldDescriptor(
		String name,
		String type,
		String customType,
		ClassLoader cl,
		Locale locale) {
		//2
		this(name, type, customType, "", "", cl, locale);
	}

	public TypedFieldDescriptor(
		String name,
		String type,
		String customType,
		boolean loadOnDemand,
		ClassLoader cl) {
		//f	
		this(name, type, customType, "", "", false, loadOnDemand, cl, null);
	}

	public TypedFieldDescriptor(
		String name,
		String type,
		String customType,
		String maxlength,
		ClassLoader cl) {
		//2	
		this(name, type, customType, maxlength, "", cl, null);
	}
	//2
	public TypedFieldDescriptor(
		String name,
		String type,
		String customType,
		String maxlength,
		String decimals,
		ClassLoader cl,
		Locale locale) {
		//3	
		this(name, type, customType, maxlength, decimals, false, cl, locale);
	}
	//3
	public TypedFieldDescriptor(
		String name,
		String type,
		String customType,
		String maxlength,
		String decimals,
		boolean extension,
		ClassLoader cl,
		Locale locale) {
		this(
			name,
			type,
			customType,
			maxlength,
			decimals,
			extension,
			false,
			cl,
			locale);
	}

	//f 
	//if type is null type is get from custom type 
	public TypedFieldDescriptor(
		String name,
		String type,
		String customType,
		String maxlength,
		String decimals,
		boolean extension,
		boolean loadOnDemand,
		ClassLoader cl,
		Locale locale) {

		super(name, "STRING", maxlength, decimals, extension);
		m_customType = customType;
		isCustomTypeEnum = evaluateIsCustomEnumType(m_customType);
		m_loadOnDemand = loadOnDemand;
		m_classLoader = cl;
		if (locale != null) {
			mLocale = locale;
		} else if (getLocale() != null) {
			mLocale = getLocale();
		} else {
			mLocale = Locale.getDefault();
		}

		IDataType extractedTypeFromCustomType = null;
		String builtInType = type;
		if (type == null || "".equals(type)) {
			try {
				extractedTypeFromCustomType =
					getDataType(null, locale, null, true);
				if (extractedTypeFromCustomType != null
					&& extractedTypeFromCustomType instanceof DdSimpleType) {
					builtInType =
						((DdSimpleType) extractedTypeFromCustomType)
							.getBuiltInType();
				}
			} catch (Exception ex) {
				if (_logger.beError())
					_logger.errorT("TypedFieldDescriptor", ex.toString());
			}
		}
		super.setType(TypesTransformer.getTypeByBuildInType(builtInType));
	}

	public ClassLoader getClassLoader() {
		return m_classLoader == null
			? Thread.currentThread().getContextClassLoader()
			: m_classLoader;
	}

	public ISimpleType getCurrencyUnitType(String arg0, Locale arg1)
		throws DdException {
		return DataTypeBroker.getSimpleType(arg0, arg1, getClassLoader());
	}

	public IDataType getDataType(String arg0, Locale locale, Object arg2)
		throws DdException {
		return getDataType(arg0, locale, arg2, false);
	}

	//gets simple type from custom_type or from fieldDescriptor if custom_type null
	//arg0, arg2 are not currently used
	private IDataType getDataType(
		String arg0,
		Locale locale,
		Object arg2,
		boolean isCalledFromConstructor)
		throws DdException {
		//getting locale
		Locale localeToUse = null;
		if (locale != null) {
			localeToUse = locale;
		} else if (mLocale != null) {
			localeToUse = mLocale;
		} else if (getLocale() != null) {
			localeToUse = getLocale();
		} else {
			localeToUse = Locale.getDefault();
		}

		boolean localeHasChanged = !localeToUse.equals(mLocale);

		//if customType not null 
		if (m_customType != null) {
			synchronized (TypedFieldDescriptor.class) {
				//cache for simple types only 
				if(!isCustomEnumType()) { 
					m_dataType =
						(IDataType) dataTypes.get(getDataTypeCacheKey(localeToUse));
				}		
				//				called from constructor
				//when RepManager sees this flag it adds Service Implementation to this class
				if (isCalledFromConstructor) {
					if (isCategoryType(m_customType)) {
						serviceRequired = SERVICE_REQUIRED_CATEGORY_FIELD_SRV;
					}
				}
				//if not found	
				//caching for categories is switched off
				if (m_dataType == null
					|| isCategoryType(m_customType)) {
					boolean multiUser =
						m_customType.equalsIgnoreCase(
							"com.sap.caf.core.multiUserType");
					//for single, multi user types 
					if (multiUser
						|| m_customType.equalsIgnoreCase(
							"com.sap.caf.core.singleUserType")) {
						m_dataType = createUserType(localeToUse, multiUser);
					} else {
						try {
							m_dataType =
								DataTypeBroker.getDataType(
									"ddic:" + m_customType,
									localeToUse,
									getClassLoader());
						} catch (Exception e) {
							if (_logger.beError())
								_logger.errorT(
									"getDataType(String, Locale, Object)",
									e.toString());
						}
						//when types are not get creating enum type
						if (!isCalledFromConstructor
							&& m_categoryID != null
							&& isCategoryType(m_customType)) {
							processCategoryType(localeHasChanged, localeToUse);
						}
						dataTypes.put(
							getDataTypeCacheKey(getDefaultLocale()),
							m_dataType);
					}
				}
			}
		} else {
			m_dataType = super.getSimpleType();
		}
		if (m_dataType == null) {
			throw new DdException(
				"DdicTypeDoesNotExist",
				new Object[] { m_customType });
		}
		return m_dataType;
	}

	private void processCustomEnumType() {
		if (simpleValueService != null
			&& simpleValueService instanceof ITypedFieldService) {
			ITypedFieldService typedFieldService =
				(ITypedFieldService) simpleValueService;
			//check
			//most probably it is a simple data type, but was not found on previous step
			if (typedFieldService.getValues() == null) {
				m_dataType = null;
				return;
			}
			m_dataType = createEnumType(getDefaultLocale());
			((EnumType) m_dataType).setSVServices(typedFieldService);
//			dataTypes.put(getDataTypeCacheKey(getDefaultLocale()), m_dataType);
		}
	}

	private void processCategoryType(
		boolean localeHasChanged,
		Locale localeToUse) {
		if (simpleValueService != null
			&& simpleValueService instanceof ICategoryFieldService) {
			ICategoryFieldService categoryFieldService =
				(ICategoryFieldService) simpleValueService;
			//creating Category types
			categoryFieldService.setCategoryId(m_categoryID);
			if (localeHasChanged) {
				categoryFieldService.setLocale(localeToUse);
			}
			m_dataType = createEnumType(localeToUse);
			((EnumType) m_dataType).setSVServices(categoryFieldService);
		}
	}

	public boolean isCustomEnumType() {
		return isCustomTypeEnum;
	}
	private boolean evaluateIsCustomEnumType(String typeName) {
		if (typeName == null)
			return false;
		int lastDot = typeName.lastIndexOf('.');
		int preLastDot = typeName.lastIndexOf('.', lastDot - 1);
		preLastDot++;
		if (lastDot != -1) {
			String packageName = typeName.substring(preLastDot, lastDot);
			if (packageName.equals(CUST_ENUM_NAME)) {
				return true;
			}
		}
		return false;
	}

	private boolean isCategoryType(String typeName) {
		if (isCustomTypeCategory == false) {
			isCustomTypeCategory =
				(m_categoryID != null && typeName.endsWith(m_categoryID));
		}
		return isCustomTypeCategory;
	}

	private IDataType createUserType(Locale locale, boolean multiUser) {
		XmlMap theMap = new XmlMap();
		XmlMap simpleTypeMap = new XmlMap();
		simpleTypeMap.put("builtInType", "string");
		simpleTypeMap.put(
			"name",
			Structure.getJavaNameFromBackendName(
				Structure.getBackendNameFromABAPName(m_customType)));
		theMap.put("SimpleType", simpleTypeMap);
		IDataType theSimpleType = null;
		if (multiUser) {
			theSimpleType = new MultiUserType(this, locale, theMap);
		} else {
			theSimpleType = new SingleUserType(this, locale, theMap);
		}
		return theSimpleType;
	}

	private EnumType createEnumType(Locale locale) {
		XmlMap theMap = new XmlMap();
		XmlMap simpleTypeMap = new XmlMap();
		simpleTypeMap.put("builtInType", "string");

		simpleTypeMap.put(
			"name",
			Structure.getJavaNameFromBackendName(
				Structure.getBackendNameFromABAPName(m_customType)));
		theMap.put("SimpleType", simpleTypeMap);
		EnumType theSimpleType = null;

		theSimpleType = new EnumType(this, locale, theMap);
		return theSimpleType;
	}

	private String getDataTypeCacheKey(Locale locale) {
		return String.valueOf(locale) + ":" + m_customType;
	}

	public IDataType getDataType(String arg0, Locale arg1) throws DdException {
		return getDataType(arg0, arg1, null);
	}

	public ITextServices getTextService(ISimpleType arg0) throws DdException {
		return this;
	}

	public ISimpleType getUnitOfMeasureType(String arg0, Locale arg1)
		throws DdException {
		return DataTypeBroker.getSimpleType(arg0, arg1, getClassLoader());
	}

	public ISimpleValueServices getValueService(ISimpleType arg0)
		throws DdException {
		if (arg0 instanceof ISimpleTypeModifiable) {
			if (arg0 instanceof DdDataType
				&& ((DdDataType) arg0).getProvider() != this) {
				return ((ISimpleTypeModifiable) m_dataType).getSVServices();
			} else {
				return super.getValueService(arg0);
			}
		} else {
			throw new UnsupportedOperationException("Data type does not implement ISimpleTypeModifiable.");
		}
	}

	public static void clearCache() {
		dataTypes.clear();
	}

	public boolean isLoadOnDemand() {
		return m_loadOnDemand;
	}

	public ISimpleType getSimpleType() {
		try {
			IDataType dt = getDataType(null, null, null);
			if (dt instanceof ISimpleType) {
				return (ISimpleType) dt;
			}
		} catch (DdException e) {
			if (_logger.beError())
				_logger.errorT("createSimpleType(Locale)", e.toString());
		}
		return super.getSimpleType();
	}

	public int getServiceRequired() {
		return serviceRequired;
	}
	/**
	 * @param service
	 */
	public void setSimpleValueService(ISimpleValueServices service) {
		simpleValueService = service;
		processCustomEnumType();
	}

	/**
	 * @return
	 */
	public ISimpleValueServices getSimpleValueService() {
		return simpleValueService;
	}

	public Locale getDefaultLocale() {
		return mLocale;
	}

	public String getCustomType() {
		return m_customType;
	}

	public void setCategoryID(String value) {
		serviceRequired = SERVICE_REQUIRED_CATEGORY_FIELD_SRV;
		m_categoryID = value;
	}

	public String getCategoryID() {
		return m_categoryID;
	}

}
//TODO :get to know what wdp type corresponded to Sing - Mult user type in 0.