/*
 * Created on 08.04.2004
 *
 */
package com.sap.caf.rt.ui.cool.metadata;

import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * @author Sergey_Firsov
 * Provides information about structures which are cached 
 * in the service manager repository
 *
 */
public class StructureDescriptor extends AbstractDescriptor
    implements IStructureDescriptor{
    private ServiceModuleDescriptor mServiceModuleDescriptor;
    private ArrayList fields;
    private HashMap fieldMap;

    /**
	 * empty constructor
	 */
	 public StructureDescriptor(){
    }

    /**
	 * @param serviceModuleDesc - ServiceModuleDescriptor for this StructureDescriptor
	 * @param name - name of StructureDescriptor
	 * @param fieldArray - array of fields for this StructureDescriptor
	 */
	 public StructureDescriptor(ServiceModuleDescriptor serviceModuleDesc, String name, FieldDescriptor fieldArray[])
    {
        super(name);
        fieldMap = new HashMap();
        mServiceModuleDescriptor = serviceModuleDesc;
        fields = new ArrayList(fieldArray.length);
        for(int i = 0; i < fieldArray.length; i++)
            if(!fieldMap.containsKey(fieldArray[i].getName()))
            {
                fieldArray[i].setStructureDescriptor(this);
                fields.add(fieldArray[i]);
                fieldMap.put(fieldArray[i].getName(), new Integer(i));
            }

    }

    /**
     * @deprecated Method StructureDescriptor is deprecated
     */

    public StructureDescriptor(String name, FieldDescriptor fieldArray[])
    {
        this(null, name, fieldArray);
    }

    /**
	 * Returns the index of the field with given name or -1 if the field does not exist.
	 */
	 public int getFieldIndex(String name)
    {
        Integer index = (Integer)fieldMap.get(name);
        if(index != null)
            return index.intValue();
        else
            return -1;
    }

    /**
	 * Returns the number of fields of this structure
	 */
	 public int size()
    {
        return fields.size();
    }

    /**
	 *  Returns the field descriptor of the field with index in this structure
	 */
	 public IFieldDescriptor getFieldDescriptor(int index)
    {
        return (IFieldDescriptor)fields.get(index);
    }

    /**
	 * Returns the field desriptor of the field with the given name in 
	 * this structure
	 */
	 public IFieldDescriptor getFieldDescriptor(String fieldName)
    {
        int fieldIndex = getFieldIndex(fieldName);
        if(fieldIndex >= 0)
            return (IFieldDescriptor)fields.get(fieldIndex);
        else
            throw new IllegalArgumentException("No such field '" + fieldName + "' in structure '" + getName() + "'");
    }

    /**
	 * Returns an array which contains all field descriptors in this structure.
	 */
	 public IFieldDescriptor[] getFieldDescriptors()
    {
        IFieldDescriptor fieldDescriptors[] = new FieldDescriptor[fields.size()];
        fields.toArray(fieldDescriptors);
        return fieldDescriptors;
    }

    /**
	 * @return ServiceModuleDescriptor for this StructureDescriptor
	 */
	 ServiceModuleDescriptor getServiceModuleDescriptor()
    {
        return mServiceModuleDescriptor;
    }

    /**
	 * returns a string representation of this AspectDescriptor 
	 */
	 public String toString()
    {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("  <structure name=\"").append(getName()).append("\">").append(nl);
        for(int i = 0; i < fields.size(); i++)
            buf.append(fields.get(i));

        buf.append("  </structure>").append(nl);
        return buf.toString();
    }

    /**
	 * Returns whether this structure contains a field with the given name
	 */
	 public boolean hasField(String fieldName)
    {
        return fieldMap.containsKey(fieldName);
    }

}
