/*
 * Created on 08.04.2004
 *
 */
package com.sap.caf.rt.ui.cool.metadata;

import com.sap.tc.col.client.metadata.api.*;
import java.util.Collection;
import java.util.HashMap;

/**
 * @author Sergey_Firsov
 * Objects of this class describe service module groups. A service 
 * module group may contain AspectDescriptors and QueryDescriptors
 *
 */
public class ServiceModuleGroupDescriptor extends GroupDescriptor
    implements IServiceModuleGroupDescriptor{
    private HashMap mAspects;
    private HashMap mQueries;
    private ServiceModuleDescriptor mModuleDescriptor;
    private AspectDescriptor aspectDescriptor;


    /**
	 * empty constructor
	 */
	 public ServiceModuleGroupDescriptor(){
    }


    /**
	 * @param name - name of ServiceModuleGroupDescriptor
	 * @param moduleDescriptor - ServiceGroupDescriptor for ServiceModuleGroupDescriptor
	 */
	 public ServiceModuleGroupDescriptor(String name, ServiceModuleDescriptor moduleDescriptor)
    {
        super(name);
        mModuleDescriptor = moduleDescriptor;
        moduleDescriptor.addModuleGroupDescriptor(this);
        mAspects = new HashMap();
        mQueries = new HashMap();
    }

    /**
	 * add Descriptor to this ServiceModuleGroupDescriptor
	 */
	 public void addDescriptor(AbstractDescriptor descriptor)
    {
        if(descriptor instanceof AspectDescriptor)
            addAspectDescriptor((AspectDescriptor)descriptor);
        else
        if(descriptor instanceof QueryDescriptor)
            addQueryDescriptor((QueryDescriptor)descriptor);
        else
            throw new IllegalArgumentException("Descriptor type " + descriptor.getClass().getName() + " not allowed for service module groups");
    }

    /**
	 * get Descriptor for specified name
	 */
	 public AbstractDescriptor getDescriptor(String name)
    {
        AbstractDescriptor desc = (AspectDescriptor)getAspectDescriptor(name);
        if(desc == null)
            desc = (QueryDescriptor)getQueryDescriptor(name);
        return desc;
    }

    /**
	 * get array of descriptors for this ServiceModuleGroupDescriptor
	 */
	 public AbstractDescriptor[] getDescriptors()
    {
        Collection allDescriptors = mAspects.values();
        allDescriptors.addAll(mQueries.values());
        AbstractDescriptor descriptors[] = new AbstractDescriptor[allDescriptors.size()];
        allDescriptors.toArray(descriptors);
        return descriptors;
    }

    /**
    * add Aspect descriptor to this ServiceModuleGroupDescriptor
	 * @param aspect
	 */
	 public void addAspectDescriptor(AspectDescriptor aspect)
    {
        mAspects.put(aspect.getName(), aspect);
    }

    /**
    * Returns the aspect descriptor with the given name, if it is a member 
    * of this group, otherwise null
	 */
	 public IAspectDescriptor getAspectDescriptor(String aspectname)
    {
        return (IAspectDescriptor)mAspects.get(aspectname);
    }

    /**
	 * Returns an array with all the aspect descriptors in this group
	 */
	 public IAspectDescriptor[] getAspectDescriptors()
    {
        IAspectDescriptor descriptors[] = new AspectDescriptor[mAspects.size()];
        mAspects.values().toArray(descriptors);
        return descriptors;
    }

    /**
    * add Query descriptor to this ServiceModuleGroupDescriptor
	 * @param query
	 */
	 public void addQueryDescriptor(QueryDescriptor query)
    {
        mQueries.put(query.getName(), query);
    }

    /**
	 *  Returns the query descriptor for the given name, if it is a member 
	 * of this group, otherwise null
	 */
	 public IQueryDescriptor getQueryDescriptor(String queryname)
    {
        return (IQueryDescriptor)mQueries.get(queryname);
    }

    /**
	 * Returns an array with all the query descriptors in this group
	 */
	 public IQueryDescriptor[] getQueryDescriptors()
    {
        IQueryDescriptor descriptors[] = new QueryDescriptor[mQueries.size()];
        mQueries.values().toArray(descriptors);
        return descriptors;
    }

}
