/*
 * Created on 08.04.2004
 *
 */
package com.sap.caf.rt.ui.cool.metadata;

import com.sap.tc.col.client.metadata.api.*;
import java.util.*;

/**
 * @author Sergey_Firsov
 * Provides information about service modules which are cached in the 
 * service manager repository
 *
 */
public class ServiceModuleDescriptor extends AbstractDescriptor
    implements IServiceModuleDescriptor{
	
	public static final String CREATE_OPERATION_TYPE = "create";
	public static final String READ_OPERATION_TYPE = "read";
	public static final String UPDATE_OPERATION_TYPE = "update";
	public static final String DELETE_OPERATION_TYPE = "delete";
    	
    private HashMap mAttributes;
    private Locale mLocale;
    private StructureDescriptor mRelationIndexStructure;
    private StructureDescriptor mInputFieldsStructure;
    private StructureDescriptor mMessageStructure;
    private StructureDescriptor mReturnCodeStructure;
    private StructureDescriptor mInputOptionsStructure;
    private StructureDescriptor mSortingOptionsStructure;
    private StructureDescriptor mSelectionsStructure;
    private String mConfiguration;
    private String mConfigurationDescription;
    private String description;
    private HashMap queries;
    private HashMap relations;
    private HashMap aspectDescriptors;
    private HashMap mModuleGroups;
    
    /**
     * Contains descriptors for CRUD operations.
     */
	private HashMap crudOperationsDescriptors;

    /**
	 * empty constructor
	 */
	 public ServiceModuleDescriptor(){
	 	super();
    }

    /**
	 * @param name - name of ServiceModuleDescriptor
	 * @param description - description of ServiceModuleDescriptor
	 * @param configuration - configuration of ServiceModuleDescriptor
	 * @param configurationDescription - description of configuration of ServiceModuleDescriptor
	 * @param locale - ServiceModuleDescriptor locale
	 */
	 public ServiceModuleDescriptor(String name, String description, String configuration, String configurationDescription, Locale locale)
    {
        super(name);
        mAttributes = new HashMap();
        mRelationIndexStructure = null;
        mInputFieldsStructure = null;
        mMessageStructure = null;
        mReturnCodeStructure = null;
        mInputOptionsStructure = null;
        mSortingOptionsStructure = null;
        mSelectionsStructure = null;
        queries = new HashMap();
        relations = new HashMap();
        aspectDescriptors = new HashMap();
        mModuleGroups = new HashMap();
        this.description = description;
        mConfiguration = configuration;
        mConfigurationDescription = configurationDescription;
        mLocale = locale;
		crudOperationsDescriptors = new HashMap();
    }

    /**
	 * Returns a textual description for this service module
	 */
	public String getDescription()
    {
        return description;
    }

    /**
    * add QueryDescriptor to this ServiceModuleDescriptor
	 * @param queryDescriptor
	 */
	 public void addQueryDescriptor(QueryDescriptor queryDescriptor)
    {
        if(queryDescriptor != null)
            queries.put(queryDescriptor.getName(), queryDescriptor);
    }

    /**
	 * Returns an array with the descriptors of all queries in this service module
	 */
	 public IQueryDescriptor[] getQueryDescriptors()
    {
        IQueryDescriptor tmpArr[] = new QueryDescriptor[queries.size()];
        queries.values().toArray(tmpArr);
        return tmpArr;
    }

    /**
	 * Returns the query descriptor with the given name or null, if the query doesn't exist in this service module
	 */
	 public IQueryDescriptor getQueryDescriptor(String name)
    {
        return (IQueryDescriptor)queries.get(name);
    }

    /**
    * add RelationDescriptor to this ServiceModuleDescriptor
	 * @param relationDescriptor
	 */
	 public void addRelationDescriptor(RelationDescriptor relationDescriptor)
    {
        if(relationDescriptor != null)
        {
            relations.put(relationDescriptor.getName(), relationDescriptor);
            relationDescriptor.setServiceModuleDescriptor(this);
        }
        AspectDescriptor srcasp = (AspectDescriptor)getAspectDescriptor(relationDescriptor.getSourceAspectDescriptor().getName());
        if(srcasp != null)
            srcasp.addRelationDescriptor(relationDescriptor);
    }

    /**
     * @deprecated Method getRelationDescriptors is deprecated
     */

    public IRelationDescriptor[] getRelationDescriptors()
    {
        IRelationDescriptor tmpArr[] = new RelationDescriptor[relations.size()];
        relations.values().toArray(tmpArr);
        return tmpArr;
    }

    /**
     * @deprecated Method getRelationDescriptor is deprecated
     */

    public IRelationDescriptor getRelationDescriptor(String name)
    {
        return (IRelationDescriptor)relations.get(name);
    }

    /**
    * add AspectDescriptor to this ServiceModuleDescriptor
	 * @param aspectDescriptor
	 */
	void addAspectDescriptor(AspectDescriptor aspectDescriptor)
    {
        if(aspectDescriptor != null && getAspectDescriptor(aspectDescriptor.getName()) != aspectDescriptor)
            aspectDescriptors.put(aspectDescriptor.getName(), aspectDescriptor);
    }

    /**
	 * Returns an array with the descriptors of all aspects in this service module
	 */
	 public IAspectDescriptor[] getAspectDescriptors()
    {
        IAspectDescriptor tmpArr[] = new AspectDescriptor[aspectDescriptors.size()];
        aspectDescriptors.values().toArray(tmpArr);
        return tmpArr;
    }

    /**
	 * Returns an array with the descriptors of all key aspects in this service module
	 */
	 public IKeyAspectDescriptor[] getKeyAspectDescriptors()
    {
        HashSet tmpSet = new HashSet();
        for(Iterator it = aspectDescriptors.values().iterator(); it.hasNext();)
        {
            AspectDescriptor descriptor = (AspectDescriptor)it.next();
            if(descriptor != null)
                tmpSet.add(descriptor.getKeyDescriptor());
        }

        IKeyAspectDescriptor tmpArr[] = new KeyAspectDescriptor[tmpSet.size()];
        tmpSet.toArray(tmpArr);
        return tmpArr;
    }

    /**
	 *  Returns the key aspect descriptor with the given name or null, 
	 * if the key aspect doesn't exist in this service module
	 */
	 public IKeyAspectDescriptor getKeyAspectDescriptor(String aspectName)
    {
        IKeyAspectDescriptor keyDescriptors[] = getKeyAspectDescriptors();
        IKeyAspectDescriptor keyDescriptor = null;
        for(int i = 0; i < keyDescriptors.length; i++)
        {
            keyDescriptor = keyDescriptors[i];
            if(keyDescriptor.getName().equals(aspectName))
                return keyDescriptor;
        }

        return null;
    }

    /**
	 * Returns the aspect descriptor with the given name or null, 
	 * if the aspect doesn't exist in this service module
	 */
	 public IAspectDescriptor getAspectDescriptor(String aspectName)
    {
        return (IAspectDescriptor)aspectDescriptors.get(aspectName);
    }

    /**
    * add attribute value to the specified attribute name
	 * @param attributeName
	 * @param value
	 */
	 public void addAttribute(String attributeName, String value)
    {
        mAttributes.put(attributeName, value);
    }

    /**
	 * Returns the value that is stored in the service module for the given attribute
	 */
	 public String getAttributeStringValue(String attributeName)
    {
        return (String)mAttributes.get(attributeName);
    }

    /**
	 * Returns an array with the names of all the attributes which are stored in this service module
	 */
	public String[] getAttributeNames()
    {
        String attributes[] = new String[mAttributes.size()];
        mAttributes.keySet().toArray(attributes);
        return attributes;
    }

    /**
    * add ModuleGroupDescriptor to this ServiceModuleDescriptor
	 * @param aModuleGroupDescriptor
	 */
	 public void addModuleGroupDescriptor(ServiceModuleGroupDescriptor aModuleGroupDescriptor)
    {
        if(aModuleGroupDescriptor != null)
            mModuleGroups.put(aModuleGroupDescriptor.getName(), aModuleGroupDescriptor);
    }

    /**
	 * Returns the service module group descriptor with the given name 
	 * or null, if the service module group doesn't exist in this service 
	 * module
	 */
	 public IServiceModuleGroupDescriptor getServiceModuleGroupDescriptor(String name)
    {
        return (IServiceModuleGroupDescriptor)mModuleGroups.get(name);
    }

    /**
	 * Returns an array with the descriptors of all service module 
	 * groups in this service module
	 */
	 public IServiceModuleGroupDescriptor[] getServiceModuleGroupDescriptors()
    {
        IServiceModuleGroupDescriptor groupDescriptors[] = new ServiceModuleGroupDescriptor[mModuleGroups.size()];
        mModuleGroups.values().toArray(groupDescriptors);
        return groupDescriptors;
    }

    /**
	 * @return StructureDescriptor for relation index
	 */
	 public IStructureDescriptor getRelationIndexStructure()
    {
        if(mRelationIndexStructure == null)
            mRelationIndexStructure = new StructureDescriptor(this, "SCOOL_RELATION_INDEX", new FieldDescriptor[] {
                new FieldDescriptor("INRECORD", "INTEGER"), new FieldDescriptor("OUTRECORD", "INTEGER")
            });
        return mRelationIndexStructure;
    }

    /**
	 * @return StructureDescriptor for input fields
	 */
	 public IStructureDescriptor getInputFieldsStructure()
    {
        if(mInputFieldsStructure == null)
            mInputFieldsStructure = new StructureDescriptor(this, "SCOL_UPDATE_FIELDS", new FieldDescriptor[] {
                new FieldDescriptor("INKEY", "INTEGER"), new FieldDescriptor("FIELDNAME", "STRING")
            });
        return mInputFieldsStructure;
    }

    /**
	 * @return StructureDescriptor for message structure
	 */
	 public IStructureDescriptor getMessageStructure()
    {
        if(mMessageStructure == null)
            mMessageStructure = new StructureDescriptor(this, "SCOL_MESSAGE_TRANSPORT", new FieldDescriptor[] {
                new FieldDescriptor("INRECORD", "INTEGER"), new FieldDescriptor("FAILED", "BOOLEAN"), new FieldDescriptor("MESSAGE_TYPE", "STRING"), new FieldDescriptor("MESSAGE_CODE", "STRING"), new FieldDescriptor("MESSAGE_TEXT", "STRING"), new FieldDescriptor("MESSAGE_VARS", "STRING"), new FieldDescriptor("EXTENSION", "STRING"), new FieldDescriptor("ASPECT_NAME", "STRING"), new FieldDescriptor("ASPECT_KEY", "STRING"), new FieldDescriptor("ASPECT_FIELD", "STRING"), 
                new FieldDescriptor("MESSAGE_CATEGORY", "INTEGER")
            });
        return mMessageStructure;
    }

    /**
	 * @return StructureDescriptor for return code structure
	 */
	 public IStructureDescriptor getReturnCodeStructure()
    {
        if(mReturnCodeStructure == null)
            mReturnCodeStructure = new StructureDescriptor(this, "SCOL_RETURN_CODE", new FieldDescriptor[] {
                new FieldDescriptor("INRECORD", "INTEGER"), new FieldDescriptor("FAILED", "BOOLEAN")
            });
        return mReturnCodeStructure;
    }

    /**
	 * @return locale for this ServiceModuleDescriptor
	 */
	 Locale getLocale()
    {
        return mLocale;
    }

    /**
	 * Clears all dynamically set aspect row attributes that are currently 
	 * cached in the aspect descriptors of the aspects of this service 
	 * module
	 */
	 public void clearAspectRowAttributes()
    {
        AspectDescriptor asp;
        for(Iterator aspIt = aspectDescriptors.values().iterator(); aspIt.hasNext(); asp.clearRowAttributes())
            asp = (AspectDescriptor)aspIt.next();

    }

    /**
	 * Returns a textual description for the active configuration of the 
	 * this service module
	 */
	 public String getConfigurationDescription()
    {
        return mConfigurationDescription;
    }

    /**
	 * Returns the name of the active configuration of the service module
	 */
	 public String getConfigurationName()
    {
        return mConfiguration;
    }

    /**
	 * @return StructureDescriptor for input options structure
	 */
	 public IStructureDescriptor getInputOptionsStructure()
    {
        if(mInputOptionsStructure == null)
            mInputOptionsStructure = new StructureDescriptor(this, "SCOL_QUERY_OPTIONS_ROWS", new FieldDescriptor[] {
                new FieldDescriptor("ROWS", "INTEGER"), new FieldDescriptor("PAGE_MODE", "STRING"), new FieldDescriptor("QUERY_ID", "STRING"), new FieldDescriptor("START_ROW", "INTEGER")
            });
        return mInputOptionsStructure;
    }

    /**
	 * @return StructureDescriptor for sorting options structure
	 */
	 public IStructureDescriptor getSortingOptionsStructure()
    {
        if(mSortingOptionsStructure == null)
            mSortingOptionsStructure = new StructureDescriptor(this, "SCOL_SORTING_LINE", new FieldDescriptor[] {
                new FieldDescriptor("FIELD", "STRING")
            });
        return mSortingOptionsStructure;
    }

    /**
	 * @return StructureDescriptor for selections structure
	 */
	 public IStructureDescriptor getSelectionsStructure()
    {
        if(mSelectionsStructure == null)
            mSelectionsStructure = new StructureDescriptor(this, "SCOL_SELECTION", new FieldDescriptor[] {
                new FieldDescriptor("FIELDNAME", "STRING"), new FieldDescriptor("OPTION", "STRING"), new FieldDescriptor("LOW", "STRING"), new FieldDescriptor("HIGH", "STRING")
            });
        return mSelectionsStructure;
    }

	/**
	 * 
	 * @param aspectName
	 * @param actionDesc
	 * @param operationType can be CREATE_OPERATION_TYPE, READ_OPERATION_TYPE, UPDATE_OPERATION_TYPE, DELETE_OPERATION_TYPE
	 */
	public void addOperationDescriptor(String aspectName, IAspectActionDescriptor actionDesc, String operationType) {
		if(crudOperationsDescriptors == null) {
			crudOperationsDescriptors = new HashMap();
		}
		
		HashMap aspectOperations = (HashMap) crudOperationsDescriptors.get(aspectName);
		if(aspectOperations == null) {
			aspectOperations = new HashMap();
			crudOperationsDescriptors.put(aspectName, aspectOperations);
		}
		
		aspectOperations.put(operationType, actionDesc);
	}
    
    /**
     * 
     * @param aspectName
     * @param operationType can be CREATE_OPERATION_TYPE, READ_OPERATION_TYPE, UPDATE_OPERATION_TYPE, DELETE_OPERATION_TYPE
     * @return
     */
    public IAspectActionDescriptor getOperationDescriptor(String aspectName, String operationType) {
    	if(crudOperationsDescriptors!=null) {
			HashMap aspectOperations = (HashMap) crudOperationsDescriptors.get(aspectName);
			if(aspectOperations!=null) {
				return (AspectActionDescriptor) aspectOperations.get(operationType);
			}
    	}
    	return null;	
    }

}
