/*
 * Created on 26.04.2004
 *
 */
package com.sap.caf.rt.ui.cool.metadata;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

import com.sap.caf.rt.exception.ServiceException;
import com.sap.tc.cmi.metadata.CMICardinality;

/**
 * @author Sergey_Firsov
 *
 */
public class ServiceModelProviderImpl implements IServiceModelProvider{
	
	public static final String STUDENT_SERVICE_NAME = "sap.com/rixapp/StudentService";
	public static final String COURSE_SERVICE_NAME = "sap.com/rixapp/CourseService";
	public static final String TEACHER_SERVICE_NAME = "sap.com/rixapp/TeacherService";
	public static final String ADDRESS_SERVICE_NAME = "sap.com/rixapp/AddressService";
	ServiceModuleDescriptor smdStudent = null;
	ServiceModuleDescriptor smdCourse = null;
	ServiceModuleDescriptor smdTeacher = null;
	ServiceModuleDescriptor smdAddress = null;

	/**
	 * 
	 */
	
	public ServiceModelProviderImpl() {
		super();
	}
	
	/**
	 * init descriptors
	 */
	public void init() {
		/* create student  descriptors */	
		String description = "some description";
		smdStudent = new ServiceModuleDescriptor(STUDENT_SERVICE_NAME, description, "configuration", "configuration desc", Locale.getDefault());

		/* create course descriptor */
		smdCourse = new ServiceModuleDescriptor(COURSE_SERVICE_NAME, description, "configuration", "configuration desc", Locale.getDefault());

		/* create Teacher descriptor */
		smdTeacher = new ServiceModuleDescriptor(TEACHER_SERVICE_NAME, description, "configuration", "configuration desc", Locale.getDefault());

		/* create Address descriptor */
		smdAddress = new ServiceModuleDescriptor(ADDRESS_SERVICE_NAME, description, "configuration", "configuration desc", Locale.getDefault());

		/* create FieldDescriptors */
		FieldDescriptor[] fields = new FieldDescriptor[5];
		fields[0] = new FieldDescriptor("key", FieldDescriptor.STRING);
		fields[1] = new FieldDescriptor("firstName", FieldDescriptor.STRING);
		fields[2] = new FieldDescriptor("lastName", FieldDescriptor.STRING);
		fields[3] = new FieldDescriptor("averageGrade", FieldDescriptor.INTEGER);
		fields[4] = new FieldDescriptor("rewardPoints", FieldDescriptor.INTEGER);
		
		FieldDescriptor[] collFields = new FieldDescriptor[2];
		collFields[0] = new FieldDescriptor("key", FieldDescriptor.STRING);
		collFields[1] = new FieldDescriptor("value", FieldDescriptor.STRING);
		
		/* create StructureModuleDescriptor */
		StructureDescriptor structureDescriptor = 
			new StructureDescriptor( smdStudent, "structureDescriptor", fields);
			
		/* create KeyAspectDescriptor */
		FieldDescriptor[] keyFields = new FieldDescriptor[1];
		keyFields[0] = new FieldDescriptor("key", FieldDescriptor.STRING);
		StructureDescriptor keyStructure = 
			new StructureDescriptor( smdStudent, "keyStructure", keyFields);

		KeyAspectDescriptor keyAspectDescriptorStudent = 
			new KeyAspectDescriptor( smdStudent, "StudentKey", "StudentKey desc", keyStructure);

		AspectDescriptor aspectDescriptorStudent = new AspectDescriptor ( smdStudent, "Student",
			"student aspect", structureDescriptor, keyAspectDescriptorStudent );

		/* create QueryDescriptor */
		FieldDescriptor[] findFields = new FieldDescriptor[1];
		findFields[0] = new FieldDescriptor("firstName", FieldDescriptor.STRING);
		/* create StructureQueryModuleDescriptor */
		StructureDescriptor structureQueryDescriptor = 
			new StructureDescriptor( smdStudent, "structureQueryDescriptor", findFields);
		
		/* create StructureOutputModuleDescriptor */
		aspectDescriptorStudent.addAspectActionDescriptor(
			new AspectActionDescriptor("findByFirstName", structureQueryDescriptor, aspectDescriptorStudent));

		/* creating query descriptor for findByFirstName */
		QueryDescriptor queryDescriptor = new QueryDescriptor("findByFirstName",
			"findByFirstName desc", keyAspectDescriptorStudent, structureQueryDescriptor,
			 aspectDescriptorStudent, smdStudent);
		smdStudent.addQueryDescriptor(queryDescriptor);
		
		/* create FieldDescriptors */
		FieldDescriptor[] fieldsCourse = new FieldDescriptor[2];
		fieldsCourse[0] = new FieldDescriptor("key", FieldDescriptor.STRING);
		fieldsCourse[1] = new FieldDescriptor("description", FieldDescriptor.STRING);
			
		/* create StructureModuleDescriptor */
		StructureDescriptor structureDescriptorCourse = 
			new StructureDescriptor( smdCourse, "structureDescriptor", fieldsCourse);
				
		/* create KeyAspectDescriptor */
		FieldDescriptor[] keyFieldsCourse = new FieldDescriptor[1];
		keyFieldsCourse[0] = new FieldDescriptor("key", FieldDescriptor.STRING);
		StructureDescriptor keyStructureCourse = 
			new StructureDescriptor( smdCourse, "keyStructureCourse", keyFieldsCourse);

		KeyAspectDescriptor keyAspectDescriptorCourse = 
			new KeyAspectDescriptor( smdCourse, "CourseKey", "CourseKey desc", keyStructureCourse);

		AspectDescriptor aspectDescriptorCourse = new AspectDescriptor ( smdCourse, "Course",
			"course aspect", structureDescriptorCourse, keyAspectDescriptorCourse );

		/* create QueryDescriptor */
		FieldDescriptor[] findFieldsCourse = new FieldDescriptor[0];
		/* create StructureQueryModuleDescriptor */
		StructureDescriptor structureQueryDescriptorCourse = 
			new StructureDescriptor( smdCourse, "structureQueryDescriptorCourse", findFieldsCourse);
			
		/* create StructureOutputModuleDescriptor */
		aspectDescriptorCourse.addAspectActionDescriptor(
			new AspectActionDescriptor("findAllCourses", structureQueryDescriptorCourse, aspectDescriptorCourse));
	
		/* creating query descriptor for findAllCourses */
		QueryDescriptor queryDescriptorCourse = new QueryDescriptor("findAllCourses",
			"findAllCourses desc", keyAspectDescriptorCourse, structureQueryDescriptorCourse,
			 aspectDescriptorCourse, smdCourse);
		smdCourse.addQueryDescriptor(queryDescriptorCourse);
			
		/* relation Course-Student */
		RelationDescriptor relationDescriptorC_S = new RelationDescriptor(
							aspectDescriptorCourse.getName()+":students",CMICardinality.CARDINALITY_MANY,
							aspectDescriptorCourse, aspectDescriptorStudent);
		relationDescriptorC_S.addAttribute("collection", "true");
		relationDescriptorC_S.addAttribute("relation_attribute", "students");
		aspectDescriptorCourse.addRelationDescriptor(relationDescriptorC_S);
			
		smdCourse.addRelationDescriptor(relationDescriptorC_S);
						
		/* create FieldDescriptors */
		FieldDescriptor[] fieldsTeacher = new FieldDescriptor[5];
		fieldsTeacher[0] = new FieldDescriptor("key", FieldDescriptor.STRING);
		fieldsTeacher[1] = new FieldDescriptor("name", FieldDescriptor.STRING);
		fieldsTeacher[2] = new FieldDescriptor("description", FieldDescriptor.STRING);
		fieldsTeacher[3] = new FieldDescriptor("age", FieldDescriptor.INTEGER);
		fieldsTeacher[4] = new FieldDescriptor("id", FieldDescriptor.STRING);
			
		/* create StructureModuleDescriptor */
		StructureDescriptor structureDescriptorTeacher = 
			new StructureDescriptor( smdTeacher, "structureDescriptor", fieldsTeacher);
				
		/* create KeyAspectDescriptor */
		FieldDescriptor[] keyFieldsTeacher = new FieldDescriptor[1];
		keyFieldsTeacher[0] = new FieldDescriptor("key", FieldDescriptor.STRING);
		StructureDescriptor keyStructureTeacher = 
			new StructureDescriptor( smdTeacher, "keyStructureTeacher", keyFieldsTeacher);

		KeyAspectDescriptor keyAspectDescriptorTeacher = 
			new KeyAspectDescriptor( smdTeacher, "TeacherKey", "TeacherKey desc", keyStructureTeacher);

		AspectDescriptor aspectDescriptorTeacher = new AspectDescriptor ( smdTeacher, "Teacher",
			"Teacher aspect", structureDescriptorTeacher, keyAspectDescriptorTeacher );

		/* create QueryDescriptor */
		FieldDescriptor[] findFieldsTeacher = new FieldDescriptor[0];
		/* create StructureQueryModuleDescriptor */
		StructureDescriptor structureQueryDescriptorTeacher = 
			new StructureDescriptor( smdTeacher, "structureQueryDescriptorTeacher", findFieldsTeacher);
			
		/* create StructureOutputModuleDescriptor */
		aspectDescriptorTeacher.addAspectActionDescriptor(
			new AspectActionDescriptor("findAllTeachers", structureQueryDescriptorTeacher, aspectDescriptorTeacher));
	
		/* creating query descriptor for findAllTeachers */
		QueryDescriptor queryDescriptorTeacher = new QueryDescriptor("findAllTeachers",
			"findAllTeachers desc", keyAspectDescriptorTeacher, structureQueryDescriptorTeacher,
			 aspectDescriptorTeacher, smdTeacher);
		smdTeacher.addQueryDescriptor(queryDescriptorTeacher);
			
		RelationDescriptor relationDescriptorT_C = new RelationDescriptor(
							aspectDescriptorTeacher.getName()+":course",CMICardinality.CARDINALITY_ZERO_TO_ONE,
							aspectDescriptorTeacher, aspectDescriptorCourse);
		//relationDescriptorT_C.addAttribute("collection", "true");
		relationDescriptorT_C.addAttribute("source_ref_attribute", "course");
		aspectDescriptorTeacher.addRelationDescriptor(relationDescriptorT_C);
			
		smdTeacher.addRelationDescriptor(relationDescriptorT_C);
						
		/* create FieldDescriptors */
		FieldDescriptor[] fieldsAddress = new FieldDescriptor[6];
		fieldsAddress[0] = new FieldDescriptor("key", FieldDescriptor.STRING);
		fieldsAddress[1] = new FieldDescriptor("country", FieldDescriptor.STRING);
		fieldsAddress[2] = new FieldDescriptor("city", FieldDescriptor.STRING);
		fieldsAddress[3] = new FieldDescriptor("street", FieldDescriptor.STRING);
		fieldsAddress[4] = new FieldDescriptor("pcode", FieldDescriptor.STRING);
		fieldsAddress[5] = new FieldDescriptor("id", FieldDescriptor.INTEGER);
			
		/* create StructureModuleDescriptor */
		StructureDescriptor structureDescriptorAddress = 
			new StructureDescriptor( smdAddress, "structureDescriptor", fieldsAddress);
				
		/* create KeyAspectDescriptor */
		FieldDescriptor[] keyFieldsAddress = new FieldDescriptor[1];
		keyFieldsAddress[0] = new FieldDescriptor("key", FieldDescriptor.STRING);
		StructureDescriptor keyStructureAddress = 
			new StructureDescriptor( smdAddress, "keyStructureAddress", keyFieldsAddress);

		KeyAspectDescriptor keyAspectDescriptorAddress = 
			new KeyAspectDescriptor( smdAddress, "AddressKey", "AddressKey desc", keyStructureAddress);

		AspectDescriptor aspectDescriptorAddress = new AspectDescriptor ( smdAddress, "Address",
			"Address aspect", structureDescriptorAddress, keyAspectDescriptorAddress );

		/* create QueryDescriptor */
		FieldDescriptor[] findFieldsAddress = new FieldDescriptor[0];
		/* create StructureQueryModuleDescriptor */
		StructureDescriptor structureQueryDescriptorAddress = 
			new StructureDescriptor( smdAddress, "structureQueryDescriptorAddress", findFieldsAddress);
			
		/* create StructureOutputModuleDescriptor */
		aspectDescriptorAddress.addAspectActionDescriptor(
			new AspectActionDescriptor("findAllAddresss", structureQueryDescriptorAddress, aspectDescriptorAddress));
	
		/* creating query descriptor for findAllAddresses */
		QueryDescriptor queryDescriptorAddress = new QueryDescriptor("findAllAddresss",
			"findAllAddresss desc", keyAspectDescriptorAddress, structureQueryDescriptorAddress,
			 aspectDescriptorAddress, smdAddress);
		smdAddress.addQueryDescriptor(queryDescriptorAddress);
			
		/* Relation Student - Course */
		RelationDescriptor relationDescriptorS_C = new RelationDescriptor(
							aspectDescriptorStudent.getName()+":courses",CMICardinality.CARDINALITY_MANY,
							aspectDescriptorStudent, aspectDescriptorCourse);
		relationDescriptorS_C.addAttribute("collection", "true");
		relationDescriptorS_C.addAttribute("source_ref_attribute", "courses");
		aspectDescriptorStudent.addRelationDescriptor(relationDescriptorS_C);
		
		smdStudent.addRelationDescriptor(relationDescriptorS_C);
					
		/* Relation Student - Address */
		RelationDescriptor relationDescriptorS_A = new RelationDescriptor(
							aspectDescriptorStudent.getName()+":address",CMICardinality.CARDINALITY_MANY,
							aspectDescriptorStudent, aspectDescriptorAddress);
		relationDescriptorS_A.addAttribute("collection", "true");
		relationDescriptorS_A.addAttribute("source_ref_attribute", "addresses");
		aspectDescriptorStudent.addRelationDescriptor(relationDescriptorS_A);
		
		smdStudent.addRelationDescriptor(relationDescriptorS_A);

		/* Relation Teacher - Address */
		RelationDescriptor relationDescriptorT_A = new RelationDescriptor(
							aspectDescriptorTeacher.getName()+":address",CMICardinality.CARDINALITY_MANY,
							aspectDescriptorTeacher, aspectDescriptorAddress);
		relationDescriptorT_A.addAttribute("collection", "true");
		relationDescriptorT_A.addAttribute("source_ref_attribute", "addresses");
		aspectDescriptorTeacher.addRelationDescriptor(relationDescriptorT_A);
		
		smdTeacher.addRelationDescriptor(relationDescriptorT_A);
					
	}

	public java.util.Collection getServiceNames()throws RemoteException, ServiceException {
		Collection coll = new ArrayList();
		coll.add(STUDENT_SERVICE_NAME); 
		coll.add(COURSE_SERVICE_NAME); 
		coll.add(TEACHER_SERVICE_NAME); 
		coll.add(ADDRESS_SERVICE_NAME); 
		return coll;
	}

	public String getServiceModuleJndiKeys(String serviceName)throws RemoteException, ServiceException {
		/*
		String jndiKeysName="";
		if (serviceName.equals(STUDENT_SERVICE_NAME)) jndiKeysName="localejbs/sap.com/rixapp/StudentService";
		if (serviceName.equals(COURSE_SERVICE_NAME)) jndiKeysName="localejbs/sap.com/rixapp/CourseService";
		if (serviceName.equals(TEACHER_SERVICE_NAME)) jndiKeysName="localejbs/sap.com/rixapp/TeacherService";
		if (serviceName.equals(ADDRESS_SERVICE_NAME)) jndiKeysName="localejbs/sap.com/rixapp/AddressService";
		return jndiKeysName;
		*/
		return "localejbs/" + serviceName;
	}

	public ServiceModuleDescriptor getServiceModuleDescriptor(String serviceName)throws RemoteException, ServiceException {
		if (smdStudent == null || smdCourse == null || smdTeacher == null || smdAddress == null) {
			init();
		}
		if (serviceName.equals(STUDENT_SERVICE_NAME)) {
			return smdStudent;
		}
		else if (serviceName.equals(COURSE_SERVICE_NAME)) {
			return smdCourse;
		}
		else if (serviceName.equals(TEACHER_SERVICE_NAME)) {
			return smdTeacher;
		}
		else if (serviceName.equals(ADDRESS_SERVICE_NAME)) {
			return smdAddress;
		}
		else {
			throw new ServiceException("Service not found");
		}
	}
	
}
