/*
 * Created on 08.04.2004
 *
 */
package com.sap.caf.rt.ui.cool.metadata;

import com.sap.tc.col.client.metadata.api.*;
import java.util.HashMap;

/**
 * @author Sergey_Firsov
 * Describes the properties of a query.
 *
 */
public class QueryDescriptor extends OperationDescriptor
    implements IQueryDescriptor{

    private HashMap mAttributes;
    private AspectDescriptor resultAspectDescriptor;
    private ServiceModuleDescriptor serviceModuleDescriptor;

    /**
	 * empty constructor
	 */
	 public QueryDescriptor(){
    }

    /**
	 * @param name - name of QueryDescriptor 
	 * @param description - description of QueryDescriptor
	 * @param inputKeysDescriptor - KeyAspectDescriptor for input parameters of QueryDescriptor
	 * @param inputParameters - StructureDescriptor for input parameters of QueryDescriptor
	 * @param resultDescriptor - AspectDescriptor for result of QueryDescriptor
	 * @param serviceModuleDescriptor - ServiceModuleDescriptor for QueryDescriptor
	 */
	 public QueryDescriptor(String name, String description, KeyAspectDescriptor inputKeysDescriptor, StructureDescriptor inputParameters, AspectDescriptor resultDescriptor, ServiceModuleDescriptor serviceModuleDescriptor)
    {
        super(name, description, inputParameters, inputKeysDescriptor);
        mAttributes = new HashMap();
        if(resultDescriptor == null)
            throw new RuntimeException("resultAspectKeyDescriptor must not be null");
        resultAspectDescriptor = resultDescriptor;
        if(serviceModuleDescriptor == null)
        {
            throw new RuntimeException("serviceModuleDescriptor must not be null");
        } else
        {
            this.serviceModuleDescriptor = serviceModuleDescriptor;
            return;
        }
    }

    /**
	 *  Returns the descriptor of the result aspect of this query
	 */
	 public IAspectDescriptor getResultAspectDescriptor()
    {
        return resultAspectDescriptor;
    }

    /**
	 * Returns the descriptor of the service module in which this query 
	 * is cached.
	 */
	 public IServiceModuleDescriptor getServiceModuleDescriptor()
    {
        return serviceModuleDescriptor;
    }

    /**
    * Add attrubute value to specified attribute name 
	 * @param attributeName
	 * @param value
	 */
	 public void addAttribute(String attributeName, String value)
    {
        mAttributes.put(attributeName, value);
    }

    /**
	 * Returns the value that is stored in this query for the given attribute.
	 */
	public String getAttributeStringValue(String attributeName)
    {
        return (String)mAttributes.get(attributeName);
    }

    /**
	 * Returns an array with the names of all the attributes which 
	 * are set for this query
	 */
	public String[] getAttributeNames()
    {
        String attributes[] = new String[mAttributes.size()];
        mAttributes.keySet().toArray(attributes);
        return attributes;
    }

    /**
	 * Returns the paging mode supported by this query
	 */
	public String getAttributePagingMode()
    {
        String value = getAttributeStringValue("COL_PAGING_MODE");
        if(value == null)
            throw new UnsupportedOperationException("The system property 'COL_PAGING_MODE' is not provided by the backend!");
        switch((new Integer(value)).intValue())
        {
        case 2: // '\002'
            return "FORWARD";

        case 1: // '\001'
        default:
            return " ";
        }
    }

    /**
	 * returns a string representation of this AspectDescriptor
	 */
	public String toString()
    {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("  <QueryDescriptor name=\"").append(getName()).append("\">").append(nl);
        if(hasInputParameters())
            buf.append(getInputParameters().toString());
        buf.append("  </QueryDescriptor>").append(nl);
        return buf.toString();
    }

    /**
	 * Returns the input options structure for this query
	 */
	public IStructureDescriptor getInputOptions()
    {
        return serviceModuleDescriptor.getInputOptionsStructure();
    }

    /**
	 * Returns the sorting options structure for this query
	 */
	public IStructureDescriptor getSortingOptions()
    {
        return serviceModuleDescriptor.getSortingOptionsStructure();
    }

    /**
	 * Returns the selections structure for this query
	 */
	public IStructureDescriptor getSelections()
    {
        return serviceModuleDescriptor.getSelectionsStructure();
    }

    /**
	 * Returns whether the query has input keys
	 */
	public boolean hasInputKeys()
    {
        return getInputKeysDescriptor() != null;
    }
}
