/*
 * Created on 08.04.2004
 *
 */
package com.sap.caf.rt.ui.cool.metadata;

import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import java.util.*;

/**
 * @author Sergey_Firsov
 * Describes the properties of operation
 *
 */
public class OperationDescriptor extends AbstractDescriptor
{
    private HashMap mFieldAttributes;
    private String description;
    private StructureDescriptor inputParameters;
    private KeyAspectDescriptor inputKeysDescriptor;
	
    /**
	 * empty constructor
	 */
	public OperationDescriptor(){
    }


    /**
	 * @param name - name of Operation
	 * @param description - description of Operation
	 * @param inputParameters - StructureDescriptor for input parameters of Operation
	 * @param inputKeysDescriptor - KeyAspectDescriptor for input parameters of Operation
	 */
	protected OperationDescriptor(String name, String description, StructureDescriptor inputParameters, KeyAspectDescriptor inputKeysDescriptor)
    {
        super(name);
        mFieldAttributes = new HashMap();
        this.description = description;
        this.inputParameters = inputParameters;
        this.inputKeysDescriptor = inputKeysDescriptor;
    }

    /**
	 * @return description of Operation
	 */
	public String getDescription()
    {
        return description;
    }

    /**
	 * @return true if Operation has InputParameters
	 */
	public boolean hasInputParameters()
    {
        return inputParameters != null;
    }

    /**
	 * @return inputParameters of Operation
	 */
	public IStructureDescriptor getInputParameters()
    {
        return inputParameters;
    }

    /**
	 * @return inputKeyDescriptors of Operation
	 */
	public IKeyAspectDescriptor getInputKeysDescriptor()
    {
        return inputKeysDescriptor;
    }

    /**
	 * @param fieldName
	 * @param attributeName
	 * @return value of specified attridute for specified field name
	 */
	public String getFieldAttributeStringValue(String fieldName, String attributeName)
    {
        return getNestedAttributeStringValue(mFieldAttributes, fieldName, attributeName);
    }

    /**
	 * @param fieldName
	 * @return arrya of attributes for specified field name
	 */
	public String[] getFieldAttributeNames(String fieldName)
    {
        if(!hasInputParameters() || getInputParameters().getFieldDescriptor(fieldName) == null)
        {
            throw new IllegalArgumentException("No such field '" + fieldName + "' in input parameter structure of operation '" + getName() + "'");
        } else
        {
            Set attributeSet = getNestedAttributeNames(mFieldAttributes, fieldName);
            String attributes[] = new String[attributeSet.size()];
            attributeSet.toArray(attributes);
            return attributes;
        }
    }

    /**
    * add value for specified attribute name for specified field 
	 * @param fieldName
	 * @param attributeName
	 * @param value
	 */
	public void addFieldAttribute(String fieldName, String attributeName, String value)
    {
        addNestedAttribute(mFieldAttributes, fieldName, attributeName, value);
    }

    /**
	 * @param map
	 * @param keyName
	 * @param attributeName
	 * @return attribute value for the specified attribute name, key name and map
	 */
	private String getNestedAttributeStringValue(HashMap map, String keyName, String attributeName)
    {
        HashMap innerMap = (HashMap)map.get(keyName);
        if(innerMap != null)
            return (String)innerMap.get(attributeName);
        else
            return null;
    }

    /**
	 * @param map
	 * @param keyName
	 * @return set of attribute value for the specified key name and map
	 */
	private Set getNestedAttributeNames(HashMap map, String keyName)
    {
        HashMap innerMap = (HashMap)map.get(keyName);
        if(innerMap != null)
            return innerMap.keySet();
        else
            return new HashSet();
    }

    /**
    * add attribute value for the specified attribute name, key name and map
	 * @param map
	 * @param keyName
	 * @param attributeName
	 * @param value
	 */
	private void addNestedAttribute(HashMap map, String keyName, String attributeName, String value)
    {
        HashMap innerMap = (HashMap)map.get(keyName);
        if(innerMap == null)
        {
            innerMap = new HashMap();
            mFieldAttributes.put(keyName, innerMap);
        }
        innerMap.put(attributeName, value);
    }

}
