/*
 * Created on 08.04.2004
 *
 */
package com.sap.caf.rt.ui.cool.metadata;


import java.util.HashMap;

import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;

/**
 * @author Sergey_Firsov
 * Describes the properties of key aspect
 *
 */
public class KeyAspectDescriptor extends AspectDescriptor
    implements IKeyAspectDescriptor {
    private HashMap aspectDescriptors;

    /**
	 * empty constructor
	 */
	 public KeyAspectDescriptor(){
    }

    /**
	 * @param serviceModuleDescriptor - ServiceModuleDescriptor for KeyAspectDescriptor
	 * @param name - name of KeyAspectDescriptor
	 * @param description - description of KeyAspectDescriptor
	 * @param structure - Structure descriptor for KeyAspectDescriptor
	 */
	 public KeyAspectDescriptor(ServiceModuleDescriptor serviceModuleDescriptor, String name, String description, StructureDescriptor structure)
    {
        super(serviceModuleDescriptor, name, description, structure, null);
        aspectDescriptors = new HashMap();
        setKeyDescriptor(this);
    }

    /**
	 * 
	 */
	public boolean isKeyAspect()
    {
        return true;
    }

    /**
    * add aspect descriptor for this KeyAspectDescriptor
	 * @param descriptor
	 */
	 public void addAspectDescriptor(AspectDescriptor descriptor)
    {
        if(descriptor != null)
            aspectDescriptors.put(descriptor.getName(), descriptor);
    }

    /**
	 * Returns an array with the descriptors of all aspects associated 
	 * with this key aspect descriptor
	 */
	public IAspectDescriptor[] getAspectDescriptors()
    {
        IAspectDescriptor tmpArr[] = new AspectDescriptor[aspectDescriptors.size()];
        aspectDescriptors.values().toArray(tmpArr);
        return tmpArr;
    }

    /**
	 * Returns the descriptor of the associated aspect with the given name
	 */
	public IAspectDescriptor getAspectDescriptor(String aspectName)
    {
        return (IAspectDescriptor)aspectDescriptors.get(aspectName);
    }

    /**
	 *  returns a string representation of this KeyAspectDescriptor 
	 */
	public String toString()
    {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("  <KeyDescriptor name=\"").append(getName()).append("\">").append(nl);
        buf.append(getStructure().toString());
        buf.append("  </KeyDescriptor>").append(nl);
        return buf.toString();
    }

}
