/*
 * Created on 08.04.2004
 *
 */
package com.sap.caf.rt.ui.cool.metadata;

import java.util.HashMap;
import java.util.Locale;

import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.DdSimpleType;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.ISimpleType;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.logging.Location;
import com.sap.typeservices.IModifiableTextServices;
import com.sap.typeservices.ISimpleValueServices;
import com.sap.typeservices.ITextServices;

/**
 * @author Sergey_Firsov
 * Describes the properties of a specific field of a strcuture. 
 *
 */
public class FieldDescriptor
	extends AbstractDescriptor
	implements IFieldDescriptor, ITextServices, IDataProvider {

	private static HashMap sTypeMap;
	protected static final Location _logger =
		Location.getLocation(
			com.sap.caf.rt.ui.cool.metadata.FieldDescriptor.class);
	static {
		sTypeMap = new HashMap();
		sTypeMap.put("STRING", "string");
		sTypeMap.put("INTEGER", "integer");
		sTypeMap.put("DATE", "date");
		sTypeMap.put("BOOLEAN", "boolean");
		sTypeMap.put("TIMESTAMP", "timestamp");
		sTypeMap.put("DECIMAL", "decimal");
		sTypeMap.put("TIME", "time");
		sTypeMap.put("DOUBLE", "double");
		sTypeMap.put("BINARY", "binary");
		sTypeMap.put("VARIANT", "string");
	}

	private ISimpleType mSimpleType;
	private boolean mExtension;
	private StructureDescriptor mStructureDescriptor;
	public static final int TEXT_FIELDTEXT = 0;
	public static final int TEXT_SCRTEXT_S = 1;
	public static final int TEXT_SCRTEXT_M = 2;
	public static final int TEXT_SCRTEXT_L = 3;
	private String mType;
	private String mMaxlength;
	private String mDecimals;
	private String texts[];
	private HashMap mVariants;

	private HashMap mAttributes = new HashMap();
	
	/**
	 * empty constructor
	 */
	public FieldDescriptor() {
	}

	/**
	 * @param name - name of field
	 * @param type - type of field
	 */
	public FieldDescriptor(String name, String type) {
		this(name, type, "", "");
	}

	/**
	 * @param name - name of field
	 * @param type - type of field
	 * @param maxlength - max length of field
	 */
	public FieldDescriptor(String name, String type, String maxlength) {
		this(name, type, maxlength, "");
	}

	/**
	 * @param name - name of field
	 * @param type - type of field
	 * @param maxlength - max length of field
	 * @param decimals - decimal number for field
	 */
	public FieldDescriptor(
		String name,
		String type,
		String maxlength,
		String decimals) {
		this(name, type, maxlength, decimals, false);
	}

	/**
	 * @param name - name of field
	 * @param type - type of field
	 * @param maxlength - max length of field
	 * @param decimals - decimal number for field
	 * @param extension - extension of field
	 */
	public FieldDescriptor(
		String name,
		String type,
		String maxlength,
		String decimals,
		boolean extension) {
		super(name);
		mSimpleType = null;
		mVariants = new HashMap();
		setType(type);
		mMaxlength = maxlength;
		mDecimals = decimals;
		mExtension = extension;
		mStructureDescriptor = null;
		texts = new String[4];
	}

	/**
	* Set specified structure descriptor 
	 * @param structure
	 */
	void setStructureDescriptor(StructureDescriptor structure) {
		mStructureDescriptor = structure;
	}

	/**
	 * Returns the cool type of this field
	 */
	public String getType() {
		return mType;
	}

	/**
	* create simple type 
	 * @return
	 */
	public ISimpleType createSimpleType() {
		return createSimpleType(Locale.getDefault());
	}

	/**
	* create simple type for specified locale
	 * @param locale
	 * @return
	 */
	public ISimpleType createSimpleType(Locale locale) {
		String _method = "createSimpleType(Locale)";
		if (isVariant())
			throw new UnsupportedOperationException(
				"Cannot create ISimpleType: field '"
					+ getName()
					+ "' in structure '"
					+ mStructureDescriptor.getName()
					+ "' is of type "
					+ "VARIANT");
		XmlMap theMap = new XmlMap();
		XmlMap simpleTypeMap = new XmlMap();
		if (sTypeMap.containsKey(mType)) {
			simpleTypeMap.put("builtInType", sTypeMap.get(mType));
		} else {
			simpleTypeMap.put("builtInType", "string");
			if (_logger.beWarning())
				_logger.warningT(
					"createSimpleType(Locale)",
					"Unknown type " + mType + ", using string instead.");
		}
		String typeName =
			(mStructureDescriptor == null
				? ""
				: mStructureDescriptor.getName() + ".")
				+ getName();
		simpleTypeMap.put(
			"name",
			com
				.sap
				.dictionary
				.types
				.services
				.NamingService
				.Structure
				.getJavaNameFromBackendName(
					com
						.sap
						.dictionary
						.types
						.services
						.NamingService
						.Structure
						.getBackendNameFromABAPName(typeName)));
		if (!"".equals(mMaxlength)) {
			XmlMap schemaTypeMap = new XmlMap();
			if (mType.equals("DECIMAL")) {
				schemaTypeMap.put("totalDigits", mMaxlength);
				schemaTypeMap.put("fractionDigits", mDecimals);
			} else {
				schemaTypeMap.put("maxLength", mMaxlength);
			}
			simpleTypeMap.put("SchemaType", schemaTypeMap);
		}
		theMap.put("SimpleType", simpleTypeMap);
		ISimpleType theSimpleType = null;
		try {
			theSimpleType = DdSimpleType.makeNew(this, locale, theMap);
		} catch (DdException ex) {
			if (_logger.beError())
				_logger.errorT("createSimpleType(Locale)", ex.toString());
		}
		return theSimpleType;
	}

	/**
	 * Returns a simple type object which represents the type of this field
	 */
	public ISimpleType getSimpleType() {
		if (mSimpleType == null) {
			ServiceModuleDescriptor smd = mStructureDescriptor == null ?
			    null: 
				mStructureDescriptor.getServiceModuleDescriptor();
			Locale theLocale;
			if (smd != null)
				theLocale = smd.getLocale();
			else
				theLocale = Locale.US;
			mSimpleType = createSimpleType(theLocale);
		}
		return mSimpleType;
	}

	/**
	* set text for specified field
	 * @param fieldText
	 * @param scrText_s
	 * @param scrText_m
	 * @param scrText_l
	 */
	public void setTextInfo(
		String fieldText,
		String scrText_s,
		String scrText_m,
		String scrText_l) {
		texts[0] = fieldText;
		texts[1] = scrText_s;
		texts[2] = scrText_m;
		texts[3] = scrText_l;
	}

	/**
	 * Get text
	 */
	public String getText() {
		return getText(0);
	}

	/**
	 * get text 
	 */
	public String getText(int textId) {
		if (textId < 0 || textId > 3)
			throw new RuntimeException("Unknown text id " + textId);
		if (texts[textId] == null)
			return "";
		else
			return texts[textId];
	}

	/**
	 * Returns the structure descriptor for the given field variant
	 */
	public IStructureDescriptor getVariant(String variantName) {
		if (!isVariant())
			throw new UnsupportedOperationException(
				"Field '"
					+ getName()
					+ "' in structure '"
					+ mStructureDescriptor.getName()
					+ "' is not of type "
					+ "VARIANT");
		if (mVariants.containsKey(variantName))
			return (IStructureDescriptor) mVariants.get(variantName);
		else
			throw new IllegalArgumentException(
				"Undefined variant '"
					+ variantName
					+ "' for field '"
					+ getName()
					+ "' in structure '"
					+ mStructureDescriptor.getName()
					+ "'");
	}

	/**
	 * Returns whether this field descriptor describes a variant structure
	 */
	public boolean isVariant() {
		return "VARIANT" == mType;
	}

	/**
	 * Returns an array with the structure descriptors which are 
	 * possible variants for this field.
	 */
	public IStructureDescriptor[] getVariants() {
		if (!isVariant()) {
			throw new UnsupportedOperationException(
				"Field '"
					+ getName()
					+ "' in structure '"
					+ mStructureDescriptor.getName()
					+ "' is not of type "
					+ "VARIANT");
		} else {
			IStructureDescriptor structureDescriptors[] =
				new StructureDescriptor[mVariants.size()];
			mVariants.values().toArray(structureDescriptors);
			return structureDescriptors;
		}
	}

	/**
	* set specified descriptor
	 * @param descriptor
	 */
	public void addVariant(StructureDescriptor descriptor) {
		if (!isVariant())
			throw new UnsupportedOperationException(
				"Field '"
					+ getName()
					+ "' in structure '"
					+ mStructureDescriptor.getName()
					+ "' is not of type "
					+ "VARIANT");
		if (descriptor != null)
			mVariants.put(descriptor.getName(), descriptor);
	}

	/**
	 * returns a string representation of this FieldDescriptor
	 */
	public String toString() {
		String nl = System.getProperty("line.separator");
		StringBuffer buf = new StringBuffer();
		buf.append("  <Field name=\"").append(getName()).append("\"");
		buf.append(" type=\"").append(getType()).append("\"");
		buf.append(" </Field>").append(nl);
		return buf.toString();
	}

	/**
	 * Returns whether this field is an extension of the original structure
	 */
	public boolean isExtension() {
		return mExtension;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	public Object clone() {
		return null;
	}

	/**
	 * return column level
	 */
	public String getColumnLabel() {
		return getText(0);
	}

	/**
	 * return column level for specified locale
	 */
	public String getColumnLabel(Locale arg0) {
		return getText(0);
	}

	/**
	 * return description for FieldDescriptor
	 */
	public String getDescription() {
		return getText(0);
	}

	/**
	 * return description for specified locale
	 */
	public String getDescription(Locale arg0) {
		return getText(0);
	}

	/**
	 * return field label for FieldDescriptor 
	 */
	public String getFieldLabel() {
		String text = getText(2);
		if ("".equals(text))
			text = getText(3);
		if ("".equals(text))
			text = getText(1);
		return text;
	}

	/**
	 * return field label for specified locale
	 */
	public String getFieldLabel(Locale arg0) {
		return getFieldLabel();
	}

	/**
	 * return locale for FieldDescriptor
	 */
	public Locale getLocale() {
		if (mStructureDescriptor == null
			|| mStructureDescriptor.getServiceModuleDescriptor() == null) {
			return null;
		}
		return mStructureDescriptor.getServiceModuleDescriptor().getLocale();
	}

	/**
	 * return quick info for FieldDescriptor
	 */
	public String getQuickInfo() {
		return getDescription();
	}

	/**
	 * return quick info for specified locale
	 */
	public String getQuickInfo(Locale arg0) {
		return getDescription();
	}

	/**
	 * @param arg0
	 * @param arg1
	 * @return
	 * @throws DdException
	 */
	public boolean belongsToAppend(String arg0, String arg1)
		throws DdException {
		return false;
	}

	/**
	 * return class loader
	 */
	public ClassLoader getClassLoader() {
		return null;
	}

	/**
	 * return currency unit type for FieldDescriptor
	 */
	public ISimpleType getCurrencyUnitType(String arg0, Locale arg1)
		throws DdException {
		return null;
	}

	/**
	 * return data type for FieldDescriptor
	 */
	public IDataType getDataType(String arg0, Locale arg1, Object arg2)
		throws DdException {
		return null;
	}

	/**
	 * return data type for FieldDescriptor
	 */
	public IDataType getDataType(String arg0, Locale arg1) throws DdException {
		return null;
	}

	/**
	 * return text service for FieldDescriptor
	 */
	public ITextServices getTextService(ISimpleType arg0) throws DdException {
		return this;
	}

	/**
	 * return unit of measure type for FieldDescriptor
	 */
	public ISimpleType getUnitOfMeasureType(String arg0, Locale arg1)
		throws DdException {
		return null;
	}

	/**
	 * return value service for FieldDescriptor
	 */
	public ISimpleValueServices getValueService(ISimpleType arg0)
		throws DdException {
		return null;
	}

	/**
	 * return data type from cache for FieldDescriptor
	 */
	public IDataType getDataTypeFromCache(String name, Locale locale) {
		return null;
	}

	/**
	 * return true if needs translator
	 */
	public boolean needsTranslator() {
		boolean fake = true;
		return fake;
	}

	/**
	 *  return modifiable variant for FieldDescriptor
	 */
	public IModifiableTextServices getModifiableVariant() {
		return null;
	}

	protected void setType(String type) {
		//if (sTypeMap.containsValue(type)) {//containsKey(type)) {
			mType = type;
//		} else {
//			_logger.warningT(
//				"Field '"
//					+ name
//					+ "': unsupported type '"
//					+ type
//					+ "', using '"
//					+ "STRING"
//					+ "' instead");
//			mType = "STRING";
//		}
	}
	
	/**
   	* add attribute value to the specified attribute name
	* @param attributeName
	* @param value
	*/
   public void addAttribute(String attributeName, String value)
   {
	   mAttributes.put(attributeName, value);
   }

   /**
	* Returns the value that is stored in this relation for the given attribute
	*/
   public String getAttributeStringValue(String attributeName)
   {
	   return (String)mAttributes.get(attributeName);
   }

}
