/*
 * Created on 08.04.2004
 *
 */
package com.sap.caf.rt.ui.cool.metadata;

import com.sap.tc.col.client.metadata.api.*;
import java.util.Collection;
import java.util.HashMap;

/**
 * @author Sergey_Firsov
 * Describes the properties of an aspect group
 *
 */
public class AspectGroupDescriptor extends GroupDescriptor
    implements IAspectGroupDescriptor{

    private HashMap mFields;
    private HashMap mRelations;
    private HashMap mActions;
    private AspectDescriptor mAspectDescriptor;

    /**
	 * empty constructor
	 */
	 public AspectGroupDescriptor(){
    }

    /**
	 * @param name - name of AspectGroupDescriptor
	 * @param aspectDescriptor - AspectDescriptor for AspectActionDescriptor
	 */
	public AspectGroupDescriptor(String name, AspectDescriptor aspectDescriptor)
    {
        super(name);
        mAspectDescriptor = aspectDescriptor;
        aspectDescriptor.addAspectGroupDescriptor(this);
        mFields = new HashMap();
        mRelations = new HashMap();
        mActions = new HashMap();
    }

    /**
	 * Returns the aspect descriptor
	 */
	public AspectDescriptor getAspectDescriptor()
    {
        return mAspectDescriptor;
    }

    /**
	 * Add given descriptor
	 */
	public void addDescriptor(AbstractDescriptor descriptor)
    {
        if(descriptor instanceof FieldDescriptor)
            addFieldDescriptor((FieldDescriptor)descriptor);
        else
        if(descriptor instanceof RelationDescriptor)
            addRelationDescriptor((RelationDescriptor)descriptor);
        else
        if(descriptor instanceof AspectActionDescriptor)
            addAspectActionDescriptor((AspectActionDescriptor)descriptor);
        else
            throw new IllegalArgumentException("Descriptor type " + descriptor.getClass().getName() + " not allowed for aspect groups");
    }

    /**
	 * Returns the descriptor by specified name
	 */
	public AbstractDescriptor getDescriptor(String name)
    {
        AbstractDescriptor desc = (FieldDescriptor)getFieldDescriptor(name);
        if(desc == null)
            desc = (RelationDescriptor)getRelationDescriptor(name);
        if(desc == null)
            desc = (AspectActionDescriptor)getAspectActionDescriptor(name);
        return desc;
    }

    /**
	 * Returns an array with all of the descriptors in this group
	 */
	public AbstractDescriptor[] getDescriptors()
    {
        Collection allDescriptors = mFields.values();
        allDescriptors.addAll(mRelations.values());
        allDescriptors.addAll(mActions.values());
        AbstractDescriptor descriptors[] = new AbstractDescriptor[allDescriptors.size()];
        allDescriptors.toArray(descriptors);
        return descriptors;
    }

    /**
    * Add specified field descriptor  
	 * @param field
	 */
	public void addFieldDescriptor(FieldDescriptor field)
    {
        mFields.put(field.getName(), field);
    }

    /**
	 * Returns the field descriptor with the given name, if it is a member 
	 * of this group, otherwise null
	 */
	public IFieldDescriptor getFieldDescriptor(String fieldname)
    {
        return (FieldDescriptor)mFields.get(fieldname);
    }

    /**
	 * Returns an array with all the field descriptors in this group
	 */
	public IFieldDescriptor[] getFieldDescriptors()
    {
        IFieldDescriptor descriptors[] = new FieldDescriptor[mFields.size()];
        mFields.values().toArray(descriptors);
        return descriptors;
    }

    /**
    * Add specified relation descriptor
	 * @param relation
	 */
	public void addRelationDescriptor(RelationDescriptor relation)
    {
        mRelations.put(relation.getName(), relation);
    }

    /**
	 * Returns the relation descriptor with the given name, if it is a
	 * member of this group, otherwise null.
	 */
	public IRelationDescriptor getRelationDescriptor(String relationname)
    {
        return (IRelationDescriptor)mRelations.get(relationname);
    }

    /**
	 * Returns an array with all the relation descriptors in this group.
	 */
	public IRelationDescriptor[] getRelationDescriptors()
    {
        IRelationDescriptor descriptors[] = new RelationDescriptor[mRelations.size()];
        mRelations.values().toArray(descriptors);
        return descriptors;
    }

    /**
    * Add specified aspectAction descriptor
	 * @param aspectAction
	 */
	public void addAspectActionDescriptor(AspectActionDescriptor aspectAction)
    {
        mActions.put(aspectAction.getName(), aspectAction);
    }

    /**
	 * Returns the aspect action descriptor for the given name, if it is a 
	 * member of this group, otherwise null.
	 */
	public IAspectActionDescriptor getAspectActionDescriptor(String actionname)
    {
        return (AspectActionDescriptor)mActions.get(actionname);
    }

    /**
	 * Returns an array with all the aspect action descriptors in this group
	 */
	public IAspectActionDescriptor[] getAspectActionDescriptors()
    {
        IAspectActionDescriptor descriptors[] = new AspectActionDescriptor[mActions.size()];
        mActions.values().toArray(descriptors);
        return descriptors;
    }
}
