/*
 * Created on 08.04.2004
 *
 */
package com.sap.caf.rt.ui.cool.metadata;

import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;


/**
 * @author Sergey_Firsov
 * Describes the properties of an aspect action
 */
public class AspectActionDescriptor extends OperationDescriptor
    implements IAspectActionDescriptor{

    private ActionDescriptor actionDescriptor;
    private AspectDescriptor aspectDescriptor;

    /**
	 * empty constructor 
	 */
	public AspectActionDescriptor(){
    }

    /**
	 * @param name - name of AspectActionDescriptor
	 * @param structure - StructureDescriptor for AspectActionDescriptor 
	 * @param aspectDescriptor - AspectDescriptor for AspectActionDescriptor
	 */
	public AspectActionDescriptor(String name, StructureDescriptor structure, AspectDescriptor aspectDescriptor)
    {
        super(name, "no description", structure, (KeyAspectDescriptor)aspectDescriptor.getKeyDescriptor());
        actionDescriptor = new ActionDescriptor(name);
        this.aspectDescriptor = aspectDescriptor;
        aspectDescriptor.addAspectActionDescriptor(this);
    }

	/**
	 * Action descriptor created by this constructor will have aspectDescriptor with null value.
	 * @param name - name of AspectActionDescriptor
	 * @param structure - StructureDescriptor for AspectActionDescriptor
	 */
	public AspectActionDescriptor(String name, StructureDescriptor structure)
	{
		super(name, "no description", structure, null);
		actionDescriptor = new ActionDescriptor(name);
	}
	
    /**
	 * @return ActionDescriptor for this AspectActionDescriptor
	 */
	public ActionDescriptor getActionDescriptor()
    {
        return actionDescriptor;
    }

    /**
	 * @return IAspectDescriptor for this AspectActionDescriptor
	 */
	public IAspectDescriptor getAspectDescriptor()
    {
        return aspectDescriptor;
    }

    /**
	 * return attribute value by specified name
	 */
	public String getAttributeStringValue(String attributeName)
    {
        return getAspectDescriptor().getActionAttributeStringValue(getName(), attributeName);
    }

    /**
	 * Returns an array with the names of all the attributes which are set for this aspect action
	 */
	public String[] getAttributeNames()
    {
        return getAspectDescriptor().getActionAttributeNames(getName());
    }

	/**
	 * Returns an array with the names of all the attributes which are set for this aspect action in the specified aspect row
	 */
    public String[] getAttributeNames(String rowKey)
    {
        return getAspectDescriptor().getActionAttributeNames(rowKey, getName());
    }

    /**
	 * return attribute value by specified name and aspect row
	 */
	public String getAttributeStringValue(String rowKey, String attributeName)
    {
        return getAspectDescriptor().getActionAttributeStringValue(rowKey, getName(), attributeName);
    }

    /** 
	 * Returns which side effects are to be excpected when performing the action described by this descriptor.
	 */
	public int getAttributeAffects()
    {
        return getAspectDescriptor().getActionAttributeAffects(getName());
    }

    /**
	 * Returns which side effects are to be excpected when performing the action described by this descriptor on the given aspect row
	 */
	public int getAttributeAffects(String rowKey)
    {
        return getAspectDescriptor().getActionAttributeAffects(rowKey, getName());
    }

    /**
	 * Returns the name of the relation whose target aspect the action can affect for this aspect action
	 */
	public String getAttributeRelation()
    {
        return getAspectDescriptor().getActionAttributeRelation(getName());
    }

}
