/*
 * Created on Aug 8, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.sap.caf.rt.srv.util;

import java.util.Map;
import java.util.HashMap;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import java.util.Properties;

/**
 * @author i801993
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class EJBHomeFactory {
	private static EJBHomeFactory instance;
  	private Map homeInterfaces;
	private Context context;

	// This is private, and can't be instantiated directly
	private EJBHomeFactory() throws NamingException {
		homeInterfaces = new HashMap();
		// Get the context for caching purposes
		Properties props = System.getProperties();
		context = new InitialContext(props);
  	}

	public static EJBHomeFactory getInstance() throws NamingException {
		if (instance == null) {
			instance = new EJBHomeFactory();
		}
		return instance;
	}
	/**
	  * will get the ejb Remote home factory. 
	  * clients need to cast to the type of EJBHome they desire
	  *
	  * First it tries to search if the interface is already cashed
	  * @return the EJB Home corresponding to the homeName
	  */
	public EJBHome getRemoteHome(String jndiName, Class homeInterfaceClass) 
		throws NamingException {
	  	// See if we already have this interface cached
		EJBHome homeInterface = 
			(EJBHome)homeInterfaces.get(jndiName);
		// If not, look up with the supplied JNDI name
		if (homeInterface == null) {
			Object obj = context.lookup(jndiName);
			homeInterface =
			   (EJBHome)PortableRemoteObject.narrow(obj, homeInterfaceClass);
			// If this is a new ref, save for caching purposes
			homeInterfaces.put(jndiName, homeInterface);
		}
		return homeInterface;
	  }
	/**
	 * will get the ejb Local home factory. 
	 * clients need to cast to the type of EJBHome they desire
	 * 
	 * First it tries to search if the interface is already cashed
	 * @return the Local EJB Home corresponding to the homeName
	 */	  
	public EJBLocalHome getLocalHome(String jndiName) 
	  	throws NamingException {
		// See if we already have this interface cached
		EJBLocalHome localHomeInterface = 
	  		(EJBLocalHome)homeInterfaces.get(jndiName);
		// If not, look up with the supplied JNDI name
		if (localHomeInterface == null) {
			localHomeInterface = (EJBLocalHome)context.lookup(jndiName);
			// If this is a new ref, save for caching purposes
			homeInterfaces.put(jndiName, localHomeInterface);
		}
		return localHomeInterface;
	}
}
