/*
 * Created on 14.04.2004
 *
 */
package com.sap.caf.rt.srv;

import java.rmi.RemoteException;
import java.util.Collection;

import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.exception.ServiceException;

/**
 */
public interface IServiceAccess {

	public Collection readDataObject(String serviceName, String aspectName, java.util.Collection keys)throws RemoteException, ServiceException;
	public IDataContainerBean readRelatedDataObject(String serviceName, String aspectName, String parentServiceName, String parentAspect, String parentAspectKey)throws RemoteException, ServiceException;
	public IDataContainerBean updateDataObject(String serviceName, String aspectName, IDataContainerBean data)throws RemoteException, ServiceException;
	public IDataContainerBean createDataObject(String serviceName, String aspectName, IDataContainerBean data)throws RemoteException, ServiceException;
	public boolean deleteDataObject(String serviceName, String aspectName, Collection keys)throws RemoteException, ServiceException;
	public Collection findByDataObject(String serviceName, String queryName, Collection parameters)throws RemoteException, ServiceException;
	public Object invokeCustom(String serviceName, String operationName, Object parameters, Collection keys)throws RemoteException, ServiceException;
	public IDataContainerBean recalculate(String serviceName, IDataContainerBean data)throws RemoteException, ServiceException; 
}
