/*
 * Created on 2004-5-5
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.caf.rt.srv;

import java.util.Collection;

import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.metamodel.MetaModel;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;

/**
 * @author krasimir-k
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public abstract class ApplicationServiceBean implements SessionBean {
	private static final long serialVersionUID = 1;

	protected transient String objectGuid = null;
	private static final Location location =
		Location.getLocation(ApplicationServiceBean.class);
	protected SessionContext sessionContext;
	private static final String APPLICATION = ApplicationServiceBean.class.getName();
	private static final String JARM_REQUEST = "CAF:RT:BOL" + APPLICATION;

	public ApplicationInterface getMetadata() throws ServiceException {
		String method = "getMetadata()";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);

		try {
			MetaModel mmrReader = new MetaModel();

			Collection c =
				mmrReader.readMMRObjects(
					"com.sap.caf.metamodel",
					"ApplicationInterface",
					objectGuid);
			if ((c == null) || (c.size() == 0)) {
				throw new ServiceException(
					"APPSRV_GUID_NOT_FOUND_ERROR",
					new Object[] { objectGuid });
			}
			return (ApplicationInterface) c.toArray()[0];
		} catch (DataAccessException e) {
			location.throwing(method, e);
			throw new ServiceException(e.getMessage());
		} finally {
			CAFPublicLogger.exiting(
				user,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
	}
}
