/*
 * Created on 14.04.2004
 */
package com.sap.caf.rt.services.serviceaccess;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.srv.IDataContainerBean;

/**
 */
public class SimpleDataContainer implements IDataContainerBean {

	private Map propertiesMap = new HashMap();

	/**
	 * 
	 */
	public SimpleDataContainer() {
		super();
	}
	
	/**
	 * Constructor with list of property names
	 * @param propertyNames
	 */
	public SimpleDataContainer(List propertyNames) {
		setPropertyList(propertyNames);
	}
	

	/**
	 * Return property of container or <code>NullPointerException</code> occurs if not exist
	 */
	public Object getProperty(String propertyName) {
		return propertiesMap.get(propertyName);
	}
	

	/**
	 * Set property value of container 
	 */
	public void setProperty(String propertyName, Object propertyValue) {
		propertiesMap.put(propertyName, propertyValue);
	}
	

	/**
	 * Return the collection nof property names.
	 * @return instance of the unmodifiable collection.
	 */
	public List getPropertyList(){
		return Collections.unmodifiableList(new ArrayList(propertiesMap.keySet()));
	}
	
	
	
	/**
	 * Defines the property names for container
	 * @param propertyNames
	 */
	public void setPropertyList(List propertyNames){
		propertiesMap = new HashMap();
		if(propertyNames != null){
			int index = 0;
			for(Iterator it = propertyNames.iterator(); it.hasNext();){			
				propertiesMap.put(it.next(), null );
				index ++;
			}
		}
	}
	
	void apply(IDependentObject depO) throws Exception {
		if(depO!=null) {
			List properties = depO.getPropertyList(); 
			this.setPropertyList(properties);
			int size  = properties.size();
			for(int i = 0; i < size; i++){
				String propName = (String)properties.get(i);
				Object v = depO.getProperty(propName);
				
				if(v!=null) {
					if(v instanceof IDependentObject){ //process complex attribute
						SimpleDataContainer sdc = new SimpleDataContainer();
						sdc.apply((IDependentObject) v);
						v = sdc;
					} else if(v instanceof Collection) { //process collection of complex attributes
						if(((Collection)v).size()>0) {
							Object firstValue = null;
							for(Iterator it = ((Collection) v).iterator(); it.hasNext();) {
								firstValue = it.next();
							}
						
							if(firstValue!=null && firstValue instanceof IDependentObject) {
								Collection collSdc = new ArrayList();
					
								for(Iterator it = ((Collection) v).iterator(); it.hasNext();) {
									Object value = it.next();
									if(value instanceof IDependentObject){
										SimpleDataContainer sdc = new SimpleDataContainer();
										sdc.apply((IDependentObject) value);
										collSdc.add(sdc);
									}
								}
					
								v = collSdc;
							}
						}
					}
				}				
				
				setProperty(propName, v);
			}
		}
	}

}
