/*
 * Created on 14.04.2004
 *
 */
package com.sap.caf.rt.services.serviceaccess;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.jdo.JDOUnsupportedOptionException;
import javax.naming.InitialContext;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.util.QueryFilter;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.ui.cool.metadata.AspectDescriptor;
import com.sap.caf.rt.ui.cool.metadata.FieldDescriptor;
import com.sap.caf.rt.ui.cool.metadata.ServiceModuleDescriptor;
import com.sap.caf.rt.ui.cool.metadata.TypedFieldDescriptor;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;


/**
 * 
 */
public class ServiceWrapper {
	private static final String APPLICATION = ServiceWrapper.class.getName();
	private static final Location logger = Location.getLocation(APPLICATION);
	private static final String JARM_REQUEST = "CAF:RT:oal";
	private static final String jARMRequest = JARM_REQUEST+APPLICATION;

	
	public static String METHOD_FIND = "find";
	
	public static String KEY = "key";
	
	ServiceModuleDescriptor descriptor;
	ICAFServiceAccess owner;
	String serviceName;
	Object service;
	String jndi_key;

	/**
	 * 
	 */
	public ServiceWrapper(
		ICAFServiceAccess owner,
		ServiceModuleDescriptor descriptor) {
		this.owner = owner;
		this.descriptor = descriptor;
	}

	/**
	 * 
	 */
	public ServiceWrapper(
		ICAFServiceAccess owner,
		ServiceModuleDescriptor descriptor,
		String jndi_key) {
		this.owner = owner;
		this.descriptor = descriptor;
		this.jndi_key = jndi_key;
	}
	
	/* (non-Javadoc)
	 * @see com.sap.caf.rt.srv.accessservice.IServiceAccess#readDataObject(java.lang.String, java.lang.String, java.util.Collection)
	 */
	public Collection readDataObject(String aspectName, Collection keys)
		throws ServiceException {
		final String method = "readDataObject(String, Collection)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		try{		
			List result = new ArrayList();
			if(keys != null){
				for(Iterator it = keys.iterator(); it.hasNext();){
					String key = (String) it.next();
					try{			
						result.add(readDataObject(aspectName, key));
					}catch(Exception e){
						CAFPublicLogger.traceThrowableT(
							Severity.DEBUG,
							logger,
							method,
							"Error in " + method,
							e);
						logger.throwing(method, e);
					}
				}
			}
			return result;
		}finally{
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				logger, 1);

		}
	}

	/**
	 * Return IDataContainerBean by key
	 * @param aspectName
	 * @param key
	 * @return
	 * @throws ServiceException
	 */
	IDataContainerBean readDataObject(String aspectName, String key)
		throws ServiceException {
		IDataContainerBean result = null;
		Object srv = getService();
		try {
			Method meth = getReadDataObjectMethod(aspectName);
			key = this.resolveTechKey(key);
			Object[] pars = makeParametersOfReadObject(srv, aspectName, key);
			IDependentObject depO =  (IDependentObject)meth.invoke(srv, pars);
			result = this.convertToDataContainerBean(depO);
		} catch (Exception e) {
			handleException(e);
		}
		return result;
	}

	/* @depricated
	 * @see com.sap.caf.rt.srv.accessservice.IServiceAccess#readRelatedDataObject(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public IDataContainerBean readRelatedDataObject(
		String aspectName,
		String parentAspect,
		String parentAspectKey)
		throws ServiceException {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * Update Data object
	 * @see com.sap.caf.rt.srv.accessservice.IServiceAccess#updateDataObject(java.lang.String, java.lang.String, com.sap.caf.rt.srv.IDataContainerBean)
	 */
	public IDataContainerBean updateDataObject(
		String aspectName,
		IDataContainerBean data)
		throws ServiceException {
		IDataContainerBean result = null;
		try{		
			String key = resolveTechKey(aspectName, data);
			IDependentObject depO =  readDependentObject(aspectName, key);
			this.applyToDependentObject(depO, (SimpleDataContainer)data);			
			checkDates(depO, (SimpleDataContainer)data);
			updateDependentObject(aspectName, depO);
			//to set the changed values during update
			applyToDataContainerBean(data, depO);
			result = data;
		}catch(Exception e){
			handleException(e);
		}
		return result;
	}

	/**
	 * 
	 * @see com.sap.caf.rt.srv.accessservice.IServiceAccess#createDataObject(java.lang.String, java.lang.String, com.sap.caf.rt.srv.IDataContainerBean)
	 */
	public IDataContainerBean createDataContainerBean(
		String aspectName,
		IDataContainerBean data)
		throws ServiceException {
		IDataContainerBean result = null;
		try{
			IDependentObject depO =  createDependentObject(aspectName, data);
			applyToDependentObject(depO, (SimpleDataContainer)data);
			updateDependentObject(aspectName, depO);
			//to set the changed values during update
			applyToDataContainerBean(data, depO);
			result = data;
		}catch(Exception e){
			handleException(e);
		}
		return result;
	}

	/** Delete data objects by keys.
	 * @see com.sap.caf.rt.srv.accessservice.IServiceAccess#deleteDataObject(java.lang.String, java.lang.String, java.util.Collection)
	 */
	public boolean deleteDataObject(String aspectName, Collection keys)
		throws ServiceException {
		boolean result = false; 
		try{
			IAspectActionDescriptor actionDesc = descriptor.getOperationDescriptor(aspectName,
				ServiceModuleDescriptor.DELETE_OPERATION_TYPE);
			if(actionDesc!=null) {
				Method deleteMethod = findMethod(aspectName, actionDesc.getName());
				for(Iterator it = keys.iterator(); it.hasNext(); ){			
					String key = resolveTechKey((String)it.next());
					IDependentObject depO =  readDependentObject(aspectName, key);
					deleteMethod.invoke(getService(), new Object[]{depO});
				}
				result = true;
			} else {
				throw new ServiceException("METHOD_DESCRIPTOR_NOT_FOUND",
					new Object[] {ServiceModuleDescriptor.DELETE_OPERATION_TYPE, aspectName,
						service.getClass().getName()});
			}
		}catch(Exception e){
			handleException(e);
		}
		return result;
	}

	/**
	 * @see com.sap.caf.rt.srv.accessservice.IServiceAccess#findByDataObject(java.lang.String, java.lang.String, java.util.Collection)
	 */
	public Collection findByDataObject(String queryName, Collection parameters)
		throws ServiceException {
		Collection result = null;
		Object service = getService();

		Method method = null;
		Object[] args = null;
				
		IQueryDescriptor query = descriptor.getQueryDescriptor(queryName);
		if(query!=null && "true".equals(
			query.getAttributeStringValue(MetamodelHelper.FIND_BY_MULTIPLE_PARAMS_NAME))) {
			method = this.findMethod(service.getClass(), queryName);
			if(method!=null) {
				args = this.makeFindByMultParsParameters(parameters, query);
			}
		} else if(query!=null && "true".equals(
			query.getAttributeStringValue(MetamodelHelper.FIND_BY_KM_PROPERTY_SEARCH_NAME))) {
			method = this.findMethod(service.getClass(), queryName, 1);//using this method because exist more then one method with same name				
			if(method!=null) {
				args = this.makeFindByKMPropertySearchParameters(parameters, query);
			}
		} else {
			method = this.findMethod(service.getClass(), queryName);
			if(method!=null) {
				args = this.makeParameters(parameters, method.getParameterTypes());
			}
		}
		
		if(method != null){
			try{
				Object tmp_res = method.invoke(service, args);
				if(tmp_res instanceof Collection) {
					AspectDescriptor resultAspect = null;
					if(query!=null) {
						resultAspect = (AspectDescriptor) query.getResultAspectDescriptor();
					}
					
					if(resultAspect!=null && 
						("true".equals(query.getAttributeStringValue(MetamodelHelper.FIND_BY_KM_PROPERTY_SEARCH_NAME))
						|| "true".equals(query.getAttributeStringValue(MetamodelHelper.SEARCH_IDX_FOR_BO_IN_RELATED_DOC_NAME)) )) {
						result = readDataObject(resultAspect.getName(), (Collection)tmp_res);
					} else if(resultAspect!=null && 
						"true".equals(resultAspect.getAttributeStringValue("generic"))) { //support collections of simple type
						result = new ArrayList(((Collection)tmp_res).size());
						for(Iterator it = ((Collection)tmp_res).iterator(); it.hasNext(); ){
							SimpleDataContainer sc = new SimpleDataContainer();
							sc.setProperty("value", it.next());				
							result.add(sc);
						}	
					} else {
						result = convertToDataContainerBean((Collection) tmp_res);						
					}
				} else {
					if(query!=null) {
						AspectDescriptor resultAspect = (AspectDescriptor) query.getResultAspectDescriptor();
						if(resultAspect!=null && 
							"true".equals(resultAspect.getAttributeStringValue("generic"))) {
//							process query with simple type in return
							result = new ArrayList(1);
							// support arrays for return type
							if(method.getReturnType().isArray() && !(tmp_res instanceof byte[])){
								int arSize = Array.getLength(tmp_res);
								for(int n = 0; n < arSize; n++){
									SimpleDataContainer sc = new SimpleDataContainer();
									sc.setProperty("value", Array.get(tmp_res, n));				
									result.add(sc);
								}
							}else{							
								SimpleDataContainer sc = new SimpleDataContainer();
								sc.setProperty("value", tmp_res);						
								result.add(sc);
							}
						} else if(tmp_res!=null && tmp_res instanceof IDependentObject) { //if findBy method return single object (but not collection)
							IDataContainerBean retValue = convertToDataContainerBean((IDependentObject) tmp_res);
							result = new ArrayList(1);
							result.add(retValue);
						}
					} else {
						throw new ServiceException("QUERY_DESCRIPTOR_NOT_FOUND",
							new Object[] {queryName, service.getClass().getName()});
					}
				}
			}catch(Exception e){
				this.handleException(e);
			}
				
		} else {
			throw new ServiceException("QUERY_NOT_FOUND",
				new Object[] {queryName, service.getClass().getName()});
		}
		return result;
	}

	/*Invoke custom method
	 * @see com.sap.caf.rt.srv.accessservice.IServiceAccess#invokeCustom(java.lang.String, java.lang.String, java.lang.Object)
	 */
	public Object invokeCustom(String operationName, Object parameters, Collection keys)
		throws ServiceException {
		Object[] pars = new Object[0];
		if(parameters instanceof Object[]){
			pars = (Object[]) parameters;
		}else if( parameters instanceof java.util.Collection){
			pars = this.makeParameters((Collection)parameters);			
		}else if(parameters != null){		
			pars = new Object[]{parameters};
		}
		Method meth = findMethod(this.getService().getClass(), operationName);//,  pars.length);
		
		if(meth == null) {
			throw new ServiceException("METHOD_WITH_PARAMETERS_NOT_FOUND",
				new Object[] {operationName, new Integer(pars.length), getService().getClass().getName()});
		}
		
		Object result = null;
		try{
			Class[] paramTypes = meth.getParameterTypes();
			if (paramTypes!=null && paramTypes.length > 0 
				&& Collection.class.isAssignableFrom(paramTypes[0])) {
				Object[] parsNew = new Object[pars.length+1];

				List keyList = new ArrayList();				
				if(keys!=null) {
					for(Iterator it = keys.iterator(); it.hasNext(); ){			
						String key = resolveTechKey((String)it.next());
						keyList.add(key);
					}
				}
								
				parsNew[0] = keyList;
				System.arraycopy(pars, 0, parsNew, 1, pars.length);
				
				pars = parsNew;						
			}
			
			result = meth.invoke(getService(), pars);
		}catch(Exception e){
			this.handleException(e);
		}
		return result;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.srv.accessservice.IServiceAccess#recalculate(java.lang.String, com.sap.caf.rt.srv.IDataContainerBean)
	 */
	public IDataContainerBean recalculate(IDataContainerBean data)
		throws ServiceException {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * Return instance of caf service
	 * @return
	 */
	private Object getService() throws ServiceException {
		if (service == null) {
			try {
				InitialContext ic = new InitialContext();
				Object home = ic.lookup(getJNDI_KEY());
				Method cr_meth =
					home.getClass().getMethod("create", new Class[0]);
				service = cr_meth.invoke(home, new Object[0]);
			} catch (Exception e) {
				throw new ServiceException(e);
			}
		}
		return service;
	}

	/**
	 * Return JNDI key to lookup service 
	 * @return
	 */
	private String getJNDI_KEY() {
		return jndi_key;
	}

	//---------------
	
	/**
	 * Create instance of DependentObject
	 */
	private IDependentObject createDependentObject(String aspectName, IDataContainerBean bean)throws ServiceException{
		IDependentObject result = null;
		try{
			IAspectActionDescriptor actionDesc = descriptor.getOperationDescriptor(aspectName,
				ServiceModuleDescriptor.CREATE_OPERATION_TYPE);
			if(actionDesc!=null) {
				Object[] args = makeCreateParameters(aspectName, bean, actionDesc);
				Method createMethod = findMethod(aspectName, actionDesc.getName(), args.length);
				// support the complex mandatory attribute
				if((args!= null) || (args.length > 0))
					args = this.makeParameters(java.util.Arrays.asList(args),createMethod.getParameterTypes());
				result = (IDependentObject)createMethod.invoke(getService(), args);
				bean.setProperty("key", result.getKey());
			
				List propList = result.getPropertyList();
				for(int i=0;i<propList.size();++i) {
					String propName = (String) propList.get(i);
					Object propValue = result.getProperty(propName);
					if(propValue!=null
						&& !(propValue instanceof Collection && ((Collection)propValue).isEmpty())
						&& !(propValue instanceof String && "".equals(propValue))
						&& !(propValue instanceof Number && ((Number)propValue).intValue()==0)
						&& !(propValue instanceof Boolean && propValue.equals(new Boolean(false)))
						&& !(propValue instanceof Character && "".equals(propValue))) {
						bean.setProperty(propName, propValue);
					}
				}
			} else {
				throw new ServiceException("METHOD_DESCRIPTOR_NOT_FOUND",
					new Object[] {ServiceModuleDescriptor.CREATE_OPERATION_TYPE,
						aspectName, service.getClass().getName()});
			}
		}catch(Exception e){
			handleException(e);
		}
		return result;
	}
	
	/**
	 * Read DependentObject
	 * @param aspectName
	 * @param key
	 * @return
	 * @throws ServiceException
	 */
	private IDependentObject readDependentObject(String aspectName, String key) throws ServiceException {
		IDependentObject result = null;
		try{
			Method readMethod = getReadDataObjectMethod(aspectName);
			result = (IDependentObject) readMethod.invoke(getService(),new Object[]{key});
		}catch(Exception e){
			handleException(e);
		}
		return result;
	}

	/**
	 * Update dependent object
	 * @param aspectName
	 * @param depO
	 * @throws ServiceException
	 */
	private void updateDependentObject(String aspectName, IDependentObject depO) throws ServiceException{
		try{
			IAspectActionDescriptor actionDesc = descriptor.getOperationDescriptor(aspectName,
				ServiceModuleDescriptor.UPDATE_OPERATION_TYPE);
			if(actionDesc!=null) {
				Method readMethod = findMethod(aspectName, actionDesc.getName());
				readMethod.invoke(getService(),new Object[]{depO});
			} else {
				throw new ServiceException("METHOD_DESCRIPTOR_NOT_FOUND",
					new Object[] {ServiceModuleDescriptor.UPDATE_OPERATION_TYPE,
						aspectName, service.getClass().getName()});				
			}
		}catch(Exception e){
			handleException(e);
		}		
	}

	/**
	 * Return method of service that read data object with given name.
	 * @param aspectName - name of data object.
	 * @return Method instance.
	 * @throws ServiceException
	 */
	private Method getReadDataObjectMethod(String aspectName) throws Exception {
		IAspectActionDescriptor actionDesc = descriptor.getOperationDescriptor(aspectName,
			ServiceModuleDescriptor.READ_OPERATION_TYPE);
		if(actionDesc!=null) {
			return findMethod(aspectName, actionDesc.getName());
		} else {
			throw new ServiceException("METHOD_DESCRIPTOR_NOT_FOUND",
				new Object[] {ServiceModuleDescriptor.READ_OPERATION_TYPE,
					aspectName, service.getClass().getName()});			
		}
	}
	
	private Method getFindByMethod(IQueryDescriptor query) throws ServiceException{
		Object service = getService();
		Class serviceClass = service.getClass();
		return findMethod(serviceClass, query.getName());
	}

	/**
	 * Search first method with given name in class.
	 * @param cl
	 * @param methodName
	 * @return
	 */	
	private Method findMethod(String aspectName, String method) throws Exception {
		Object service = getService();
		Class serviceClass = service.getClass();
		Method m = findMethod(serviceClass, method);
		/*if(m == null){
			m = findMethod(serviceClass, method+aspectName);
		}*/
		
		if(m == null) {
			throw new ServiceException("METHOD_NOT_FOUND",
				new Object[] {method, serviceClass.getName()});
		}
		
		return m;
	}
	
	/**
	 * Search first method with given name in class.
	 * @param cl
	 * @param methodName
	 * @return
	 */	
	private Method findMethod(String aspectName, String method, int pars_count) throws Exception {
		Object service = getService();
		Class serviceClass = service.getClass();
		Method m = findMethod(serviceClass, method, pars_count);
		/*if(m == null){
			m = findMethod(serviceClass, method+aspectName, pars_count);
		}*/
		
		if(m == null) {
			throw new ServiceException("METHOD_WITH_PARAMETERS_NOT_FOUND",
				new Object[] {method, new Integer(pars_count), serviceClass.getName()});
		}
		
		return m;
	}
	

	/**
	 * Search first method with given name in class.
	 * @param cl
	 * @param methodName
	 * @return
	 */	
	private Method findMethod(Class cl, String methodName){
		Method[] meths = cl.getMethods();
		for(int i = 0; i < meths.length; i++){
			if(methodName.equals(meths[i].getName()))
				return meths[i];
		}
		return null;
		
	}
	
	/**
	 * 
	 * @param cl
	 * @param methodName
	 * @return
	 */
	private Method findDeclaredMethod(Class cl, String methodName) {
		Method[] meths = cl.getDeclaredMethods();
		for(int i = 0; i < meths.length; i++){
			if(methodName.equals(meths[i].getName()))
				return meths[i];
		}
		return null;
	}
	
	/**
	 * Search first method with given name in class.
	 * @param cl
	 * @param methodName
	 * @return
	 */	
	private Method findMethod(Class cl, String methodName, int pars_count){
		Method[] meths = cl.getMethods();
		for(int i = 0; i < meths.length; i++){
			if(methodName.equals(meths[i].getName()) && (meths[i].getParameterTypes().length == pars_count))			
				return meths[i];
		}
		return null;
	
	}
		
	/**
	 * Make parameters by  given Collection.
	 * @param pars - collection of parameters
	 * @return return array of Parameters
	 */
	private Object[] makeParameters(Collection pars){
		Object[] res = null;
		if(pars != null){
			res = pars.toArray();
		}
		return res;
	}

	/**
	 * Make parameters by  given Collection and array classes.
	 * @param pars - collection of parameters
	 * @return return array of Parameters
	 */
	private Object[] makeParameters(Collection pars, Class[] classes){
		Object[] res = null;
		if(classes != null){
			res = new Object[classes.length];
			Object par = null;
			Class parCl = null;
			Iterator it = null;
			if(pars != null)
				it = pars.iterator();
			for(int i = 0; i < classes.length; i++){
				parCl = classes[i];
				par =( (pars != null) && (it.hasNext()))? it.next(): null;
				if (parCl.isPrimitive()){
					if(par == null)
						par = getDefualtValueForType(parCl);
					if (	   ((parCl.isAssignableFrom(Integer.TYPE))&&(Integer.class.isInstance(par)))
						|| ((parCl.isAssignableFrom(Byte.TYPE))&&(Byte.class.isInstance(par)))  
						|| ((parCl.isAssignableFrom(Double.TYPE))&&(Double.class.isInstance(par)))  	
						|| ((parCl.isAssignableFrom(Float.TYPE))&&(Float.class.isInstance(par)))  	
						|| ((parCl.isAssignableFrom(Long.TYPE))&&(Long.class.isInstance(par) || Integer.class.isInstance(par)))  	
						|| ((parCl.isAssignableFrom(Short.TYPE))&&(Short.class.isInstance(par)))  	
						|| ((parCl.isAssignableFrom(Boolean.TYPE))&&(Boolean.class.isInstance(par)))  			   						
						){
						res[i] = par;
					}
					else {
						res[i] = null;
					}
				}else if(com.sap.caf.rt.bol.util.QueryFilter.class.isAssignableFrom(parCl)){
					res[i]= QueryFilter.getQueryFilter(par);
				}else if(parCl.isInstance(par)){
					res[i] = par;
				} else if(IDependentObject.class.isAssignableFrom(parCl) && (par instanceof IDataContainerBean)){
					try{
						IDependentObject dep = (IDependentObject) parCl.newInstance();
						this.applyToDependentObject(dep,(SimpleDataContainer)par);
						res[i]= dep;
					}catch(Exception e){
						res[i]= null;
					}
				}else{
					res[i] = null;
				}
			}
		}
		return res;
	}
	
	/**
	 * Make parameters for method findByMultParsParameters by given collection.
	 * @param pars - collection of parameters
	 * @return return array of Parameters
	 */
	private Object[] makeFindByMultParsParameters(Collection pars, IQueryDescriptor query){
		boolean isBwExtractOperation =
			"true".equals(query.getAttributeStringValue(
				MetamodelHelper.IS_BW_EXTRACT_OPERATION)) ? true : false;
				
		Object[] res = null;
		if(isBwExtractOperation) {
			res = new Object[1];	
		} else {
			res = new Object[3];
		}
		
		Map map = new HashMap();
		Object par = null;
		Iterator it = null;
		if(pars != null)
			it = pars.iterator();
		IStructureDescriptor desc = query.getInputParameters();
		int size = desc.size();
		for(int i = 0; i < size; i++) {
			par = ( (pars != null) && (it.hasNext()))? it.next(): null;
			FieldDescriptor fd = (FieldDescriptor)desc.getFieldDescriptor(i);
			Object key = fd.getName();
			if("true".equals(fd.getAttributeStringValue("isComplexSubattribute"))) {
				key = fd.getAttributeStringValue("sourceAttributeName") + 
					"." + fd.getAttributeStringValue("targetAttributeName");
			}
			if(par != null){
				Object value = QueryFilter.getQueryFilter(par);
				map.put(key, value);
			}
		}
		
		res[0] = map;
		
		if(res.length>1) {
			if("true".equals(query.getAttributeStringValue("implicitCheck"))) {
				res[1] = new Boolean(true);
			} else {
				res[1] = new Boolean(false);
			}
			res[2] = "findByMultipleParameters";
		}
		
		return res;
	}
	
	/**
	 * Make parameters for method findByKMPropertySearch by given collection.
	 * @param pars - collection of parameters
	 * @return return array of Parameters
	 */
	private Object[] makeFindByKMPropertySearchParameters(Collection pars, IQueryDescriptor query){
		Object[] res = new Object[1];
		ArrayList collectionAttrsAndCategories = new ArrayList();
		Object par = null;
		Iterator it = null;
		if(pars != null)
			it = pars.iterator();
		IStructureDescriptor desc = query.getInputParameters();
		int size = desc.size();
		for(int i = 0; i < size; i++) {
			par =( (pars != null) && (it.hasNext()))? it.next(): null;
			FieldDescriptor fd = (FieldDescriptor)desc.getFieldDescriptor(i);
			String key = fd.getName();
			//if("true".equals(fd.getAttributeStringValue("isComplexSubattribute"))) {
			//	key = fd.getAttributeStringValue("sourceAttributeName") + 
			//		"." + fd.getAttributeStringValue("targetAttributeName");
			//}
			
			QueryFilter value = null;
			if(par!=null || "STRING".equals(fd.getType())) {
				if(par!=null && !(par instanceof String)) {
					if(par instanceof Date) {
						if("createdAt".equalsIgnoreCase(key) || "lastChangedAt".equalsIgnoreCase(key)) {
							//par = String.valueOf(((Date)par).getTime());
						} else {
							par = String.valueOf(par);
						}
					} else {
						par = String.valueOf(par);					
					}
				}
				value = QueryFilter.getQueryFilter(par);
			}
			
			if(value!=null) {
				value.attribute = key;
				
				if(fd instanceof TypedFieldDescriptor) {
					if(((TypedFieldDescriptor)fd).getCategoryID()!=null 
						&& !"".equals(((TypedFieldDescriptor)fd).getCategoryID())) {
						value.operation = QueryFilter.OPERATION_CATEGORY;
						value.attribute = ((TypedFieldDescriptor)fd).getCategoryID();
					} else {
						value.operation = QueryFilter.OPERATION_ATTRIBUTE;
					}
				} else {
					value.operation = QueryFilter.OPERATION_ATTRIBUTE;
				}
				
				collectionAttrsAndCategories.add(value);
				
				QueryFilter andQueryFilter = new QueryFilter();
				andQueryFilter.operation = QueryFilter.OPERATION_AND;
				collectionAttrsAndCategories.add(andQueryFilter);
			}
		}
		
		if(collectionAttrsAndCategories.size()>0) {
			collectionAttrsAndCategories.remove(collectionAttrsAndCategories.size()-1);
		}
		
		res[0] = collectionAttrsAndCategories;
		
		return res;		
	}

	private Object[] makeParametersOfReadObject(
		Object srv,
		String aspect,
		String key) {
		return new Object[]{key};
	}
	
	/**
	 * Make input parameters for create method 
	 * @param aspectName
	 * @param depO
	 * @return
	 */
	private Object[] makeCreateParameters(String aspectName, IDataContainerBean bean, IAspectActionDescriptor actionDesc){
		Object[] result = new Object[0];

		List resultList = new ArrayList();
		IStructureDescriptor structureDesc = actionDesc.getInputParameters();
		if(structureDesc!=null) {
			IFieldDescriptor[] params = structureDesc.getFieldDescriptors();
			result = new Object[params.length];
			for(int i = 0; i < params.length; ++i) {
				String name = params[i].getName();
				resultList.add(bean.getProperty(name));
			}
		}		
		result = resultList.toArray();
		
		return result;
	}
	
	/**
	 * Handle given Exception.
	 * @param e
	 * @throws ServiceException
	 */
	private void handleException(Exception e) throws ServiceException{
		if(e instanceof InvocationTargetException){
			e = (Exception)((InvocationTargetException)e).getCause();
		}
		if(! (e instanceof ServiceException) )
			e = new ServiceException(e);

		throw (ServiceException)e;
	}
	
	/**
	 * Convert collection of ValueObjects from service layer to collection of DataContainerBean;
	 * @param coll the collection of IBusinessObject
	 * @return
	 */
	private Collection convertToDataContainerBean(Collection coll) throws Exception{
		Collection result = new ArrayList();
		if(coll != null){
			for(Iterator it = coll.iterator(); it.hasNext();){
				IDependentObject depO = (IDependentObject) it.next();
				IDataContainerBean dcb = convertToDataContainerBean(depO);
				result.add(dcb);
			}
		}
		return result;
	}
	
	private IDataContainerBean convertToDataContainerBean(IDependentObject depO) throws Exception{
		SimpleDataContainer dcb = new SimpleDataContainer(depO.getPropertyList());				
		dcb.apply(depO);
		return dcb;
	}
	
	/**
	 * Apply the value of DataContainerBean to value of IDependentObject
	 * @param depO
	 * @param bean
	 * @throws Exception
	 */
	private void applyToDependentObject(IDependentObject depO, SimpleDataContainer bean) throws Exception{
		List props = bean.getPropertyList();
		int size = props.size();
		for(int i = 0; i < size; i++){
			try{
				String propName = (String)props.get(i);
				Object propValue = bean.getProperty(propName);
				
				if(propValue!=null && (propValue instanceof SimpleDataContainer 
					|| isCollectionOfComplexAttributes(propValue))) {
					//convert first letter to upper case
					String methodName = null; 
					if (propName != null && propName.length() != 0 ) {
						methodName = ""+Character.toUpperCase(propName.charAt(0));
						if(propName.length()>1) { 
							methodName += propName.substring(1);
						}
					}

					Method method = null;
					Class clazz = null;
					if(propValue instanceof Collection) {
						methodName = "add"+methodName;
						//methodName = methodName.substring(0, methodName.length()-1);
						method = findMethod(depO.getClass(), methodName);
						if(method == null) {
							throw new ServiceException("METHOD_NOT_FOUND",
								new Object[] {methodName, depO.getClass().getName()});
						}
						clazz = method.getParameterTypes()[0];
						
						Collection propValues = getCollectionByProperty(depO, propName);
						
						for(Iterator it =((Collection) propValue).iterator(); it.hasNext(); ) {
							Object value =  it.next();
							IDependentObject depObj = (IDependentObject) clazz.newInstance();
							applyToDependentObject(depObj, (SimpleDataContainer) value);
							propValues.add(depObj);
						}
											
						depO.setProperty(propName, propValues);
					} else {
						methodName = "get"+methodName;
						method = findMethod(depO.getClass(), methodName);
						if(method == null) {
							throw new ServiceException("METHOD_NOT_FOUND",
								new Object[] {methodName, depO.getClass().getName()});
						}						
						clazz = method.getReturnType();
						
						IDependentObject depObj = (IDependentObject) clazz.newInstance();
						applyToDependentObject(depObj, (SimpleDataContainer) propValue);
					
						depO.setProperty(propName, depObj);						
					}
				} else {
					if(propValue instanceof Collection) {
						Collection propValues = getCollectionByProperty(depO, propName);
						propValues.addAll((Collection)propValue);
						
						depO.setProperty(propName, propValues);
					} else {
						depO.setProperty(propName, propValue);
					}
				}
			}catch(Exception e){
				if(!(e instanceof JDOUnsupportedOptionException &&
					"javax.jdo.option.ChangeApplicationIdentity".equals(e.getMessage()))) {
					logger.catching(e);
				}
			}
		}
	}
	
	private Collection getCollectionByProperty(IDependentObject depO, String propName) throws Exception {
		String methodName = "set" + Character.toUpperCase(propName.charAt(0));
		if(propName.length()>1) {
			methodName += propName.substring(1);
		}

		Method method = findDeclaredMethod(depO.getClass(), methodName);
		if(method == null) {
			throw new ServiceException("METHOD_NOT_FOUND",
				new Object[] {methodName, depO.getClass().getName()});
		}
		
		Class clazz = method.getParameterTypes()[0];
		if(clazz.isInterface()) {
			if(java.util.List.class.isAssignableFrom(clazz)) {
				return new ArrayList();				
			} else {
				return new HashSet();
			}
		} else {
			Collection collectionInstance = (Collection) clazz.newInstance();
			return collectionInstance;
		}	
	}
	
	/**
	 * Apply the values from dependent object to data container
	 */
	private void applyToDataContainerBean(IDataContainerBean dcb, IDependentObject depO) throws Exception{
		((SimpleDataContainer)dcb).apply(depO);
	}

	
	/**
	 * Return true if collection contains objects with type SimpleDataContainer
	 * @param propValue
	 * @return
	 */
	private boolean isCollectionOfComplexAttributes(Object propValue) {
		if(propValue!=null && propValue instanceof Collection) {
			Collection complexAttrs = (Collection) propValue;
			for(Iterator it = complexAttrs.iterator(); it.hasNext();) {
				Object value = it.next();
				if(value!=null && value instanceof SimpleDataContainer) {
					return true;
				}
			}
		}
		
		return false;
	}
	
	/**
	 * Return key
	 * @param aspectName
	 * @param bean
	 * @return
	 */
	private String resolveTechKey(String aspectName, IDataContainerBean bean){
		return (String)bean.getProperty(KEY);
	}
	
	/**
	 * Return key
	 * @param aspectName
	 * @param bean
	 * @return
	 */
	private String resolveTechKey(String original ){
		if((original!= null) && (original.startsWith("[")) && original.endsWith("]")){
			return original.substring(1,original.length()-1);
		}
		return original;
		
	}

	/**
	 *  Return the default value for primitive types
	 */
	private Object getDefualtValueForType(Class cl ){
		Object ret = null;
		if(cl.isAssignableFrom(Integer.TYPE)) {
			ret = new Integer(0);
		} else if(cl.isAssignableFrom(Byte.TYPE)) {
			ret = new Byte(Character.UNASSIGNED);
		} else if(cl.isAssignableFrom(Double.TYPE)) {
			ret = new Double(0.0);
		} else if(cl.isAssignableFrom(Float.TYPE)) {
			ret = new Float(0.0);
		} else if(cl.isAssignableFrom(Long.TYPE)) {
			ret = new Long(0);
		} else if(cl.isAssignableFrom(Short.TYPE)) {
			ret = new Short((short)0);
		} else if(cl.isAssignableFrom(Boolean.TYPE)) {
			ret = Boolean.FALSE;
		}
		return ret;
	}

	/**
	 *  Check optimistic locking, in case of bean is outdated the exception is thrown.
	 */
 	private void checkDates(IDependentObject depO, SimpleDataContainer bean) throws Exception{
		//if optimistic locking is disabled  - do nothing
		if(!CAFContext.OPTIMISTIC_LOCKING_ENABLED)
			return;
		Date pDate = null;
		if(depO instanceof IBusinessObject)
			pDate = ((IBusinessObject)depO).getLastChangedAt();
		Date bDate = (Date)bean.getProperty("lastChangedAt");
		if(pDate != null && bean != null){
			if(pDate.compareTo(bDate) > 0){
				CAFUpdateException e = new CAFUpdateException("BO_UPDATE");
				CAFPublicLogger.traceThrowableT(Severity.DEBUG,	logger, "checkDates", "Error in checkDates",	e);
				logger.throwing("checkDates", e);
				throw e;
			}
				
		}
	}

}

