package com.sap.caf.rt.services.serviceaccess;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.metamodel.RepositoryConnection;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.ip.mmr.IConnection;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @author c5050970
 *
 */
public class MetamodelHelperFactory {
	private static final String JARM_REQUEST = "CAF:RT:oal";
	private static final Location location =
		Location.getLocation(MetamodelHelperFactory.class);
		
	private static Map metamodelHelpers = new HashMap();
	private static long connectionCreatedTime = 0;

	public static synchronized MetamodelHelper getMetamodelHelper(Locale locale) throws DataAccessException {
		IConnection connection = RepositoryConnection.getConnection();
		long time = connection.getTimeLastDeployment();
		if(time > connectionCreatedTime) {
			metamodelHelpers.clear();
			RepositoryConnection.closeConnection();
		}
		
		Object metamodelHelper = metamodelHelpers.get(locale);
		if (metamodelHelper == null) {
			connectionCreatedTime = RepositoryConnection.getConnection().getTimeLastDeployment();
			metamodelHelper = createMetamodelHelper(locale);
		}
		return (MetamodelHelper)metamodelHelper;
	}

	private static synchronized MetamodelHelper createMetamodelHelper(Locale locale)
		throws DataAccessException {
		String method = "createMetamodelHelper(Locale)";
		CAFPublicLogger.entering(null, JARM_REQUEST, method, location);
		try {
			MetamodelHelper mmHelper = new MetamodelHelper(locale);
			mmHelper.reloadMetamodel();
			metamodelHelpers.put(locale, mmHelper);
			return mmHelper;
		} catch (DataAccessException ex) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error creating metamodel helper.",
				ex);
			location.throwing(method, ex);
			throw ex;
		} finally {
			CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
		}
	}
	
    public static synchronized void clearMetamodelCache () {
		metamodelHelpers.clear();
    }
}
