/*
 * Created on 14.04.2004
 */
package com.sap.caf.rt.services.serviceaccess;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;

import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.Permission;
import com.sap.caf.metamodel.Table;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.metamodel.RepositoryConnection;
import com.sap.caf.rt.services.localization.LocalizationResourceAccessor;
import com.sap.caf.rt.ui.cool.metadata.AspectActionDescriptor;
import com.sap.caf.rt.ui.cool.metadata.AspectDescriptor;
import com.sap.caf.rt.ui.cool.metadata.FieldDescriptor;
import com.sap.caf.rt.ui.cool.metadata.KeyAspectDescriptor;
import com.sap.caf.rt.ui.cool.metadata.QueryDescriptor;
import com.sap.caf.rt.ui.cool.metadata.RelationDescriptor;
import com.sap.caf.rt.ui.cool.metadata.ServiceModelProviderImpl;
import com.sap.caf.rt.ui.cool.metadata.ServiceModuleDescriptor;
import com.sap.caf.rt.ui.cool.metadata.StructureDescriptor;
import com.sap.caf.rt.ui.cool.metadata.TypedFieldDescriptor;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.caf.rt.ui.cool.metadata.TypedFieldDescriptorFactory;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.ResourceException;
import com.sap.tc.cmi.metadata.CMICardinality;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * This class used as container of service descriptors and can connect to MMR and transform it to webdynPro metamodel.
 */
public class MetamodelHelper {
	private static final Location location =
		Location.getLocation(MetamodelHelper.class);
	private static final boolean testMode = false;
		
	private static final String JARM_REQUEST = "CAF:RT:oal";
	private static final String APPLICATION = MetamodelHelper.class.getName();
	private static final String jARMRequest = JARM_REQUEST+APPLICATION;

	private Map descriptors = new HashMap();
	
	private Locale accessServiceLocale = null;
	
	private Map structureDescriptorsCashe = new HashMap();
	private Map aspectDescriptorsCashe = new HashMap();
	private Map keyAspectDescriptorsCashe = new HashMap();
	
	private static final Integer CARDINALITY_N = new Integer(-1);
	private static final Integer PATTERN_CUSTOM = new Integer(0);
	private static final Integer PATTERN_CREATE = new Integer(1);
	private static final Integer PATTERN_FIND_BY = new Integer(5);
	private static final Integer PATTERN_BW_EXTRACT_OPERATION = new Integer(8);
	
	private static final String ASPECT_SUBMIT_ACTION_NAME = "$submit$"; 
	private static final String KEY_ATTRIBUTE_NAME = "key";
	private static final String STRING_TYPE = "STRING";
	
	private Map aspectsApplicationAndProviderNames = new HashMap();
	
	private static final String INVALID_ATTRIBUTE_DICT_TYPE_0 = "";
	private static final String INVALID_ATTRIBUTE_DICT_TYPE_1 = "*";
	
	public static final String FIND_BY_MULTIPLE_PARAMS_NAME = "findByMultipleParameters";
	public static final String FIND_BY_KM_PROPERTY_SEARCH_NAME = "findByKMPropertySearch";
	public static final String SEARCH_IDX_FOR_BO_IN_RELATED_DOC_NAME = "searchidxForBOInRelatedDoc";
	
	//	category constants
	private static final String CATEGORY_NAME_START = "CATEGORY_";
	private static final String PARAM_NAME_CATEGORY_DESCRIPTION = "description"; 
	private static final String PARAM_NAME_CATEGORY_ID = "id";
	private static final String CATEGORY_SERVICE_JNDI_NAME = "localejbs/sap.com/caf.tc/CategoryService";
	
	//bw support constants
	public static final String IS_BW_EXTRACT_OPERATION = "is_BW_EXTRACT_OPERATION";
	
	//TypedFieldDescriptor support
	private TypedFieldDescriptorFactory tfdFactory = new TypedFieldDescriptorFactory();  
	
	// TODO IMPORTANT: USE CAFPublicLogger to print logging information
	/**
	 * 
	 */
	public MetamodelHelper(Locale locale) {
		super();
		accessServiceLocale = locale;
	}
	
	/**
	 * Return descriptor of service module
	 * @param serviceModuleId
	 * @return instance of IServiceModuleDescriptor
	 */
	public ServiceModuleDescriptor getServiceModuleDescriptor(String serviceModuleId){
		return (ServiceModuleDescriptor)descriptors.get(serviceModuleId);
	}
	
	/**
	 * Return list of services
	 * @return
	 */
	public Collection getServiceModuleNames(){
		return Collections.unmodifiableCollection(descriptors.keySet());
	}
	
	/**
	 * Return <code>true</code> if service with given name exist
	 * @param serviceModuleName
	 * @return
	 */
	public boolean serviceExists(String serviceModuleName){
		return descriptors.containsKey(serviceModuleName);
	}
	
	/**
	 * Return JNDI key to lookup service
	 * @param serviceModuleId
	 * @return
	 */
	public String getServiceJNDI_KEY(String serviceModuleId){
		return "localejbs/" + serviceModuleId;
	}

	/**
	 * Connect to MMR  and load Mof objects and transform to WebdynPro metamodel.
	 */	
	public void reloadMetamodel() throws DataAccessException {
		try {
			reloadMetamodel(null);
		} catch(DataAccessException e) {
			location.catching(e);
			throw e;			
		}
	}
	
	/**
	 * Reload metamodel
	 * @param metamodelPath
	 * @throws ConnectionException
	 */
	public void reloadMetamodel(String metamodelPath) throws DataAccessException {
		final String method = "reloadMetamodel(String)";
		CAFPublicLogger.entering(null, jARMRequest, method, location, 1);
//		descriptors = new HashMap();
//		structureDescriptorsCashe = new HashMap();
//		aspectDescriptorsCashe = new HashMap();
//		keyAspectDescriptorsCashe = new HashMap();
//		aspectsApplicationAndProviderNames = new HashMap(); 
		descriptors.clear();
		structureDescriptorsCashe.clear();
		aspectDescriptorsCashe.clear();
		keyAspectDescriptorsCashe.clear();
		aspectsApplicationAndProviderNames.clear();
		
		if(testMode){
			try{			
				ServiceModelProviderImpl testMMr = new ServiceModelProviderImpl();
				Collection col = testMMr.getServiceNames();
				for(Iterator it = col.iterator(); it.hasNext();){
					String serviceName = (String)it.next();
					descriptors.put(serviceName, testMMr.getServiceModuleDescriptor(serviceName));
				}
				return;
			}catch(Exception e){
				throw new DataAccessException(e);
			}finally {
				CAFPublicLogger.exiting(null, jARMRequest, method, location, 1);
			}
		}
		
		try {
			long time = System.currentTimeMillis();
			//make connection and transform metadata
			IConnection connection = RepositoryConnection.getConnection();
			long time2 = System.currentTimeMillis();
			Collection applications = getApplications(connection);
			long time3 = System.currentTimeMillis();
			transform(applications);
			long time4 = System.currentTimeMillis();
			
			location.debugT("** Connect to MMR repository time = "+(time2-time));
			location.debugT("** Get Applications time = "+(time3-time2));						
			location.debugT("** Transformation time = "+(time4-time3));
			location.debugT("***** Time = "+(time4-time));
		} finally {
			//RepositoryConnection.closeConnection();
			structureDescriptorsCashe.clear();
			aspectDescriptorsCashe.clear();
			keyAspectDescriptorsCashe.clear();
			aspectsApplicationAndProviderNames.clear();
			
			CAFPublicLogger.exiting(null, jARMRequest, method, location, 1);
		}
	}

	/**
	 * Get applications
	 * @param connection
	 * @return
	 */
	private Collection getApplications(IConnection connection) {
		List typeList = new ArrayList();
		typeList.add("com");
		typeList.add("sap");
		typeList.add("caf");
		typeList.add("metamodel");
		typeList.add("Application");
		
		Collection c = null;

		try {
			c = connection.queryM1(typeList, null, true);
		} catch (ResourceException ex) {
			location.catching(ex);
			return c;
		}

		return c;
	}
	
	/**
	 * Transform applications
	 * @param applications
	 */
	public void transform(Collection applications) {
		List interfaces  = new ArrayList();
		for(Iterator appIt = applications.iterator();appIt.hasNext();) {
			Application application = (Application) appIt.next();
			interfaces.addAll(processApplcation(application));
		}
		processAllRelations(interfaces);
	}
		
	/**
	 * Process application
	 * @param application
	 */	
	public List processApplcation(Application application) {
		List allInterfaces = new ArrayList();
		final String method = "processApplication(Application)";
		try {
			if(application!=null) {
				List businessInterfaces = new ArrayList();
				List applicationInterfaces = new ArrayList();
				
				for(Iterator it = application.getBaseObjects().iterator();it.hasNext();) {
					Object obj = it.next();
	
					if(obj instanceof BusinessEntityInterface) {
						businessInterfaces.add(obj);
					} else if(obj instanceof ApplicationInterface) {
						applicationInterfaces.add(obj);
					}
				}
				
				//add aspect descriptors
				int businessInterfacesSize = businessInterfaces.size();
				for(int i=0;i<businessInterfacesSize;++i) {
					processMOFInterface((MOFInterface)businessInterfaces.get(i));
				}
				int applicationInterfacesSize = applicationInterfaces.size();
				for(int i=0;i<applicationInterfacesSize;++i) {
					processMOFInterface((MOFInterface)applicationInterfaces.get(i));				
				}			
				
				allInterfaces.addAll(businessInterfaces);
				allInterfaces.addAll(applicationInterfaces);
			}
		} catch (Exception e) {
			CAFPublicLogger.traceThrowable(
				Severity.WARNING,
				location,
				method,
				e);
		}			
		return allInterfaces;
	}


	public void processAllRelations(List allInterfaces) {
		int allInterfacesSize = allInterfaces.size();
		for (int i = 0; i < allInterfacesSize; ++i) {
			processAspectsRelations(
				(MOFInterface) allInterfaces.get(i),
				allInterfaces);
		}
	}
	
	/**
	 * Preprocessing
	 * @param mofInterfaceImpl
	 */
	public void processAspectsRelations(MOFInterface mofInterfaceImpl, List allInterfaces) {
		//BOPublicLogger.entering(null, JARM_REQUEST, "collectAspects()", BOPublicLogger.LOC_CAF);
	
		ServiceModuleDescriptor serviceModuleDescriptor =
			(ServiceModuleDescriptor) descriptors.get(getObjectKey(mofInterfaceImpl));
		ClassLoader serviceClassLoader = getClassLoader(serviceModuleDescriptor);
		
		List operations = mofInterfaceImpl.getOperations();
		int size = operations.size();
		for(int i=0;i<size;++i) {
			Operation operation = (Operation) operations.get(i);
			if(operation==null || !checkOperation(operation)) {
				continue;
			}
			
			DataStructure aspect = getAspect(mofInterfaceImpl, operation);
			//location.infoT("aspect = "+aspect);
			
			if(aspect!=null) {
//				location.infoT("aspect = "+aspect.getObjectName());
				addRelationDescriptors(aspect, 
						serviceModuleDescriptor, serviceClassLoader, allInterfaces);
			}
			
			//process relations for aspects from referenced input parameters of operation
			Message inputMessage = operation.getInput();
			if(!(mofInterfaceImpl instanceof BusinessEntityInterface 
				&& isCRUDOperation(operation)) 
				&& inputMessage!=null) {
				List inputParameters = inputMessage.getMessageParts();
				if(inputParameters!=null) {
					int inputSize = inputParameters.size();
					for(int k=0;k<inputSize;++k) {
						Attribute attr = (Attribute) inputParameters.get(k);
						if(attr!=null) {
							DataStructure parameterAspect = attr.getReferencedObject();
							if(parameterAspect!=null) {
//								location.infoT("aspect = "+parameterAspect.getObjectName());
								addRelationDescriptors(parameterAspect, 
										serviceModuleDescriptor, serviceClassLoader, allInterfaces);
							}
						}
					}
				}
			}
		}
		//BOPublicLogger.exiting(null, JARM_REQUEST, "collectAspects()", BOPublicLogger.LOC_CAF);		
	}
	
	private DataStructure getAspect(MOFInterface mofInterfaceImpl, Operation operation) {
		if(mofInterfaceImpl instanceof BusinessEntityInterface) {
			return ((BusinessEntityInterface)mofInterfaceImpl).getBusinessEntity();
		} else {
//			Message inputMessage = operation.getInput();
//			List inputMessageAttributes = inputMessage.getMessageParts();
//			if(inputMessageAttributes!=null) {
//				for(int j=0;j<inputMessageAttributes.size();++j) {
//					Attribute attr = (Attribute)inputMessageAttributes.get(j);
//					if(attr.getReferencedObject()!=null) {
//						return attr.getReferencedObject();
//					}					
//				}
//			}

			Message outputMessage = operation.getOutput();
			if(outputMessage!=null) {
				List outputMessageAttributes = outputMessage.getMessageParts();
				if(outputMessageAttributes!=null) {
					int size = outputMessageAttributes.size();
					for(int j=0;j<size;++j) {
						Attribute attr = (Attribute)outputMessageAttributes.get(j);
						if(attr!=null) {
							DataStructure refObj = attr.getReferencedObject();
							if(refObj!=null) {
								return refObj;
							}
						}					
					}
				}
			}//handling delete and update operation (from CRUD) in application 
			else if(operation!=null 
				&& operation.getPatternType()!=null
				&& (operation.getPatternType().intValue()==3 
					|| operation.getPatternType().intValue()==4)) {
				Message inputMessage = operation.getInput();
				if(inputMessage!=null) {
					List inputMessageAttributes = inputMessage.getMessageParts();
					if(inputMessageAttributes!=null) {
						int size = inputMessageAttributes.size();
						for(int j=0;j<size;++j) {
							Attribute attr = (Attribute)inputMessageAttributes.get(j);
							if(attr!=null) {
								DataStructure refObj = attr.getReferencedObject();
								if(refObj!=null) {
									return refObj;
								}
							}					
						}
					}
				}
			}
		}
		return null;
	}
	
	/**
	 * @param mofInterfaceImpl
	 * @param descriptorKey
	 */	
	public void processMOFInterface(MOFInterface mofInterfaceImpl) {
		final String method = "processMOFInterface(MofInterface)";
		//BOPublicLogger.entering(null, JARM_REQUEST, "processMOFInterface()", BOPublicLogger.LOC_CAF);
		
		try {
			String objectKey = getObjectKey(mofInterfaceImpl);
			ServiceModuleDescriptor serviceModuleDescriptor = 
				new ServiceModuleDescriptor(objectKey,
					mofInterfaceImpl.getShortText(), "configuration", "configuration desc", accessServiceLocale);
			descriptors.put(objectKey, serviceModuleDescriptor);
			ClassLoader serviceClassLoader = getClassLoader(serviceModuleDescriptor);
								
			if(mofInterfaceImpl instanceof BusinessEntityInterface) {
				serviceModuleDescriptor.addAttribute("MOFInterfaceType", "BusinessEntityInterface");
				
				DataObject dataObject = ((BusinessEntityInterface) mofInterfaceImpl).getBusinessEntity();
				if(dataObject != null) {
					Table masterTable = dataObject.getMasterTable();
					if(masterTable != null) {
							//Added for BW integration
							serviceModuleDescriptor.addAttribute(BE_TABLE_PARAM_NAME,
								masterTable.getTableName());
					}
				}
			} else if(mofInterfaceImpl instanceof ApplicationInterface) {
				serviceModuleDescriptor.addAttribute("MOFInterfaceType", "ApplicationInterface");
			}
			addAttributeIfServiceIsClassifiable(
				mofInterfaceImpl,
				serviceModuleDescriptor);
	
			List operations = mofInterfaceImpl.getOperations();
			int size = operations.size();
			for(int i=0;i<size;++i) {
				// if process of one of the operation is wrong - continue
				try {
					Operation operation = (Operation) operations.get(i);
					boolean isFindByMultipleParametersOperation = false;
					if(operation == null) {
						continue;
					}
					if(!checkOperation(operation)) {
						if(FIND_BY_MULTIPLE_PARAMS_NAME.equals(operation.getObjectName()) 
							|| PATTERN_BW_EXTRACT_OPERATION.equals(operation.getPatternType())) {
							isFindByMultipleParametersOperation = true;
						} else {
							continue;							
						}
					}
					
					DataStructure aspect = getAspect(mofInterfaceImpl, operation);
					//location.infoT("aspect = "+aspect);
					
					Message outputMessage = operation.getOutput();
					Message inputMessage = operation.getInput();
					
					if(aspect!=null) {
//						location.infoT("aspect = "+aspect.getObjectName());
						if(mofInterfaceImpl instanceof BusinessEntityInterface) {
							serviceModuleDescriptor.addAttribute("BusinessEntityName", 
											getDataObjectNameFromAspect(aspect));
						} 
									
						StructureDescriptor inputParameters = getStructureDescriptor(
								aspect, serviceModuleDescriptor, serviceClassLoader); 
						KeyAspectDescriptor keyAspectDescriptor = getKeyAspectDescriptor(
								aspect, serviceModuleDescriptor, serviceClassLoader, true);
												
						AspectDescriptor resultDescriptor = getAspectDescriptor(
							serviceModuleDescriptor,
							aspect, inputParameters, keyAspectDescriptor, true, null);
					
						if (mofInterfaceImpl instanceof BusinessEntityInterface) {
							Boolean isSearchAndRetrieval = ((BusinessEntityInterface)mofInterfaceImpl).
								isSearchAndRetrieval();
							if(isSearchAndRetrieval != null 
								&& isSearchAndRetrieval.booleanValue()) {
								addKMMethods(serviceModuleDescriptor, serviceClassLoader,
									keyAspectDescriptor, inputParameters, resultDescriptor);
							}
						}
					
						if(PATTERN_FIND_BY.equals(operation.getPatternType()) 
							|| PATTERN_BW_EXTRACT_OPERATION.equals(operation.getPatternType())) {
							StructureDescriptor inputStructure = getOperationStructureDescriptor(
									serviceModuleDescriptor, serviceClassLoader, 
									serviceModuleDescriptor.getName()+"_"+operation.getObjectName(), 
									operation, isFindByMultipleParametersOperation);
								
							QueryDescriptor queryDescriptor = new QueryDescriptor(operation.getObjectName(),
								operation.getShortText(),keyAspectDescriptor,inputStructure,resultDescriptor,
								serviceModuleDescriptor);
								
							if(isFindByMultipleParametersOperation) {
								queryDescriptor.addAttribute("findByMultipleParameters", "true");
								
								Permission perm = operation.getPermission();
								if(perm!=null) {
									Integer implCheck = perm.getImplicitCheck();
									if(implCheck!=null && implCheck.intValue() == 1) {
										queryDescriptor.addAttribute("implicitCheck", "true");
									}
								}
							}
					
							serviceModuleDescriptor.addQueryDescriptor(queryDescriptor);
							
							if(PATTERN_BW_EXTRACT_OPERATION.equals(operation.getPatternType())) {
								queryDescriptor.addAttribute(IS_BW_EXTRACT_OPERATION, "true");
							}
						} else if(isCRUDOperation(operation)) {
							StructureDescriptor inputStructure = getOperationStructureDescriptor(
									serviceModuleDescriptor, serviceClassLoader,
									serviceModuleDescriptor.getName()+"_"+operation.getObjectName(), 
									operation, false);
								
							String operationType = "";
							int patternType = operation.getPatternType().intValue();
							if(patternType == 1) {
								operationType = ServiceModuleDescriptor.CREATE_OPERATION_TYPE;
							} else if(patternType == 2) {
								operationType = ServiceModuleDescriptor.READ_OPERATION_TYPE;
							} else if(patternType == 3) {
								operationType = ServiceModuleDescriptor.UPDATE_OPERATION_TYPE;
							} else if(patternType == 4) {
								operationType = ServiceModuleDescriptor.DELETE_OPERATION_TYPE;
							}
												
							serviceModuleDescriptor.addOperationDescriptor(resultDescriptor.getName(), 
								new AspectActionDescriptor(operation.getObjectName(), inputStructure),
								operationType);
							
							/*AspectGroupDescriptor aspectGroupDescriptor = (AspectGroupDescriptor) 
								resultDescriptor.getAspectGroupDescriptor(CRUD_GROUP_DESCRIPTOR_NAME);
							if(aspectGroupDescriptor == null) {
								aspectGroupDescriptor = new AspectGroupDescriptor(
									CRUD_GROUP_DESCRIPTOR_NAME, resultDescriptor);
							}
								
							StructureDescriptor inputStructure = getOperationStructureDescriptor(serviceModuleDescriptor, 
								serviceModuleDescriptor.getName()+"_"+operation.getObjectName(), operation);
												
							aspectGroupDescriptor.addAspectActionDescriptor(
								new AspectActionDescriptor(operation.getObjectName(), inputStructure));*/
						} else if(outputMessage==null || outputMessage.getMessageParts()==null ||
							outputMessage.getMessageParts().size()==0) {
							StructureDescriptor inputStructure = getOperationStructureDescriptor(
								serviceModuleDescriptor, serviceClassLoader, 
								serviceModuleDescriptor.getName()+"_"+operation.getObjectName(), 
								operation, false);
							resultDescriptor.addAspectActionDescriptor(
								new AspectActionDescriptor(operation.getObjectName(),
									inputStructure, resultDescriptor));
						} else if(outputMessage!=null) {
							//transform action with DS in output parameter into the query
							List outputMessageParts = outputMessage.getMessageParts();
							if(outputMessageParts!=null && outputMessageParts.size()>0) {
								Attribute outputAttr = (Attribute) outputMessageParts.get(0);
							
								if(outputAttr!=null && outputAttr.getReferencedObject()!=null) {							
									StructureDescriptor inputStructure = getOperationStructureDescriptor(
										serviceModuleDescriptor, serviceClassLoader, 
										serviceModuleDescriptor.getName()+"_"+operation.getObjectName(), 
										operation, false);
								
									QueryDescriptor queryDescriptor = new QueryDescriptor(operation.getObjectName(),
										operation.getShortText(),keyAspectDescriptor,inputStructure,resultDescriptor,
										serviceModuleDescriptor);
					
									serviceModuleDescriptor.addQueryDescriptor(queryDescriptor);
								}
							}							
						}
						
						List attrs = aspect.getAttributes();
						int attrSize = attrs.size();
						for(int j=0;j<attrSize;++j) {
							Attribute attr = (Attribute) attrs.get(j);
							if(attr!=null && CARDINALITY_N.equals(attr.getMaxOccurs()) 
								&& attr.getReferencedObject()==null) {
								processCollectionAttribute(attr, aspect, resultDescriptor, serviceModuleDescriptor);	
							}
						}
					} else if(outputMessage!=null) {
						List outputMessageParts = outputMessage.getMessageParts();
						if(outputMessageParts!=null && outputMessageParts.size()>0) {
							Attribute outputAttr = (Attribute) outputMessageParts.get(0);
							
							// Process action with simple dictionary type in return.
							if(outputAttr!=null && outputAttr.getReferencedObject()==null) {
								String operationName = operation.getObjectName();
								String outputAttrName = outputAttr.getObjectName();
								
								String structName = "ASPECT_" + operationName+"_"+outputAttrName;
						
								FieldDescriptor[] fields = new FieldDescriptor[2];
								fields[0] = tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null);
								fields[1] = tfdFactory.getTypedFieldDescriptor(
									"value", null, outputAttr.getTypeJavaDdic(),
									getClassLoader(serviceModuleDescriptor),
									accessServiceLocale);
			
								StructureDescriptor attrsDescriptor =
									new StructureDescriptor(serviceModuleDescriptor, structName, fields);
			
								FieldDescriptor[] keyfields = new FieldDescriptor[1];
								keyfields[0] = tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null);
			
								StructureDescriptor structureDescriptor =
									new StructureDescriptor(serviceModuleDescriptor, structName, keyfields);
								KeyAspectDescriptor keyAttrsDescriptor = new KeyAspectDescriptor(
									serviceModuleDescriptor, "KEY_"+structName, "Dinamically_created_aspect",
									structureDescriptor);
								
								AspectDescriptor aspectDescriptor = new AspectDescriptor(
									serviceModuleDescriptor, operationName+"_"+outputAttrName,
									outputAttr.getShortText(), attrsDescriptor, keyAttrsDescriptor);		
								aspectDescriptor.addAttribute("generic", "true");
								
								createEmptySubmitAction(aspectDescriptor, serviceModuleDescriptor);
								
								//input parameters descriptors 
								StructureDescriptor inputStructure = getOperationStructureDescriptor(
										serviceModuleDescriptor, serviceClassLoader,  
										serviceModuleDescriptor.getName()+"_"+operationName, 
										operation, false);
								
								FieldDescriptor[] inputKeyfields = new FieldDescriptor[1];
								inputKeyfields[0] = tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null);
								StructureDescriptor inputStructureDescriptor =
									new StructureDescriptor(serviceModuleDescriptor, "INPUT_"+structName, inputKeyfields);
								KeyAspectDescriptor inputKeyAttrsDescriptor = new KeyAspectDescriptor(
									serviceModuleDescriptor, "INPUT_KEY_"+structName, "Dinamically_created_aspect",
									inputStructureDescriptor);
								
								QueryDescriptor queryDescriptor = new QueryDescriptor(operationName,
									operation.getShortText(), inputKeyAttrsDescriptor, inputStructure, aspectDescriptor,
									serviceModuleDescriptor);
								serviceModuleDescriptor.addQueryDescriptor(queryDescriptor); 
							}
						}
					}
					
					//create aspects from referenced input parameters of operation
					if(!(mofInterfaceImpl instanceof BusinessEntityInterface 
						&& isCRUDOperation(operation))
						&& inputMessage!=null) {
						List inputParameters = inputMessage.getMessageParts();
						if(inputParameters!=null) {
							int inputSize = inputParameters.size();
							for(int k=0;k<inputSize;++k) {
								Attribute attr = (Attribute) inputParameters.get(k);
								if(attr!=null) {
									DataStructure parameterAspect = attr.getReferencedObject();
									if(parameterAspect!=null) {
										StructureDescriptor parameterAspectStructure = 
											getStructureDescriptor(parameterAspect, 
													serviceModuleDescriptor, serviceClassLoader); 
										KeyAspectDescriptor parameterAspectKeyDescriptor = 
												getKeyAspectDescriptor(parameterAspect, 
														serviceModuleDescriptor, serviceClassLoader, true);
														
										AspectDescriptor resultDescriptor = getAspectDescriptor(
											serviceModuleDescriptor,
											parameterAspect, parameterAspectStructure, parameterAspectKeyDescriptor, true, null);
									}
								}
							}
						}
					}
					
				} catch (Exception e) {
					CAFPublicLogger.traceThrowable(
						Severity.ERROR,
						location,
						method,
						e);
				}
			}

			if(mofInterfaceImpl instanceof ApplicationInterface) {
				AspectDescriptor app_desc = (AspectDescriptor) serviceModuleDescriptor.
					getAspectDescriptor(mofInterfaceImpl.getObjectName());
				if(app_desc == null) {
					app_desc = createAspectDescriptorForActionsSupport(serviceModuleDescriptor, mofInterfaceImpl);
				}
				
				IAspectDescriptor[] aspectDescrs = serviceModuleDescriptor.getAspectDescriptors();
				if(aspectDescrs!=null) {
					for(int j=0;j<aspectDescrs.length;++j) {
						AspectDescriptor desc = (AspectDescriptor) aspectDescrs[j];
						for(int i=0;i<size;++i) {
							// if process of one of the operation is wrong - continue
							try {
								Operation operation = (Operation) operations.get(i);
								if(PATTERN_CUSTOM.equals(operation.getPatternType())
									&& (operation.getOutput()==null || operation.getOutput().getMessageParts()==null 
									|| operation.getOutput().getMessageParts().size()==0)) {
									String operationName = operation.getObjectName();
									StructureDescriptor inputStructure = getOperationStructureDescriptor(
											serviceModuleDescriptor, serviceClassLoader, 
											serviceModuleDescriptor.getName()+"_"+operationName, 
											operation, false);
									desc.addAspectActionDescriptor(
										new AspectActionDescriptor(operationName,
											inputStructure, desc));
								}				
							} catch (Exception e) {
								CAFPublicLogger.traceThrowable(
									Severity.ERROR,
									location,
									method,
									e);
							}
						}
					}
				}
			}

		} catch (Exception e) {
			CAFPublicLogger.traceThrowable(Severity.ERROR, location, method, e);
		}
	}
	
	private AspectDescriptor createAspectDescriptorForActionsSupport(
		ServiceModuleDescriptor serviceModuleDescriptor, MOFInterface mofInterface) {
		String aspectDescriptorName = mofInterface.getObjectName();
		
		FieldDescriptor[] fields = new FieldDescriptor[1];
		fields[0] = tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null);
		StructureDescriptor attrsDescriptor =
			new StructureDescriptor(serviceModuleDescriptor, aspectDescriptorName, fields);
		
		FieldDescriptor[] keyfields = new FieldDescriptor[1];
		keyfields[0] = tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null);
		StructureDescriptor structureDescriptor =
			new StructureDescriptor(serviceModuleDescriptor, aspectDescriptorName, keyfields);
			
		KeyAspectDescriptor keyAttrsDescriptor = new KeyAspectDescriptor(
			serviceModuleDescriptor, "KEY_"+aspectDescriptorName, 
			"Aspect_descriptor_for_actions_support",
			structureDescriptor);
							
		AspectDescriptor aspectDescriptor = new AspectDescriptor(
			serviceModuleDescriptor,aspectDescriptorName,
			"Aspect_descriptor_for_actions_support",
			attrsDescriptor, keyAttrsDescriptor);
		//aspectDescriptor.addAttribute("actions_support", "true");
		
		createEmptySubmitAction(aspectDescriptor, serviceModuleDescriptor);
		
		return aspectDescriptor;
	}
	
	private StructureDescriptor getOperationStructureDescriptor(
			ServiceModuleDescriptor serviceModuleDescriptor, ClassLoader serviceClassLoader, 
			String structName, Operation operation, boolean isFindByMultipleParametersOperation) {
		FieldDescriptor[] fields = null;
		if(isFindByMultipleParametersOperation) { //process findByMultipleParameters operation 
			MOFInterface mofInterface = operation.getMOFInterface();
			DataStructure dataStructure = getAspect(mofInterface, operation);
			if(dataStructure!=null) {
				List fieldsList = new ArrayList();
					
				List keys = dataStructure.getKeys();
				if(keys!=null) {
					int size = keys.size();
					for(int i=0;i<size;++i) {
						Attribute attr = (Attribute) keys.get(i);
						if(attr!=null) {
							if(!KEY_ATTRIBUTE_NAME.equals(attr.getObjectName())) {
								fieldsList.add(getFieldDescriptor(
									attr, operation, serviceModuleDescriptor, serviceClassLoader));
							} else {
								fieldsList.add(
								tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, serviceClassLoader));
							}
						}
					}
				}
					
				List attrs = dataStructure.getAttributes();
				if(attrs!=null) {
					int size = attrs.size();
					for(int i=0;i<size;++i) {
						Attribute attr = (Attribute) attrs.get(i);
						if(attr!=null) {
							if(!isComplexAttribute(attr)) {
								fieldsList.add(getFieldDescriptor(
									attr, operation, serviceModuleDescriptor, serviceClassLoader));
							}
						}
					}
					for(int i=0;i<size;++i) {
						Attribute attr = (Attribute) attrs.get(i);
						if(attr!=null) {
							if(isComplexAttribute(attr)) {
								DataStructure ref = attr.getReferencedObject();
								List complexAttrs = ref.getAttributes();
								if(complexAttrs!=null) {
									int complexSize = complexAttrs.size();
									for(int j=0;j<complexSize;++j) {
										Attribute subattr = (Attribute) complexAttrs.get(j);
										if(subattr!=null) {
											FieldDescriptor fd = getFieldDescriptor(subattr, operation, serviceModuleDescriptor, 
												serviceClassLoader);
											fd.addAttribute("isComplexSubattribute", "true");
											fd.addAttribute("sourceAttributeName", attr.getObjectName());
											fd.addAttribute("targetAttributeName", subattr.getObjectName());
											fd.setName(getFieldNameForComplexSubattribute(
												attr.getObjectName(), subattr.getObjectName(), fieldsList));
											fieldsList.add(fd);
										}
									}
								}									
							}
						}
					}						
				}
				
				fields = (FieldDescriptor[]) fieldsList.toArray(new FieldDescriptor[0]);
			}
		} else {
			if(PATTERN_CREATE.equals(operation.getPatternType())) { //process create method
				MOFInterface mofInterface = operation.getMOFInterface();
				DataStructure dataStructure = null;
				if(mofInterface instanceof BusinessEntityInterface) {
					dataStructure = ((BusinessEntityInterface) mofInterface).getBusinessEntity();
				} else {
					Message output = operation.getOutput();
					if(output!=null) {
						List outputMessageParts = output.getMessageParts();
						if(outputMessageParts!=null) {
							int outputMessagePartsSize = outputMessageParts.size();
							if(outputMessagePartsSize>0) {
								Object retVal = outputMessageParts.get(0);
								if(retVal!=null) {
									dataStructure = ((Attribute)retVal).getReferencedObject();
								}
							}
						}
					}
				}
				
				if(dataStructure!=null) {
					List fieldsList = new ArrayList();
					
					List keys = dataStructure.getKeys();
					if(keys!=null) {
						int size = keys.size();
						for(int i=0;i<size;++i) {
							Attribute attr = (Attribute) keys.get(i);
							if(attr!=null && attr.getReferencedObject()==null && 
								!KEY_ATTRIBUTE_NAME.equalsIgnoreCase(attr.getObjectName())) {
								fieldsList.add(getFieldDescriptor(
										attr, operation, serviceModuleDescriptor, serviceClassLoader));
							}
						}
					}
					
					List attrs = dataStructure.getAttributes();
					if(attrs!=null) {
						int size = attrs.size();
						for(int i=0;i<size;++i) {
							Attribute attr = (Attribute) attrs.get(i);
							if(attr!=null) {
								Integer minOccurs = attr.getMinOccurs();
								if(minOccurs!=null && minOccurs.intValue()==1) {
									fieldsList.add(getFieldDescriptor(
										attr, operation, serviceModuleDescriptor, serviceClassLoader));
								}
							}
						}
					}
				
					fields = (FieldDescriptor[]) fieldsList.toArray(new FieldDescriptor[0]);
				}
			} else {
				Message inputMessage = operation.getInput();
				if(inputMessage!=null) {
					List inputMessageParts = inputMessage.getMessageParts();
					if(inputMessageParts!=null) {
						int inputParamSize = inputMessageParts.size();
						if(inputParamSize>0) {
							List fieldsList = new ArrayList();
			
							MOFInterface mofInterface = operation.getMOFInterface();
							DataStructure dataStructure = null;
							if(mofInterface instanceof BusinessEntityInterface) {
								dataStructure = ((BusinessEntityInterface) mofInterface).getBusinessEntity();
							} else {
								Message outputMessage = operation.getOutput();
								if(outputMessage!=null) {
									List outputMessageParts = outputMessage.getMessageParts();
									if(outputMessageParts!=null) {
										if(outputMessageParts.size()>0) {
											Object retVal = outputMessageParts.get(0);
											if(retVal!=null) {
												dataStructure = ((Attribute)retVal).getReferencedObject();
											}
										}
									}
								}
							}
							
							for(int i=0;i<inputParamSize;++i) {
								Attribute attr = (Attribute) inputMessageParts.get(i);
								if(attr!=null) {
									if(attr.getReferencedObject()==null) {
										fieldsList.add(getFieldDescriptor(
												attr, operation, serviceModuleDescriptor, serviceClassLoader));
									} else if((PATTERN_FIND_BY.equals(operation.getPatternType())
										|| PATTERN_BW_EXTRACT_OPERATION.equals(operation.getPatternType())) 
										&& dataStructure!=null) {
										String attrName = attr.getObjectName();
										Attribute dataStructureAttribute = getAttributeForName(
											dataStructure, attrName);
										
										if(dataStructureAttribute == null) {
											location.errorT("Invalid metadata: attribute with name "+attrName
												+ " not found in the object " + dataStructure.getObjectName()+".");
										}
										
										TypedFieldDescriptor fd = (TypedFieldDescriptor) getFieldDescriptor(
											dataStructureAttribute, operation, 
											serviceModuleDescriptor, serviceClassLoader);
											
										if(attrName!=null) {//for complex subattributes replace point by _
											int pointIndex = attrName.indexOf('.');
											if(pointIndex!=-1) {
												fd.setName(attrName.replace('.', '_'));
											}
										}
										
										fieldsList.add(fd);
									}
								}
							}
						
							fields = (FieldDescriptor[]) fieldsList.toArray(new FieldDescriptor[0]);
						}
					}
				}
			}
		}
				
		if(fields==null) {
			fields = new FieldDescriptor[0];
		}
		
		StructureDescriptor descr = new  StructureDescriptor(serviceModuleDescriptor, structName, fields);
		return descr;
	}
	
	private String getFieldNameForComplexSubattribute(String sourceAttrName, String targetAttrName, List fieldDescs) {
		String separator = "_";
		String name = sourceAttrName + separator + targetAttrName;
		HashSet fieldsNames = new HashSet();
		int size = fieldDescs.size(); 
		for(int i=0;i<size;++i) {
			FieldDescriptor fd = (FieldDescriptor) fieldDescs.get(i);
			fieldsNames.add(fd.getName());
		}		

		boolean isNameGenerated = false;		
		while(!isNameGenerated) {
			isNameGenerated = true;
			if(fieldsNames.contains(name)) {
				separator+="_";
				name = sourceAttrName + separator + targetAttrName;
				isNameGenerated = false;
			}
		}		
		return name;
	}
	
	private Attribute getAttributeForName(DataStructure dataStructure, String name) {
		int pointIndex = -1;
		if(name!=null) {
			pointIndex = name.indexOf(".");
		}
		
		List keys = dataStructure.getKeys();
		if(keys!=null) {
			int keysSize = keys.size();
			for(int i=0;i<keysSize;++i) {
				Attribute attr = (Attribute)keys.get(i);
				if(pointIndex == -1) {
					if(attr!=null && name.equals(attr.getObjectName())) {
						return attr;
					}
				} else {
					if(attr!=null && (name.substring(0, pointIndex)).equals(attr.getObjectName())) {
						DataStructure ds = attr.getReferencedObject();
						if(ds!=null) {
							return getAttributeForName(ds, name.substring(pointIndex+1));
						}
					}
				}
			}
		}
		
		List attributes = dataStructure.getAttributes();
		if(attributes!=null) {
			int attributesSize = attributes.size();
			for(int i=0;i<attributesSize;++i) {
				Attribute attr = (Attribute)attributes.get(i);
				if(pointIndex == -1) {
					if(attr!=null && name.equals(attr.getObjectName())) {
						return attr;
					}
				} else {
					if(attr!=null && (name.substring(0, pointIndex)).equals(attr.getObjectName())) {
						DataStructure ds = attr.getReferencedObject();
						if(ds!=null) {
							return getAttributeForName(ds, name.substring(pointIndex+1));
						}
					}					
				}
			}
		}
		
		return null;
	}
	
	private void processCollectionAttribute(Attribute attr, DataStructure aspect,
		AspectDescriptor sourceAspectDescriptor, ServiceModuleDescriptor serviceModuleDescriptor) {
		final String method = "processCollectionAttribute(Attribute, DataStructure, AspectDescriptor, ServiceModuleDescriptor)";
//		CAFPublicLogger.entering(null, jARMRequest, method, location, 1);
		
		try{		
			String structName = "COLLECTION_ASPECT_" + aspect.getObjectName();
			String attributeName = attr.getObjectName();
			
			FieldDescriptor[] fields = new FieldDescriptor[2];
			fields[0] = tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null);
			fields[1] = tfdFactory.getTypedFieldDescriptor(
				"value", null, attr.getTypeJavaDdic(),
				getClassLoader(serviceModuleDescriptor),
				accessServiceLocale);
	
			StructureDescriptor targetAttrsDescriptor =
				new StructureDescriptor(serviceModuleDescriptor, structName, fields);
	
			FieldDescriptor[] keyfields = new FieldDescriptor[1];
			keyfields[0] = tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null);
		
			StructureDescriptor structureDescriptor =
				new StructureDescriptor(serviceModuleDescriptor, structName, keyfields);
			KeyAspectDescriptor keyAspectDescriptor = new KeyAspectDescriptor(
				serviceModuleDescriptor, "COLLECTION_ASPECT_KEY_"+aspect.getObjectName(), aspect.getShortText(),
				structureDescriptor);
								
			AspectDescriptor targetAspectDescriptor = new AspectDescriptor(
				serviceModuleDescriptor, aspect.getObjectName()+"_"+attributeName,
				attr.getShortText(), targetAttrsDescriptor, keyAspectDescriptor);		
			
			targetAspectDescriptor.addAttribute("collection_support", "true");
						
			createEmptySubmitAction(targetAspectDescriptor, serviceModuleDescriptor);
			
			CMICardinality cardinality = null;
			if(attr.getMinOccurs().intValue()==0 &&
				attr.getMaxOccurs().intValue()==-1) {
				cardinality = CMICardinality.CARDINALITY_MANY;
			} else if(attr.getMinOccurs().intValue()==1 &&
				attr.getMaxOccurs().intValue()==-1) {
				cardinality = CMICardinality.CARDINALITY_ONE_TO_MANY;
			}
			
			RelationDescriptor relationDescriptor = new RelationDescriptor(
				attributeName, //sourceAspectDescriptor.getName()+":"+attr.getObjectName(),
				cardinality,
				sourceAspectDescriptor, targetAspectDescriptor);
		
			relationDescriptor.addAttribute("source_ref_attribute", attributeName);
			relationDescriptor.addAttribute("collection_support", "true");
			relationDescriptor.addAttribute("generic", "true");
			serviceModuleDescriptor.addRelationDescriptor(relationDescriptor);
		}catch(Exception e){
			CAFPublicLogger.traceThrowable(Severity.ERROR, location, method, e);
		}
	}
	
	public String getObjectKey(MOFInterface mofInterfaceImpl) {
		if(mofInterfaceImpl!=null) {
			StringBuffer descriptorKeyPrefix = new StringBuffer();
			Application app = mofInterfaceImpl.getApplication();
			descriptorKeyPrefix.append(app.getProviderName());
			descriptorKeyPrefix.append("/");
			descriptorKeyPrefix.append(app.getObjectName());
			descriptorKeyPrefix.append("/");
			descriptorKeyPrefix.append(mofInterfaceImpl.getObjectName());
			
			return descriptorKeyPrefix.toString();
		}
		return "";	
	}
	
	
	public String getDataObjectNameFromAspect(DataStructure aspect) {
		if(aspect instanceof DataObject) {
			MOFInterface mofInterfaceImpl = ((DataObject) aspect).getBusinessEntityInterface();
			if(mofInterfaceImpl != null) { 
				StringBuffer descriptorKeyPrefix = new StringBuffer();
				Application app = mofInterfaceImpl.getApplication();
				descriptorKeyPrefix.append(app.getProviderName());
				descriptorKeyPrefix.append("/");
				descriptorKeyPrefix.append(app.getObjectName());
				descriptorKeyPrefix.append("/");
				descriptorKeyPrefix.append(aspect.getObjectName());
				return descriptorKeyPrefix.toString();
			}
		}
		return "";	
	}
	
	
	
	/**
	 * 
	 * @param aspect
	 * @param serviceModuleDescriptor
	 * @param inputParameters
	 * @param keyAspectDescriptor
	 */
	private void addRelationDescriptors(DataStructure aspect, 
			ServiceModuleDescriptor serviceModuleDescriptor, ClassLoader serviceClassLoader,
			List allInterfaces) {
		final String method = "addRelationDescriptors(DataStructure, ServiceModuleDescriptor, ClassLoader, List)";
		try {
			AspectDescriptor sourceAspectDescriptor = getAspectDescriptor(
				serviceModuleDescriptor, aspect,
				null, null, true, null);
		
			List aspectAttributes = aspect.getAttributes();
			int size = aspectAttributes.size();
			for(int k=0;k<size;++k) {
				Attribute attribute = (Attribute) aspectAttributes.get(k);
				if(attribute!=null) {
					DataStructure refObject = attribute.getReferencedObject();
					if(refObject!=null) {
						String attributeName = attribute.getObjectName();
						AspectDescriptor targetAspectDescriptor = 
							(AspectDescriptor) getAspectDescriptor(allInterfaces,
							refObject, serviceModuleDescriptor);
						
						CMICardinality cardinality = null;
						if(attribute.getMinOccurs().intValue()==0) {
							if(attribute.getMaxOccurs().intValue()==1) {
								cardinality = CMICardinality.CARDINALITY_ZERO_TO_ONE;
							} else if(attribute.getMaxOccurs().intValue()==-1) {
								cardinality = CMICardinality.CARDINALITY_MANY;
							}
						} else { 
							if(attribute.getMaxOccurs().intValue()==1) {
								cardinality = CMICardinality.CARDINALITY_ONE;
							} else if(attribute.getMaxOccurs().intValue()==-1) {
								cardinality = CMICardinality.CARDINALITY_ONE_TO_MANY;
							}
						}
												
						if(targetAspectDescriptor==null) { //for processing of complex attributes
							StructureDescriptor inputParameters = getStructureDescriptor(
								refObject, serviceModuleDescriptor, serviceClassLoader); 
							KeyAspectDescriptor keyAspectDescriptor = getKeyAspectDescriptor(
								refObject, serviceModuleDescriptor, serviceClassLoader, false);
												
							targetAspectDescriptor = getAspectDescriptor(serviceModuleDescriptor,
								refObject,
								inputParameters, keyAspectDescriptor, false,
								aspect.getObjectName()+"_"+attributeName);
						}
							
						RelationDescriptor relationDescriptor = new RelationDescriptor(
							attributeName, //sourceAspectDescriptor.getName()+":"+attribute.getObjectName(),
							cardinality,
							sourceAspectDescriptor, targetAspectDescriptor);
			
						relationDescriptor.addAttribute("source_ref_attribute", attributeName);
						
						//if(aspect instanceof DataObject &&
						//	!(refObject instanceof DataObject)) {
						if(isComplexAttribute(attribute)) {
							relationDescriptor.addAttribute("complex_attribute", "true");
							targetAspectDescriptor.addAttribute("complex_attribute", "true");
						}
						if(!(aspect instanceof DataObject) 
							&& !(refObject instanceof DataObject)) {
							//for references from DataStructure to DataStructure in application services  
							relationDescriptor.addAttribute("complex_attribute", "true");
							targetAspectDescriptor.addAttribute("complex_attribute", "true");
						}
						serviceModuleDescriptor.addRelationDescriptor(relationDescriptor);
					}
				}
			}
		} catch (Exception e) {
			CAFPublicLogger.traceThrowable(
				Severity.WARNING,
				location,
				method,
				e);
		
		}
	}
	
	/**
	 * Return true if attribute is complex 
	 * @param attr
	 * @return
	 */
	public static boolean isComplexAttribute(Attribute attr) {
		if(attr==null) return false;
		DataStructure dataStructure = attr.getReferencedObject();
		return (((dataStructure!=null) 
			&& (dataStructure instanceof DataObject)
			&& (((DataObject)dataStructure).getBusinessEntityInterface()==null)) ? true:false);
	}
	
	/**
	 * Get already created aspect descriptor 
	 * which will be used as target in relation descriptor
	 * @param mofInterfaces
	 * @param aspectName
	 * @return
	 */
	private AspectDescriptor getAspectDescriptor(List mofInterfaces, DataStructure aspect,
		ServiceModuleDescriptor serviceModuleDescriptor) {
		final String method = "getAspectDescriptor(List, DataStructure, ServiceModuleDescriptor)";
		CAFPublicLogger.entering(null, jARMRequest, method, location, 2);
		try {
			String aspectName = aspect.getObjectName();
			
			Application application = aspect.getApplication();
			if(application == null && aspect instanceof DataObject) {
				BusinessEntityInterface businessEntity = 
					((DataObject)aspect).getBusinessEntityInterface();
				if(businessEntity == null) {
					return null;
				}
				application = businessEntity.getApplication();
			}
			
			//trying to find aspect in this service
			IAspectDescriptor aspectDesc = serviceModuleDescriptor.
				getAspectDescriptor(aspectName);
			if(aspectDesc!=null) {
				String appId = (String)aspectsApplicationAndProviderNames.get(aspectDesc);
				if(appId!=null) {
					String aspectAppId = application.getProviderName()
						+"/"+application.getObjectName();
					if(appId.equals(aspectAppId)) {
						return (AspectDescriptor) aspectDesc;
					}
				}
			}

			StringBuffer descriptorKeyPrefix = new StringBuffer();
			descriptorKeyPrefix.append(application.getProviderName());
			descriptorKeyPrefix.append("/");
			descriptorKeyPrefix.append(application.getObjectName());
			descriptorKeyPrefix.append("/");
			String prefix = descriptorKeyPrefix.toString();
						
			int size = mofInterfaces.size();
			for(int i=0;i<size;++i) {
				MOFInterface entity = (MOFInterface) mofInterfaces.get(i);
				if(entity instanceof BusinessEntityInterface) {
					String serviceName = getObjectKey(entity);
				
					if((prefix+entity.getObjectName()).equals(serviceName)) { //check if aspect and service have equal application name and provder name  
						ServiceModuleDescriptor desc = (ServiceModuleDescriptor) 
							getServiceModuleDescriptor(serviceName);
				
						if(desc.getAspectDescriptor(aspectName)!=null) {
							return (AspectDescriptor) desc.getAspectDescriptor(aspectName);
						}
					}
				}
			}
		} catch (Exception e) {
			CAFPublicLogger.traceThrowable(
				Severity.WARNING,
				location,
				method,
				e);
		
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, location, 2);
		}
		return null;
	}
	
	/**
	 * 
	 * @param dataStructure
	 * @param serviceModuleDescriptor
	 * @return
	 */
	private StructureDescriptor getStructureDescriptor(DataStructure dataStructure, 
			ServiceModuleDescriptor serviceModuleDescriptor, ClassLoader serviceClassLoader) {
		final String method = "getStructureDescriptor(DataStructure, ServiceModuleDescriptor, ClassLoader)";
		CAFPublicLogger.entering(null, jARMRequest, method, location, 1);
		
		String structureKey = serviceModuleDescriptor.getName()+"/ASPECT_" + dataStructure.getObjectName();
		StructureDescriptor structureDescriptor = (StructureDescriptor) 
			structureDescriptorsCashe.get(structureKey);
		if(structureDescriptor == null) {
			List keys = dataStructure.getKeys();
			List attributes = dataStructure.getAttributes();
			int ks = keys.size();
			List fieldsList = new ArrayList();
			for (int i = 0; i < ks; i++) {
				Attribute attribute = (Attribute) keys.get(i);
				if(attribute!=null && attribute.getReferencedObject()==null 
					&& !CARDINALITY_N.equals(attribute.getMaxOccurs())) {
					String customType = attribute.getTypeJavaDdic();
					fieldsList.add(getFieldDescriptor(
							attribute, dataStructure, serviceModuleDescriptor, serviceClassLoader));
				}
			}
			
			if(fieldsList.size()==0 && dataStructure instanceof DataObject) {
				fieldsList.add(tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null));
			}
	
			int attrSize = attributes.size();
			for (int i = 0 ; i < attrSize; i++) {
				Attribute attribute = (Attribute) attributes.get(i);
				if(attribute!=null && attribute.getReferencedObject()==null
					&& !CARDINALITY_N.equals(attribute.getMaxOccurs())) {
					String customType = attribute.getTypeJavaDdic();
					fieldsList.add(getFieldDescriptor(
							attribute, dataStructure, serviceModuleDescriptor, serviceClassLoader));
				}
			}

	    	// check whether ServiceModule is of Business Entity type
			if ("true".equals(
					serviceModuleDescriptor.getAttributeStringValue("isClassifiable")) 
				&& dataStructure instanceof DataObject
				&& ((DataObject)dataStructure).getBusinessEntityInterface()!=null) {
				addCategoriesToFieldsList(fieldsList, serviceModuleDescriptor, serviceClassLoader, 
					dataStructure.getObjectName());
			}
			
			FieldDescriptor[] fields = (FieldDescriptor[]) fieldsList.toArray(new FieldDescriptor[0]);
			
			String structName = "ASPECT_" + dataStructure.getObjectName();
			structureDescriptor =
				new StructureDescriptor(serviceModuleDescriptor, structName, fields);
			structureDescriptorsCashe.put(structureKey, structureDescriptor);
		}
		
		CAFPublicLogger.exiting(null, jARMRequest, method, location, 1);
		return structureDescriptor;
	}
	
	/**
	 * @param dataStructure
	 * @param serviceModuleDescriptor
	 * @return
	 */
	private KeyAspectDescriptor getKeyAspectDescriptor(DataStructure dataStructure, 
			ServiceModuleDescriptor serviceModuleDescriptor, ClassLoader serviceClassLoader, 
			boolean isUseCashing) {
		final String method = "getKeyAspectDescriptor(DataStructure, ServiceModuleDescriptor, ClassLoader, boolean)";
		CAFPublicLogger.entering(null, jARMRequest, method, location, 2);	

		if(isUseCashing && keyAspectDescriptorsCashe.containsKey(
			serviceModuleDescriptor.getName()+"/KEY_"+dataStructure.getObjectName())) {
			CAFPublicLogger.exiting( null, jARMRequest, method, location, 2);	
			return (KeyAspectDescriptor) keyAspectDescriptorsCashe.get(
				serviceModuleDescriptor.getName()+"/KEY_"+dataStructure.getObjectName());
		} else {
			List attributes = dataStructure.getKeys();
			List fieldsList = new ArrayList();
			int size = attributes.size();
			for (int i = 0; i < size; ++i) {
				Attribute attribute = (Attribute) attributes.get(i);
				if(attribute!=null && attribute.getReferencedObject()==null
					&& !CARDINALITY_N.equals(attribute.getMaxOccurs())
					&& (KEY_ATTRIBUTE_NAME.equals(attribute.getObjectName()) || size==1)) {
					fieldsList.add(getFieldDescriptor(
							attribute, dataStructure, serviceModuleDescriptor, serviceClassLoader));
				}
			}
			
			if(fieldsList.size()==0 && dataStructure instanceof DataObject) {
				fieldsList.add(tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null));
			}
		
			FieldDescriptor[] fields = (FieldDescriptor[]) fieldsList.toArray(new FieldDescriptor[0]);
			
			String structName = "ASPECT_KEY_" + dataStructure.getObjectName();
			StructureDescriptor structureDescriptor =
				new StructureDescriptor(serviceModuleDescriptor, structName, fields);

			KeyAspectDescriptor keyAspectDescriptor = new KeyAspectDescriptor(
				serviceModuleDescriptor, "KEY_"+dataStructure.getObjectName(), dataStructure.getShortText(),
				structureDescriptor);
				
			if(isUseCashing) {
				keyAspectDescriptorsCashe.put(serviceModuleDescriptor.getName()+"/KEY_"+dataStructure.getObjectName(),
					keyAspectDescriptor);
			}
			CAFPublicLogger.exiting(null, jARMRequest, method, location, 2);					
			return keyAspectDescriptor;
		}
	}

	private FieldDescriptor getFieldDescriptor(
			Attribute attribute, DataStructure structure, 
			ServiceModuleDescriptor serviceModuleDescriptor, ClassLoader serviceClassLoader) {
		return getFieldDescriptor(attribute, serviceModuleDescriptor, 
				getCustomizedPropertyDescription(
						serviceModuleDescriptor.getName(), structure.getObjectName(), 
						attribute.getObjectName(), serviceClassLoader),
				serviceClassLoader);
	}
	
	private FieldDescriptor getFieldDescriptor(
			Attribute attribute, Operation operation, ServiceModuleDescriptor serviceModuleDescr,
			ClassLoader serviceClassLoader) {
		return getFieldDescriptor(attribute, serviceModuleDescr, 
				getCustomizedParameterDescription(
						serviceModuleDescr.getName(), operation.getObjectName(),
						operation.getPatternType().intValue(), attribute.getObjectName(), 
						serviceClassLoader),
				serviceClassLoader);
	}
	
	private FieldDescriptor getFieldDescriptor(
			Attribute attribute, ServiceModuleDescriptor serviceModuleDescriptor, 
			String customText, ClassLoader serviceClassLoader) {
				
		FieldDescriptor fieldDescriptor = tfdFactory.getTypedFieldDescriptor(
				attribute.getObjectName(), null, attribute.getTypeJavaDdic(), 
				serviceClassLoader, accessServiceLocale);
		String attrShortText = attribute.getShortText();
		fieldDescriptor.setTextInfo((customText != null) ? customText : attrShortText, 
				attrShortText, null, attribute.getLongText());
		return fieldDescriptor;
	}
	
	private String getCustomizedPropertyDescription(
			String serviceName, String aspectName, String propName, ClassLoader serviceClassLoader) {
		final String method = "getCustomizedPropertyDescription(String, String, String, ClassLoader)";		
		try {
			return getCustomizedPropertyDescription(serviceName, 
					LocalizationResourceAccessor.getResourceName(
							serviceName, aspectName, null, null, propName), serviceClassLoader);
		} catch (Exception e) {
			//$JL-EXC$ ussual situation when properties was not defined. In case to print the stack it can oveload the log file. 			
			//CAFPublicLogger.traceThrowable(Severity.WARNING, location, method, e);
		}
		return null;
	}

	private String getCustomizedParameterDescription(
			String serviceName, String methodName, int methodType, String paramName,  
			ClassLoader serviceClassLoader) {
		final String method = "getCustomizedParameterDescription(String, String, int, String, ClassLoader)";
		try {
			String actionName = null;
			String queryName = null;
			if (methodType == 0) {
				actionName = methodName;
			} else if (methodType == 5 || methodType == 8) {
				queryName = methodName;
			} else {
				// can't work with other method types
				return null;
			}
			return getCustomizedPropertyDescription(serviceName, 
					LocalizationResourceAccessor.getResourceName(
							serviceName, null, queryName, actionName, paramName), 
					serviceClassLoader);
		} catch (Exception e) {
			//$JL-EXC$ ussual situation when properties was not defined. In case to print the stack it can oveload the log file.
			//CAFPublicLogger.traceThrowable(Severity.WARNING, location, method, e);
		}
		return null;
	}
	
	private String getCustomizedPropertyDescription(
			String serviceName, String resourceKey, ClassLoader serviceClassLoader)
			throws Exception {
				
		return LocalizationResourceAccessor.getCustomizedText(
				accessServiceLocale, resourceKey, serviceName, serviceClassLoader);
	}
	
	/**
	 * Get aspect descriptor from cashe if it exists, else create it.
	 * @return
	 */
	private AspectDescriptor getAspectDescriptor(ServiceModuleDescriptor serviceModuleDesc,
		DataStructure aspect, StructureDescriptor structure, KeyAspectDescriptor key,
		boolean isUseCashing, String complexAttributeAspectName) {
		final String method = "getAspectDescriptor(ServiceModuleDescriptor, DataStructure, StructureDescriptor, KeyAspectDescriptor, boolean, String)";
		CAFPublicLogger.entering(null, jARMRequest, method, location, 2);
		String name = aspect.getObjectName();
		String description = aspect.getShortText();
		
		if(complexAttributeAspectName!=null) {//for complex attributes and other
			name = complexAttributeAspectName;
		}
		
		if(isUseCashing && aspectDescriptorsCashe.containsKey(serviceModuleDesc.getName()+"/"+name)) {
			CAFPublicLogger.exiting(null, jARMRequest, method, location, 2);
			return (AspectDescriptor) aspectDescriptorsCashe.get(serviceModuleDesc.getName()+"/"+name);
		}
			
		AspectDescriptor aspectDescriptor = new AspectDescriptor(serviceModuleDesc,
			name, description, structure, key);
		
		if(aspect instanceof DataObject) {
			aspectDescriptor.addAttribute(BE_DO_MOFID_PARAM_NAME, aspect.getObjectId());
		}
		if(isUseCashing) {
			aspectDescriptorsCashe.put(serviceModuleDesc.getName()+"/"+name, aspectDescriptor);
			
			Application app = aspect.getApplication();
			if(app==null && aspect instanceof DataObject) {
				app = ((DataObject)aspect).getBusinessEntityInterface().getApplication();
			}
			if(app!=null) {
				aspectsApplicationAndProviderNames.put(aspectDescriptor,
					app.getProviderName()+"/"+app.getObjectName());
			}
		}
		createEmptySubmitAction(aspectDescriptor, serviceModuleDesc);
		CAFPublicLogger.exiting(null, jARMRequest, method, location, 2);		
		return aspectDescriptor;
	}
	
	/**
	 * Add empty aspect
	 * @param aspectDescriptor
	 */
	private void createEmptySubmitAction(AspectDescriptor aspectDescriptor, 
		ServiceModuleDescriptor serviceModuleDescriptor) {
		FieldDescriptor[] fields = new FieldDescriptor[0];
			
		String structName = "STRUCTURE_" + ASPECT_SUBMIT_ACTION_NAME;
		StructureDescriptor structureDescriptor =
			new StructureDescriptor(serviceModuleDescriptor, structName, fields);
							
		aspectDescriptor.addAspectActionDescriptor(
			new AspectActionDescriptor(ASPECT_SUBMIT_ACTION_NAME, structureDescriptor,
				aspectDescriptor));
	}
	
	/**
	 * 
	 * @param serviceModuleDescriptor
	 * @return
	 */
	private ClassLoader getClassLoader(ServiceModuleDescriptor serviceModuleDescriptor) {
		final String method = "getClassLoader(ServiceModuleDescriptor)";
		CAFPublicLogger.entering(null, JARM_REQUEST, method, location);
		ClassLoader result = null;
		String jndiName = getServiceJNDI_KEY(serviceModuleDescriptor.getName());
		try {
			InitialContext ic = new InitialContext();
			Object lh = ic.lookup(jndiName);
			result = lh.getClass().getClassLoader();
		}
		catch (NamingException e) {
			CAFPublicLogger.traceThrowable(Severity.ERROR, location, method, e);
		}
		CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
		return result; 
	}
	
	/**
	 * 
	 * @param operation
	 * @return
	 */
	private boolean isCRUDOperation(Operation operation) {
		if(operation!=null) {
			Integer patternType = operation.getPatternType();
			if(patternType!=null
				&& patternType.intValue()>=1 
				&& patternType.intValue()<=4) {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * Return true if operation is valid, else - false.
	 * @param op
	 * @return
	 */
	private boolean checkOperation(Operation op){
		if(!isCRUDOperation(op)) {
			Message outputMessage = op.getOutput();
			Message inputMessage = op.getInput();
			if(outputMessage!=null) {
				List outputMessageAttributes = outputMessage.getMessageParts();
				if(outputMessageAttributes!=null) {
					int size = outputMessageAttributes.size();
					for(int j=0;j<size;++j) {
						Attribute attr = (Attribute)outputMessageAttributes.get(j);
						if(attr!=null) {
							String attrType = attr.getTypeJavaDdic();
							if((attr.getReferencedObject()== null) &&
								(attrType == null ||
							 	INVALID_ATTRIBUTE_DICT_TYPE_0.equals(attrType) ||
							 	INVALID_ATTRIBUTE_DICT_TYPE_1.equals(attrType))) {
								return false;
							}
						}
					}
				}
			}
			
			if(inputMessage!=null) {
				List inputMessageAttributes = inputMessage.getMessageParts();
				if(inputMessageAttributes!=null) {
					int size = inputMessageAttributes.size();
					for(int j=0;j<size;++j) {
						Attribute attr = (Attribute)inputMessageAttributes.get(j);
						if(attr!=null) {
							String attrType = attr.getTypeJavaDdic();
							if((attr.getReferencedObject()== null) &&
								(attrType == null ||
								INVALID_ATTRIBUTE_DICT_TYPE_0.equals(attrType) ||
								INVALID_ATTRIBUTE_DICT_TYPE_1.equals(attrType))) {
								return false;
							}
						}
					}
				}
			}
		}
		return true; 
	}


	/** 
	 * Start transaction 
	 */
	public void startTransaction() throws Exception {
		final String method = "startTransaction()";
		CAFPublicLogger.entering(null, jARMRequest, method, location, 2);
		try {
			UserTransaction t = CAFServiceAccessBeanImpl.getTransaction();
			// If there is no active transaction start new one.
			// Transactions that are marked for rollback only are treated as active ones.
			if (!CAFServiceAccessBeanImpl.isTransactionAlive(t)) {
				t.begin();
			}
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, location, 2);
		}
	}

	/**
	 * 
	 * @param fieldsList
	 * @param serviceModuleDescriptor
	 * @param serviceClassLoader
	 * @param dataObjectName
	 */
	private void addCategoriesToFieldsList(
		List fieldsList,
		ServiceModuleDescriptor serviceModuleDescriptor,
		ClassLoader serviceClassLoader, String dataObjectName) {
		final String method = "addCategoriesToFieldsList(List, ServiceModuleDescriptor, ClassLoader)";
		CAFPublicLogger.entering(null, jARMRequest, method, location, 2);
		try {
			startTransaction();	
			Collection categories = getServiceModuleCategories(serviceModuleDescriptor);
			if(categories!= null) {
				int categoryNameCounter = 0;
				for(Iterator iter = categories.iterator(); iter.hasNext(); categoryNameCounter++) {
					//iterating through cats
					IDependentObject  currentCategory = (IDependentObject) iter.next();
					//generating unique name
					String paramName = CATEGORY_NAME_START + categoryNameCounter;
					//getting catid
					String categoryID = (String) currentCategory.getProperty(PARAM_NAME_CATEGORY_ID);
					if(categoryID == null || "".equals(categoryID)) continue;
					//getting cat descr
					String categoryDescription = (String) currentCategory.getProperty(PARAM_NAME_CATEGORY_DESCRIPTION);
					String cType = "category" + categoryID;
					TypedFieldDescriptor fd =  tfdFactory.getTypedFieldDescriptor(paramName, null , cType, serviceClassLoader, accessServiceLocale);
					
					String customText = getCustomizedPropertyDescription(
						serviceModuleDescriptor.getName(), dataObjectName, 
						fd.getName(), serviceClassLoader);
					fd.setTextInfo((customText != null) ? customText : categoryDescription,
						categoryDescription, categoryDescription, cType);
					
					fd.setCategoryID(categoryID);
					fieldsList.add(fd);
				}
		    }
		} catch (Exception ex) {
			CAFPublicLogger.traceThrowable(
				Severity.WARNING,
				location,
				method,
				ex);
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, location, 2);
		}
	}

	/**
	 * 
	 * @param serviceModuleDescriptor
	 * @return
	 */
	private Collection getServiceModuleCategories(ServiceModuleDescriptor serviceModuleDescriptor) {
		final String method = "getServiceModuleCategories(ServiceModuleDescriptor)";
		Collection result = null;
		try {
			InitialContext ic = new InitialContext();
			Object home = ic.lookup(CATEGORY_SERVICE_JNDI_NAME);

			Method cr_meth = home.getClass().getMethod("create", new Class[0]);
			Object createdService = cr_meth.invoke(home, new Object[0]);
			
			Method findCatByName_meth = createdService.getClass().getMethod("findCategoryByBOName", new Class[] {String.class});
			if(findCatByName_meth != null) {
//				String serviceName = serviceModuleDescriptor.getName();
				String bOName = serviceModuleDescriptor.getAttributeStringValue("BusinessEntityName");
				result = (Collection) findCatByName_meth.invoke(createdService,new Object[] {bOName});
			}
//			if (createdService instanceof IClassificationExt) {
//				IClassificationExt classification =
//					(IClassificationExt) createdService;
//				result = classification.getCategories();
//			}
		} catch (Exception e) {
			CAFPublicLogger.traceThrowable(Severity.ERROR, location, method, e);
		}
		return result;
	}
	
	/**
	 * Add KM methods to the service descriptor
	 * @param serviceModuleDescriptor
	 * @param serviceClassLoader
	 * @param keyAspectDescriptor
	 * @param inputParameters
	 * @param resultDescriptor
	 */
	private void addKMMethods(ServiceModuleDescriptor serviceModuleDescriptor, ClassLoader serviceClassLoader,
		KeyAspectDescriptor keyAspectDescriptor, StructureDescriptor inputParameters,
		AspectDescriptor resultDescriptor) {
		//add findByKMPropertySearch method
		if(serviceModuleDescriptor.getQueryDescriptor(FIND_BY_KM_PROPERTY_SEARCH_NAME) == null) {
			List fieldsList = new ArrayList(); 
			IFieldDescriptor[] fields = inputParameters.getFieldDescriptors();
			if(fields!=null) {
				for(int i=0; i<fields.length; ++i) {
					TypedFieldDescriptor fd = (TypedFieldDescriptor)fields[i];
					if(!KEY_ATTRIBUTE_NAME.equalsIgnoreCase(fd.getName())) {
						TypedFieldDescriptor newFd = tfdFactory.
							getTypedFieldDescriptor(fd.getName(), null, 
							fd.getCustomType(), serviceClassLoader, accessServiceLocale); 

						String customText = getCustomizedParameterDescription(
							serviceModuleDescriptor.getName(), FIND_BY_KM_PROPERTY_SEARCH_NAME,
							PATTERN_FIND_BY.intValue(), fd.getName(),
							serviceClassLoader);
						newFd.setTextInfo((customText != null) ? customText : fd.getText(0), 
							fd.getText(1), fd.getText(2), fd.getText(3));

						newFd.setCategoryID(fd.getCategoryID());
						
						fieldsList.add(newFd);
					}
				}
			}
			
			FieldDescriptor[] newFields = (FieldDescriptor[]) fieldsList.toArray(new FieldDescriptor[0]);
			StructureDescriptor inputStructureDescriptor =
				new StructureDescriptor(serviceModuleDescriptor, FIND_BY_KM_PROPERTY_SEARCH_NAME+"_input", newFields);
			
			QueryDescriptor queryDescriptor = new QueryDescriptor(
				FIND_BY_KM_PROPERTY_SEARCH_NAME,
				"Performs full text search by BO properties in KM index",
				keyAspectDescriptor, inputStructureDescriptor, resultDescriptor,
				serviceModuleDescriptor);
			queryDescriptor.addAttribute(FIND_BY_KM_PROPERTY_SEARCH_NAME, "true");

			serviceModuleDescriptor.addQueryDescriptor(queryDescriptor);
		}

		//add searchidxForBOInRelatedDoc method
		if(serviceModuleDescriptor.getQueryDescriptor(SEARCH_IDX_FOR_BO_IN_RELATED_DOC_NAME) == null) {
			FieldDescriptor[] fields = new FieldDescriptor[1];
			fields[0] = tfdFactory.getTypedFieldDescriptor("freeText", STRING_TYPE, serviceClassLoader); 
			
			String customText = getCustomizedParameterDescription(
				serviceModuleDescriptor.getName(), SEARCH_IDX_FOR_BO_IN_RELATED_DOC_NAME,
				PATTERN_FIND_BY.intValue(), "freeText",
				serviceClassLoader);
			fields[0].setTextInfo((customText != null) ? customText : "Free text", 
				"Free text", null, "Free text");
			
			StructureDescriptor inputParametersSearchIdx =
				new StructureDescriptor(serviceModuleDescriptor,
					SEARCH_IDX_FOR_BO_IN_RELATED_DOC_NAME+"_input", fields);
		 
			QueryDescriptor queryDescriptor = new QueryDescriptor(
				SEARCH_IDX_FOR_BO_IN_RELATED_DOC_NAME,
				"Performs search by free text in KM",
				keyAspectDescriptor,inputParametersSearchIdx,resultDescriptor,
				serviceModuleDescriptor);
			queryDescriptor.addAttribute(SEARCH_IDX_FOR_BO_IN_RELATED_DOC_NAME, "true");

			serviceModuleDescriptor.addQueryDescriptor(queryDescriptor);
	  	}		
	}
	
	/**
	 * 
	 * @param mofInterfaceImpl
	 * @param serviceModuleDescriptor
	 */
	private void addAttributeIfServiceIsClassifiable(
		MOFInterface mofInterfaceImpl,
		ServiceModuleDescriptor serviceModuleDescriptor) {
		if (mofInterfaceImpl instanceof BusinessEntityInterface
			&& ((BusinessEntityInterface) mofInterfaceImpl).isClassifiable() != null && 
			(((BusinessEntityInterface) mofInterfaceImpl).isClassifiable())
				.booleanValue()) {
			serviceModuleDescriptor.addAttribute("isClassifiable", "true");
		}
	}
	
	
	public String getServiceFullName(String provider, String application, String service) {
		StringBuffer descriptorKeyPrefix = new StringBuffer();
		descriptorKeyPrefix.append(provider);
		descriptorKeyPrefix.append("/");
		descriptorKeyPrefix.append(application);
		descriptorKeyPrefix.append("/");
		descriptorKeyPrefix.append(service);	
		return descriptorKeyPrefix.toString();
	}
	
	public String getProviderFromServiceFullName(String moduleName) {
	  int firstIndex = moduleName.indexOf("/");
	  if(firstIndex == -1) {
		  return null;
	  } else {
		  return moduleName.substring(0,firstIndex);
	  }
	}

	public String getApplicationFromServiceFullName(String moduleName) {
	  int firstIndex = moduleName.indexOf("/");
	  if(firstIndex == -1) {
		  return null;
	  } else {
		  String withoutProvider = moduleName.substring(firstIndex + 1); 
		  int secondIndex = withoutProvider.indexOf("/");
		  if(secondIndex == -1) {
			  return null;
		  } else {
			  return withoutProvider.substring(0, secondIndex);
		  }
	  }
	}
  
	public String getServiceFromServiceFullName(String moduleName) {
	  int firstIndex = moduleName.indexOf("/");
	  if(firstIndex == -1) {
		  return moduleName;
	  } else {
		  String withoutProvider = moduleName.substring(firstIndex + 1); 
		  int secondIndex = withoutProvider.indexOf("/");
		  if(secondIndex == -1) {
			  return withoutProvider;
		  } else {
			  return withoutProvider.substring(secondIndex + 1);
		  }
	  }
	}
	
	public static final String BE_TABLE_PARAM_NAME = "BE_TABLE";
	public static final String BE_DO_MOFID_PARAM_NAME = "BE_DO_MOFID";

	public static final String MOF_INTERFACE_TYPE_PARAM_NAME = "MOFInterfaceType";
	public static final String MOF_INTERFACE_TYPE_VALUE_BEI = "BusinessEntityInterface";
	public static final String MOF_INTERFACE_TYPE_VALUE_AI = "ApplicationInterface";
	
}
