package com.sap.caf.rt.services.notify.subscr.persist.xml;

import java.util.Stack;

import org.w3c.dom.Node;

import com.sap.caf.rt.services.notify.subscr.persist.IPersistable;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.PersistManager;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class XMLPersistManager extends PersistManager implements IXMLPersistManager, IXMLNames {

	protected Node popNode() {
		return (Node)m_nodeStack.pop();
	}

	protected void resetNodes() { 
		m_nodeStack.clear();
	}
	
	protected void pushNode(Node node) {
		m_nodeStack.push(node);
	}

	protected Node peekNode() {
		return (Node)m_nodeStack.peek();
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager#getCurrentNode()
	 */
	public Node getCurrentNode() {
		return peekNode();
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager#load(org.w3c.dom.Node, com.sap.caf.rt.services.notify.subscr.persist.IPersistable, java.lang.ClassLoader)
	 */
	public void load(Node node, IPersistable obj) throws PersistException {
		pushNode(node);
		try {
			load(obj);
		}
		finally {
			popNode();
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistManager#begin()
	 */
	public void begin() throws PersistException {
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistManager#commit()
	 */
	public void commit() throws PersistException {
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistManager#revert()
	 */
	public void revert() throws PersistException {
	}

	private Stack m_nodeStack = new Stack();

}
