package com.sap.caf.rt.services.notify.subscr.persist.xml;

import org.w3c.dom.Node;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class MissedValueException extends PersistException {
	static final long serialVersionUID = 1;

	public MissedValueException(Node node) {
		super(getErrorMessage(node));
	}

	public MissedValueException(Node node, Throwable e) {
		super(getErrorMessage(node), e);
	}

	private static String getErrorMessage(Node node) {
		StringBuffer msg = new StringBuffer(96);
		msg.append(node.getNodeType()==Node.ATTRIBUTE_NODE? "Attribute:[": "Node:[");
		msg.append(node.getNodeName()).append("]");
		Node parent = node.getParentNode();
		if (parent!=null) {
			msg.append(" of node:["+parent.getNodeName()+"]");
		}
		msg.append(" should contain a value!");
		return msg.toString();
	}
}
