package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import java.util.Map;

import org.w3c.dom.Node;

import com.sap.caf.rt.services.notify.subscr.SubscrType;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistEntity;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.state.PersistState;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLNames;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.xml.XMLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class PersistSubscrType extends SubscrType implements IPersistSubscrType {

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#getClassLoader()
	 */
	protected ClassLoader getClassLoader() {
		return ((IPersistSubscription)getFilter().getSubscription()).getApplication().getClassLoader();
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#load(com.sap.caf.rt.services.notify.subscr.persist.IPersistManager)
	 */
	public void load(IPersistManager manager) throws PersistException {
		if (manager instanceof IXMLPersistManager) {
			load((IXMLPersistManager)manager);
		}
		else if (manager instanceof ISQLPersistManager) {
			load((ISQLPersistManager)manager);
		}
	}
	
	protected void load(ISQLPersistManager manager) throws PersistException {
		Map values = SQLUtils.loadObjValues(manager, ISQLNames.SELECT_FLT_TYPE, 
			ISQLNames.SELECT_FLT_TYPE_TYPES, this);
		setId((String)values.get(ISQLNames.TYPE_ID));
	}
	
	protected void load(IXMLPersistManager manager) throws PersistException {
		Node root = manager.getCurrentNode();
		setId(XMLUtils.getStrNodeAttrValue(root, IXMLNames.ATTR_ID, true));
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#create()
	 */
	public void create(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			ISQLPersistManager sqlManager = (ISQLPersistManager)manager; 
			setKey(SQLUtils.createKey());
			SQLUtils.execUpdate(sqlManager, ISQLNames.INSERT_FLT_TYPE,
				ISQLNames.INSERT_FLT_TYPE_TYPES, 
				new Object[] {
					getKey(), // type_key
					((ISQLPersistEntity)getFilter()).getKey(), // filter_key
					getId(), // id
				});
		}		
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#store()
	 */
	public void store(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			ISQLPersistManager sqlManager = (ISQLPersistManager)manager; 
			SQLUtils.execUpdate(sqlManager, ISQLNames.UPDATE_FLT_TYPE,
				ISQLNames.UPDATE_FLT_TYPE_TYPES, 
				new Object[] {
					((ISQLPersistEntity)getFilter()).getKey(), // filter_key
					getId(), // id
					getKey(), // type_key
				});
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#delete()
	 */
	public void delete(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			ISQLPersistManager sqlManager = (ISQLPersistManager)manager; 
			SQLUtils.execUpdate(sqlManager, ISQLNames.DELETE_FLT_TYPE,
				ISQLNames.DELETE_FLT_TYPE_TYPES, 
				new Object[] {
					getKey(), // type_key
					((ISQLPersistEntity)getFilter()).getKey() // filter_key
				});
		}
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#getStateMachine()
	 */
	public IPersistState getState() {
		return m_state;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistEntity#getKey()
	 */
	public Object getKey() {
		return m_key;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistEntity#setKey(java.lang.Object)
	 */
	public void setKey(Object key) {
		m_key = key;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.SubscrType#setId(java.lang.String)
	 */
	public void setId(String id) {
		super.setId(id);
		getState().setUpdated(true);
	}

	private IPersistState m_state = new PersistState();
	private Object m_key;

}
