package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import java.util.Collection;
import java.util.Map;

import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.subscr.SubscrRecipients;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.PersistUtils;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistEntity;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.state.PersistState;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLNames;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.xml.XMLUtils;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class PersistSubscrRecipients extends SubscrRecipients	implements IPersistSubscrRecipients {

	protected ClassLoader getClassLoader() {
		return ((IPersistSubscription)getSubscription()).getApplication().getClassLoader();
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#getStateMachine()
	 */
	public IPersistState getState() {
		return m_state;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#load()
	 */
	public void load(IPersistManager manager) throws PersistException {
		if (manager instanceof IXMLPersistManager) {
			load((IXMLPersistManager)manager);
		}
		else if (manager instanceof ISQLPersistManager) {
			load((ISQLPersistManager)manager);
		}
	}

	protected void load(IXMLPersistManager manager) throws PersistException {
		IPersistApplication app = (IPersistApplication)getSubscription().getApplication(); 
		setDescription(PersistUtils.resolveResRef(XMLUtils.getStrChildNodeValue(manager.getCurrentNode(), 
			IXMLNames.TAG_DESCR, true),	app.getResourceName(), app.getClassLoader()));
	}
	
	protected void load(ISQLPersistManager manager) throws PersistException {
		Map values = SQLUtils.loadObjValues(manager, ISQLNames.SELECT_RECIP, ISQLNames.SELECT_RECIP_TYPES, this);
		setDescription((String)values.get(ISQLNames.RECIP_DESCR));
	}
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#store()
	 */
	public void store(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			ISQLPersistManager sqlManager = (ISQLPersistManager)manager; 
			SQLUtils.execUpdate(sqlManager, ISQLNames.UPDATE_RECIP,
			ISQLNames.UPDATE_RECIP_TYPES, 
				new Object[] {
					((ISQLPersistEntity)getSubscription()).getKey(), // subscr_key
					getClass().getName(), // class_name
					getDescription(), // descr
					getKey(), // recip_key
				});
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#delete()
	 */
	public void delete(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			ISQLPersistManager sqlManager = (ISQLPersistManager)manager; 
			SQLUtils.execUpdate(sqlManager, ISQLNames.DELETE_RECIP,
				ISQLNames.DELETE_RECIP_TYPES, 
				new Object[] {
					getKey(), // recip_key
					((ISQLPersistEntity)getSubscription()).getKey() // subscr_key 
				});
		}
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#create()
	 */
	public void create(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			ISQLPersistManager sqlManager = (ISQLPersistManager)manager; 
			setKey(SQLUtils.createKey());
			SQLUtils.execUpdate(sqlManager, ISQLNames.INSERT_RECIP,
				ISQLNames.INSERT_RECIP_TYPES, 
				new Object[] {
					getKey(), // recip_key
					((ISQLPersistEntity)getSubscription()).getKey(), // subscr_key
					getClass().getName(), // class_name
					getDescription() // descr
				});
		}		
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.SubscrRecipients#setDescription(java.lang.String)
	 */
	public void setDescription(String descr) {
		super.setDescription(descr);
		getState().setUpdated(true);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistEntity#getKey()
	 */
	public Object getKey() {
		return m_key;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistEntity#setKey(java.lang.Object)
	 */
	public void setKey(Object key) {
		m_key = key;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.SubscrRecipients#getUserIds(com.sap.caf.rt.services.notify.notif.INotifEvent)
	 */
	public Collection getUserIds(INotifEvent event) {
		return null;
	}
	
	private Object m_key;
	private IPersistState m_state = new PersistState();

}
