package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import java.util.Map;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.subscr.SubscrPrefs;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.state.PersistState;
import com.sap.security.api.IUser;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class PersistSubscrPrefs
	extends SubscrPrefs
	implements IPersistSubscrPrefs {

	/**
	 * @param subscrId
	 * @param userId
	 */
	PersistSubscrPrefs(IPersistSubscription subscr, IUser user) {
		super(subscr, user.getUniqueID());
	}

	Object getSubscrKey() {
		return ((IPersistSubscription)getSubscription()).getKey();
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistEntity#getKey()
	 */
	public Object getKey() {
		return m_key;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistEntity#setKey(java.lang.Object)
	 */
	public void setKey(Object key) {
		m_key = key;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#getState()
	 */
	public IPersistState getState() {
		return m_state;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#create(com.sap.caf.rt.services.notify.subscr.persist.IPersistManager)
	 */
	public void create(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			ISQLPersistManager sqlManager = (ISQLPersistManager)manager; 
			setKey(SQLUtils.createKey());
			SQLUtils.execUpdate(sqlManager, ISQLNames.INSERT_PREF,
				ISQLNames.INSERT_PREF_TYPES, 
				new Object[] {
					getKey(), // pref_key
					getSubscrKey(), //subscr_key
					getUserId(), //  user_id
					isActionInboxEnabled()? SQLUtils.INT_1: SQLUtils.INT_0, // flag_act_inbox
					isSubscribed()? SQLUtils.INT_1: SQLUtils.INT_0 // flag_subscr
				});
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#delete(com.sap.caf.rt.services.notify.subscr.persist.IPersistManager)
	 */
	public void delete(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			SQLUtils.execUpdate((ISQLPersistManager)manager, ISQLNames.DELETE_PREF,
				ISQLNames.DELETE_PREF_TYPES, 
				new Object[] {
					getKey() // pref_key
				});
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#load(com.sap.caf.rt.services.notify.subscr.persist.IPersistManager)
	 */
	public void load(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			Object subscrKey = getSubscrKey();
			if (subscrKey==null) {
				if (Log.isDebugEnabled()) {
					Log.debug("Could not load subscr prefs for user:["+getUserId()+"]. Subscr key is null!");
				}
				return;
			}
			Map values = SQLUtils.loadObjValues(
					(ISQLPersistManager)manager, 
					ISQLNames.SELECT_PREF, 
					ISQLNames.SELECT_PREF_TYPES, 
					new Object[] {subscrKey, getUserId()}, 
					this
				);
			setKey((String)values.get(ISQLNames.PREF_KEY));
			setActionInboxEnabled(SQLUtils.INT_1.equals((Integer)values.get(ISQLNames.PREF_FLAG_ACT_INBOX)));
			setSubscribed(SQLUtils.INT_1.equals((Integer)values.get(ISQLNames.PREF_FLAG_SUBSCR)));
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#store(com.sap.caf.rt.services.notify.subscr.persist.IPersistManager)
	 */
	public void store(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			SQLUtils.execUpdate((ISQLPersistManager)manager, ISQLNames.UPDATE_PREF,
			ISQLNames.UPDATE_PREF_TYPES, 
				new Object[] {
					getSubscrKey(), // subscr_key
					getUserId(), // group_id
					isActionInboxEnabled()? SQLUtils.INT_1: SQLUtils.INT_0, // flag_act_inbox
					isSubscribed()? SQLUtils.INT_1: SQLUtils.INT_0, // flag_subscr
					getKey() // subscr_key
				});
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrPrefs#setActionInboxEnabled(boolean)
	 */
	public void setActionInboxEnabled(boolean enabled) {
		super.setActionInboxEnabled(enabled);
		getState().setUpdated(true);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrPrefs#setSubscribed(boolean)
	 */
	public void setSubscribed(boolean subscribed) {
		super.setSubscribed(subscribed);
		getState().setUpdated(true);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrPrefs#setUserId(java.lang.String)
	 */
	public void setUserId(String userId) {
		super.setUserId(userId);
		getState().setUpdated(true);
	}

	private Object m_key;
	private IPersistState m_state = new PersistState();

}
