package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import com.sap.caf.rt.services.notify.subscr.ISubscription;
import com.sap.caf.rt.services.notify.subscr.SubscrList;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public abstract class PersistSubscrList extends SubscrList implements IPersistSubscrList {

	public void store(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			store((ISQLPersistManager)manager); 
		}
	}

	protected void store(ISQLPersistManager manager) throws PersistException {	
		for(Iterator itr = getDirtySubscrs(); itr.hasNext(); ) {
			IPersistSubscription subscr = (IPersistSubscription)itr.next();
			IPersistState state = subscr.getState();
			if (!state.isChanged()) {
				continue;
			}
			else if (state.isCreated()) {
				manager.create(subscr);
			}
			else if (state.isUpdated()){
				manager.store(subscr);
			}
			else if (state.isDeleted()){
				manager.delete(subscr);
				itr.remove(); // remove dirty deleted
			}
		}
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#load()
	 */
	public void load(IPersistManager manager) throws PersistException {
		if (manager instanceof IXMLPersistManager) {
			load((IXMLPersistManager)manager);
		}
		else if (manager instanceof ISQLPersistManager) {
			load((ISQLPersistManager)manager);
		}
	}

	protected void load(IXMLPersistManager manager) throws PersistException {
	}
	
	protected void load(ISQLPersistManager manager) throws PersistException {
	}

	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrList#addSubscription(com.sap.caf.rt.services.notify.subscr.ISubscription)
	 */
	public void addSubscription(ISubscription subscr) {
		super.addSubscription(subscr);
		((IPersistEntity)subscr).getState().setCreated(true);
		addDirtySubscr(subscr);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrList#removeSubscription(java.lang.String)
	 */
	public void removeSubscription(String id) {
		IPersistSubscription subscr = (IPersistSubscription)getSubscription(id);
		if (subscr!=null) { 
			super.removeSubscription(id);
			subscr.getState().setDeleted(true);
		}
	}

	protected Iterator getDirtySubscrs() {
		return m_dirtySubscrs.values().iterator();
	}

	protected void addDirtySubscr(ISubscription subscr) {
		m_dirtySubscrs.put(subscr.getId(), subscr);
	}
	
	protected void removeDirtySubscr(String id) {
		m_dirtySubscrs.remove(id);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrList#isEmpty()
	 */
	public boolean hasChanged() {
		if (m_dirtySubscrs.isEmpty()) {
			return false;
		}
		if (m_dirtySubscrs.size()!=getSize()) {
			return true;
		}
		for(Iterator itr=getDirtySubscrs(); itr.hasNext(); ) {
			IPersistSubscription subscr = (IPersistSubscription)itr.next();
			if (subscr.getState().isChanged()) {
				return true;
			}
		}
		return false;
	}
	
	protected abstract ClassLoader getClassLoader();
	
	private Map m_dirtySubscrs = new LinkedHashMap();

}
