package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.w3c.dom.Node;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.subscr.SubscrFilter;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistEntity;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.state.PersistState;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLNames;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.xml.XMLUtils;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class PersistSubscrFilter extends SubscrFilter implements IPersistSubscrFilter {

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#getStateMachine()
	 */
	public IPersistState getState() {
		return m_state;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#load(com.sap.caf.rt.services.notify.subscr.persist.IPersistManager)
	 */
	public void load(IPersistManager manager) throws PersistException {
		if (manager instanceof IXMLPersistManager) {
			load((IXMLPersistManager)manager);
		}
		else if (manager instanceof ISQLPersistManager) {
			load((ISQLPersistManager)manager);
		}
	}


	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#create(com.sap.caf.rt.services.notify.subscr.persist.IPersistManager)
	 */
	public void create(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			ISQLPersistManager sqlManager = (ISQLPersistManager)manager; 
			setKey(SQLUtils.createKey());
			SQLUtils.execUpdate(sqlManager, ISQLNames.INSERT_FILTER,
				ISQLNames.INSERT_FILTER_TYPES, 
				new Object[] {
					getKey(), // filter_key
					((ISQLPersistEntity)getSubscription()).getKey(), // subscr_key
					getClass().getName() // class_name
				});
			// manage dependent entities
			for (Iterator itr=getTypes(); itr.hasNext(); ) {
				manager.create((IPersistEntity)itr.next());
			}
		}
	}


	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#store(com.sap.caf.rt.services.notify.subscr.persist.IPersistManager)
	 */
	public void store(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			ISQLPersistManager sqlManager = (ISQLPersistManager)manager; 
			// TODO add values
			SQLUtils.execUpdate(sqlManager, ISQLNames.UPDATE_FILTER,
				ISQLNames.UPDATE_FILTER_TYPES, 
				new Object[] {
					((ISQLPersistEntity)getSubscription()).getKey(), // subscr_key
					getClass().getName(), // class_name
					getKey(), // filter_key
				});
			// manage dependent entities
			for (Iterator itr=getTypes(); itr.hasNext(); ) {
				manager.store((IPersistEntity)itr.next());
			}
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#delete(com.sap.caf.rt.services.notify.subscr.persist.IPersistManager)
	 */
	public void delete(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			ISQLPersistManager sqlManager = (ISQLPersistManager)manager; 
			// manage dependent entities
			for (Iterator itr=getTypes(); itr.hasNext(); ) {
				manager.delete((IPersistEntity)itr.next());
			}
			SQLUtils.execUpdate(sqlManager, ISQLNames.DELETE_FILTER,
				ISQLNames.DELETE_FILTER_TYPES, 
				new Object[] {
					getKey(), // filter_key
					((ISQLPersistEntity)getSubscription()).getKey() // subscr_key
				});
		}
	}
	
	protected void load(IXMLPersistManager manager) throws PersistException {
		Node root = manager.getCurrentNode();
		Node node;
		ClassLoader classLoader = getClassLoader();
		List nodes = XMLUtils.getNodesAsList(root, IXMLNames.TAG_TYPE);
		for(int i = 0; i<nodes.size(); i++) {
			node = (Node)nodes.get(i);
			if (IXMLNames.TAG_TYPE.equals(node.getNodeName())) {
				IPersistSubscrType subscrType = new PersistSubscrType();
				subscrType.setFilter(this);
				manager.load(node, subscrType);
				addType(subscrType);
			}
		}
	}

	protected void load(ISQLPersistManager manager) throws PersistException {
		List rows = SQLUtils.execSelect(manager, ISQLNames.SELECT_FLT_TYPES, 
			ISQLNames.SELECT_FLT_TYPES_TYPES, new Object[] {getKey()});
		for(int i=rows.size(); --i>=0; ) {
			Map row = (Map)rows.get(i);
			IPersistSubscrType subscrType = new PersistSubscrType();
			subscrType.setKey((String)row.get(ISQLNames.TYPE_KEY));
			manager.load(subscrType);
			addType(subscrType);
			subscrType.getState().reset();
		}
	}
	
	protected ClassLoader getClassLoader() {
		return ((IPersistSubscription)getSubscription()).getApplication().getClassLoader();
	}


	public Object getKey() {
		return m_key;
	}

	public void setKey(Object key) {
		m_key = key;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrFilter#accept(com.sap.caf.rt.services.notify.notif.INotifEvent)
	 */
	public boolean accept(INotifEvent event) {
		IPersistSubscription subscr = (IPersistSubscription)getSubscription(); 
		if (!subscr.isActive()) {
			if (Log.isDebugEnabled()) {
				Log.debug("Subscription:"+subscr.getId()+" is inactive, event ignored");
			}
			return false;
		}
		return super.accept(event);
	}
	
	private IPersistState m_state = new PersistState();
	private Object m_key;


}
