package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.sap.caf.rt.services.notify.subscr.app.ApplicationList;
import com.sap.caf.rt.services.notify.subscr.app.IApplication;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class PersistApplicationList extends ApplicationList implements IPersistApplicationList {

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#load()
	 */
	public void load(IPersistManager manager) throws PersistException {
		clearApplications();
		clearDirtyApplications();
		if (manager instanceof ISQLPersistManager) {
			load((ISQLPersistManager)manager);
		}
	}

	protected void load(ISQLPersistManager manager) throws PersistException {
		List rows = SQLUtils.execSelect(manager, ISQLNames.SELECT_APP_KES, 
			ISQLNames.SELECT_APP_KEYS_TYPES, SQLUtils.EMPTY_PARAMS);
		Map row;
		IPersistApplication app;
		for(int i=rows.size(); --i>=0; ) {
			row = (Map)rows.get(i);
			app = new PersistApplication();
			app.setKey((String)row.get(ISQLNames.APP_KEY));
			manager.load(app);
			addApplication(app);
			app.getState().reset();
		}
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#store()
	 */
	public void store(IPersistManager manager) throws PersistException {
		for(Iterator itr = getDirtyApplications(); itr.hasNext(); ) {
			IPersistApplication app = (IPersistApplication)itr.next();
			IPersistState state = app.getState();
			if (!state.isChanged()) {
				continue;
			}
			else if (state.isCreated()) {
				manager.create(app);
			}
			else if (state.isUpdated()){
				manager.store(app);
			}
			else if (state.isDeleted()){
				manager.delete(app);
				itr.remove();
			}
		}
	}

	protected void clearDirtyApplications() {
		m_dirtyApps.clear();	
	}
	
	
	protected Iterator getDirtyApplications() {
		return m_dirtyApps.values().iterator();
	}

	protected void addDirtyApplication(IApplication app) {
		m_dirtyApps.put(app.getId(), app);
	}
	
	protected void removeDirtyApplication(String id) {
		m_dirtyApps.remove(id);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.IApplicationList#addApplication(com.sap.caf.rt.services.notify.subscr.app.IApplication)
	 */
	public boolean addApplication(IApplication app) {
		if (!super.addApplication(app)) {
			return false;
		}
		((IPersistApplication)app).getState().setCreated(true);
		addDirtyApplication(app);
		return true;		
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.IApplicationList#removeApplication(java.lang.String)
	 */
	public void removeApplication(String id) {
		IApplication app = getApplication(id);
		if (app!=null) {
			super.removeApplication(id);
			((IPersistApplication)app).getState().setDeleted(true);
		}
		
	}

	private Map m_dirtyApps = new LinkedHashMap();
}
