package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import java.util.Map;
import java.util.Properties;

import org.w3c.dom.Node;

import com.sap.caf.rt.services.notify.common.JndiUtils;
import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.res.IResourceKeys;
import com.sap.caf.rt.services.notify.subscr.app.Application;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.state.PersistState;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLNames;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.xml.XMLUtils;
import com.sap.engine.services.deploy.DeployService;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class PersistApplication extends Application implements IPersistApplication {

	public PersistApplication() {
	}

	public PersistApplication(String id) {
		super(id, null, null);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#getStateMachine()
	 */
	public IPersistState getState() {
		return m_state;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#load(com.sap.caf.rt.services.notify.subscr.persist.IPersistManager)
	 */
	public void load(IPersistManager manager) throws PersistException {
		if (manager instanceof IXMLPersistManager) {
			load((IXMLPersistManager) manager);
		} else if (manager instanceof ISQLPersistManager) {
			load((ISQLPersistManager) manager);
		}
	}

	protected void load(ISQLPersistManager manager) throws PersistException {
		try {
			Map values = SQLUtils.loadObjValues(manager, ISQLNames.SELECT_APP, ISQLNames.SELECT_APP_TYPES, this);
			String id = (String) values.get(ISQLNames.APP_ID);
			setId(id);
			setName((String) values.get(ISQLNames.APP_NAME));
			setResourceName((String) values.get(ISQLNames.APP_RES_NAME));
			invalidate();
		} catch (PersistException e) {
			throw new PersistException(IResourceKeys.CANT_LOAD_APP, e);
		}
	}

	public void invalidate() throws PersistException {
		ClassLoader appLoader = null;
		Properties appProps = null;
		setActive(false);
		try {
			String appId = getId();
			ClassLoader runtimeLoader = getClass().getClassLoader();
			appLoader = JndiUtils.getAppClassLoader(runtimeLoader, appId);
			appProps = JndiUtils.getAppProperties(runtimeLoader, appId);
			DeployService deplSvc = JndiUtils.getDeployService(runtimeLoader);
			setActive("STARTED".equals(deplSvc.getApplicationStatus(appId)));
		} catch (Exception e) {
			Log.fatal(e);
			appLoader = null;
			appProps = null;
			setActive(false);
		}
		setClassLoader(appLoader);
		setProperties(appProps);
	}

	protected void load(IXMLPersistManager manager) throws PersistException {
		Node root = manager.getCurrentNode();
		Map nodes = XMLUtils.getNodesAsMap(root);
		setName(XMLUtils.getStrChildNodeValue(root, nodes, IXMLNames.TAG_NAME, true));
		setResourceName(XMLUtils.getStrChildNodeValue(root, nodes, IXMLNames.TAG_RESOURCES, true));
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#create()
	 */
	public void create(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			ISQLPersistManager sqlManager = (ISQLPersistManager) manager;
			setKey(SQLUtils.createKey());
			SQLUtils.execUpdate(sqlManager, ISQLNames.INSERT_APP, ISQLNames.INSERT_APP_TYPES, new Object[] { getKey(), //app_key 
				getId(), // id
				getName(), // name
				getResourceName() // res_name
			});
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#store()
	 */
	public void store(IPersistManager manager) throws PersistException {
		if (!isActive()) {
			throw new PersistException(IResourceKeys.CANT_STORE_INACTIVE, new Object[] { getKey()});
		}
		if (manager instanceof ISQLPersistManager) {
			ISQLPersistManager sqlManager = (ISQLPersistManager) manager;
			// TODO add values
			SQLUtils.execUpdate(sqlManager, ISQLNames.UPDATE_APP, ISQLNames.UPDATE_APP_TYPES, new Object[] { getId(), // id
				getName(), // name
				getResourceName(), // res_name
				getKey() //app_key 
			});
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#delete()
	 */
	public void delete(IPersistManager manager) throws PersistException {
		if (manager instanceof ISQLPersistManager) {
			ISQLPersistManager sqlManager = (ISQLPersistManager) manager;
			SQLUtils.execUpdate(sqlManager, ISQLNames.DELETE_APP, ISQLNames.DELETE_APP_TYPES, new Object[] { getKey()
				// app_key
			});
		}
	}

	public String getName() {
		return m_sName;
	}

	protected void setName(String name) {
		m_sName = name;
		getState().setUpdated(true);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity#getKey()
	 */
	public Object getKey() {
		return m_key;
	}

	public void setKey(Object key) {
		m_key = key;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.Application#setId(java.lang.String)
	 */
	public void setId(String id) {
		super.setId(id);
		getState().setUpdated(true);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrList#getResourceName()
	 */
	public String getResourceName() {
		return m_sResName;
	}

	public void setResourceName(String name) {
		m_sResName = name;
		getState().setUpdated(true);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.Application#setClassLoader(java.lang.ClassLoader)
	 */
	public void setClassLoader(ClassLoader loader) {
		super.setClassLoader(loader);
		setActive(loader != null);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.IApplication#getClassLoader()
	 */
	public ClassLoader getClassLoader() {
		ClassLoader classLoader = super.getClassLoader();
		return classLoader != null ? classLoader : getClass().getClassLoader();
	}

	private Object m_key;
	private String m_sResName;
	private String m_sName;
	private IPersistState m_state = new PersistState();

}
