package com.sap.caf.rt.services.notify.subscr.persist.state;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public final class PersistState implements IPersistState {

	public PersistState() {
		m_created = true;
		m_updated = false;
		m_deleted = false;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState#isCreated()
	 */
	public boolean isCreated() {
		return m_created;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState#setCreated(boolean)
	 */
	public void setCreated(boolean created) {
		m_created = created;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState#isUpdated()
	 */
	public boolean isUpdated() {
		return m_updated;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState#setUpdated(boolean)
	 */
	public void setUpdated(boolean updated) {
		m_updated = updated;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState#isDeleted()
	 */
	public boolean isDeleted() {
		return m_deleted;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState#setDeleted(boolean)
	 */
	public void setDeleted(boolean deleted) {
		m_deleted = deleted;
	}

	public boolean isChanged() {
		return m_created || m_updated || m_deleted;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState#reset()
	 */
	public void reset() {
		m_created=false;
		m_updated=false;
		m_deleted=false;
	}


	private boolean m_deleted;
	private boolean m_updated;
	private boolean m_created;

}
