package com.sap.caf.rt.services.notify.subscr.persist.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

import com.sap.caf.rt.bol.pk.PrimaryKeyFactory;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.services.notify.res.IResourceKeys;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.PersistObjNotFoundException;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class SQLUtils {

	public static Object[] EMPTY_PARAMS = {
	};
	public static Integer INT_0 = new Integer(0);
	public static Integer INT_1 = new Integer(1);

	public static String createKey() throws PersistException {
		try {
			return PrimaryKeyFactory.getInstance().getPrimaryKey();
		} catch (DataAccessException e) {
			throw new PersistException(IResourceKeys.CANT_CREATE_PK, e);
		}
	}

	public static void execUpdate(ISQLPersistManager manager, String sql, int[] types, Object[] params) throws PersistException {
		try {
			Connection conn = manager.getConnection();
			try {
				PreparedStatement pstmt = conn.prepareStatement(sql);
				try {
					for (int i = 0; i < params.length; i++) {
						setParam(pstmt, i + 1, params[i], types[i]);
					}
					pstmt.execute();
				} finally {
					pstmt.close();
				}
			} finally {
				conn.close();
			}
		} catch (SQLException e) {
			throw new PersistException(IResourceKeys.CANT_EXEC_SQL, new Object[] { sql, params }, e);
		}
	}

	public static List execSelect(ISQLPersistManager manager, String sql, int[] types, Object[] params) throws PersistException {
		try {
			Connection conn = manager.getConnection();
			try {
				PreparedStatement pstmt = conn.prepareStatement(sql);
				try {
					for (int i = 0; i < params.length; i++) {
						setParam(pstmt, i + 1, params[i], types[i]);
					}
					ResultSet rs = pstmt.executeQuery();
					if (!rs.next()) {
						return Collections.EMPTY_LIST;
					}
					ResultSetMetaData meta = rs.getMetaData();
					int cols = meta.getColumnCount();
					List rows = new ArrayList();
					Map row;
					do {
						row = new LinkedHashMap();
						for (int i = 1; i <= cols; i++) {
							row.put(meta.getColumnName(i), rs.getObject(i));
						}
						rows.add(row);
					} while (rs.next());
					return rows;
				} finally {
					pstmt.close();
				}
			} finally {
				conn.close();
			}
		} catch (SQLException e) {
			throw new PersistException(IResourceKeys.CANT_EXEC_SQL, new Object[] { sql, params }, e);
		}
	}

	public static Map loadObjValues(ISQLPersistManager manager, String sql, int[] paramTypes, ISQLPersistEntity obj) throws PersistException {
		Object key = obj.getKey();
		if (key == null) {
			throw new PersistException(IResourceKeys.NULL_KEY, new Object[] { obj.getClass().getName()});
		}
		List rows = SQLUtils.execSelect(manager, sql, paramTypes, new Object[] { key });
		if (rows.size() == 0) {
			throw new PersistObjNotFoundException(obj, key);
		}
		return (Map) rows.get(0);
	}

	public static Map loadObjValues(ISQLPersistManager manager, String sql, int[] keyTypes, Object[] keyValues, ISQLPersistEntity obj) throws PersistException {
		for (int i = keyValues.length; --i >= 0;) {
			if (keyValues[i] == null) {
				throw new PersistException(IResourceKeys.NULL_KEY, new Object[] { obj.getClass().getName()});
			}
		}
		List rows = SQLUtils.execSelect(manager, sql, keyTypes, keyValues);
		if (rows.size() == 0) {
			throw new PersistObjNotFoundException(obj, keyValues);
		}
		return (Map) rows.get(0);
	}

	public static Map loadMap(ISQLPersistManager manager, String sql, int[] keyTypes, Object[] keyValues) throws PersistException {
		List rows = SQLUtils.execSelect(manager, sql, keyTypes, keyValues);
		if (rows == null || rows.isEmpty()) {
			return Collections.EMPTY_MAP;
		}
		Map row;
		Map result = new LinkedHashMap();
		String[] entry;
		for (int i = 0; i < rows.size(); i++) {
			row = (Map) rows.get(i);
			entry = (String[]) row.values().toArray(new String[2]);
			result.put(entry[0], entry[1]);
		}
		return result;
	}

	//
	//	public static Object loadIncludedObj(ISQLPersistManager manager, String sql, String keyName, Object[] params, 
	//		ClassLoader loader) throws PersistException 
	//	{	
	//		List rows = SQLUtils.execSelect(manager, sql, new int[] {Types.VARCHAR}, params); 
	//		if (rows==null || rows.size()==0) {
	//			throw new PersistException(IResourceKeys.CANT_LOAD_OBJ);
	//		}
	//		Map row = (Map)rows.get(0);
	//		String className = (String)row.get(ISQLNames.CLASS_NAME);
	//		PersistUtils.newObject(className, getApplication().getClassLoader(), IPersistSubscrTemplate.class);
	//	}
	//	
	private static void setParam(PreparedStatement pstmt, int num, Object value, int type) throws SQLException {
		if (value == null) {
			pstmt.setNull(num, type);
		} else if (Types.VARCHAR == type) {
			pstmt.setString(num, ((String) value).trim());
		} else if (Types.INTEGER == type) {
			pstmt.setInt(num, ((Integer) value).intValue());
		} else {
			throw new UnsupportedOperationException("Type:[" + type + "] is not supported");
		}
	}

}
