package com.sap.caf.rt.services.notify.subscr.persist.sql;

import java.sql.Types;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public interface ISQLNames {
	
	// table CAF_RT_NS_APP
	static final String APP_KEY = "APP_KEY";
	static final String APP_ID = "ID";
	static final String APP_NAME = "NAME";
	static final String APP_RES_NAME = "RES_NAME";
	static final String APP_TABLE = "CAF_RT_NS_APP";
	static final String INSERT_APP = 
		"INSERT INTO "+APP_TABLE+" " +
			"("+APP_KEY+","+APP_ID+","+APP_NAME+","+APP_RES_NAME+") " +
			"VALUES (?,?,?,?)";
	static final int[] INSERT_APP_TYPES =
		{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR, Types.VARCHAR};
	static final String UPDATE_APP = 
		"UPDATE "+APP_TABLE+" SET "+APP_ID+"=?,"+APP_NAME+"=?,"+APP_RES_NAME+"=?"+" " +
			"WHERE ("+APP_KEY+"=?)";
	static final int[] UPDATE_APP_TYPES = 
		{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR, Types.VARCHAR};
	static final String DELETE_APP = 
		"DELETE FROM "+APP_TABLE+" WHERE ("+APP_KEY+"=?)";
	static final int[] DELETE_APP_TYPES = 
		{Types.VARCHAR};
	static final String SELECT_APP_KES = 
		"SELECT "+APP_KEY+" FROM "+APP_TABLE;
	static final int[] SELECT_APP_KEYS_TYPES = {};
	static final String SELECT_APP = 
		"SELECT "+APP_ID+","+APP_NAME+","+APP_RES_NAME+" FROM "+APP_TABLE+" "+
			"WHERE ("+APP_KEY+"=?)";
	static final int[] SELECT_APP_TYPES = 
		{Types.VARCHAR};
	
	// table CAF_RT_NS_SUBSCR
	static final String SUBSCR_KEY = "SUBSCR_KEY";
	static final String SUBSCR_ID = "ID";
	static final String SUBSCR_GRP_ID = "GROUP_ID";
	static final String SUBSCR_ENABLED = "IS_ENABLED";
	static final String SUBSCR_DESCR = "DESCR";
	static final String SUBSCR_TABLE = "CAF_RT_NS_SUBSCR";
	static final String INSERT_SUBSCR = 
		"INSERT INTO "+SUBSCR_TABLE+" "+
			"("+SUBSCR_KEY+","+APP_KEY+","+SUBSCR_ID+","+SUBSCR_GRP_ID+","+
			SUBSCR_ENABLED+","+SUBSCR_DESCR+") "+
			"VALUES (?,?,?,?,?,?)";	
	static final int[] INSERT_SUBSCR_TYPES = 
		{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR, Types.VARCHAR, Types.INTEGER, Types.VARCHAR};
	static final String UPDATE_SUBSCR = 
		"UPDATE "+SUBSCR_TABLE+" SET "+
			APP_KEY+"=?,"+SUBSCR_ID+"=?,"+SUBSCR_GRP_ID+"=?,"+
			SUBSCR_ENABLED+"=?,"+SUBSCR_DESCR+"=?"+" "+
			"WHERE ("+SUBSCR_KEY+"=?)";
	static final int[] UPDATE_SUBSCR_TYPES = 
		{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR, Types.INTEGER, Types.VARCHAR, Types.VARCHAR};
	static final String DELETE_SUBSCR = 
		"DELETE FROM "+SUBSCR_TABLE+" WHERE ("+SUBSCR_KEY+"=?)";
	static final int[] DELETE_SUBSCR_TYPES = 
		{Types.VARCHAR};
	static final String SELECT_SUBSCR_KEYS = 
		"SELECT "+SUBSCR_KEY+" FROM "+SUBSCR_TABLE+" WHERE ("+APP_KEY+"=?)";
	static final int[] SELECT_SUBSCR_KEYS_TYPES = 
		{Types.VARCHAR}; 
	static final String SELECT_SUBSCR = 
		"SELECT "+SUBSCR_ID+","+SUBSCR_GRP_ID+","+SUBSCR_ENABLED+","+SUBSCR_DESCR+" "+
			"FROM "+SUBSCR_TABLE+" WHERE ("+SUBSCR_KEY+"=?)";
	static final int[] SELECT_SUBSCR_TYPES = 
		{Types.VARCHAR}; 
	
	// table CAF_RT_NS_FLT
	static final String FLT_KEY = "FILTER_KEY";
	static final String FLT_CLASS_NAME = "CLASS_NAME";
	static final String FLT_TABLE = "CAF_RT_NS_FLT";
	static final String INSERT_FILTER = 
		"INSERT INTO "+FLT_TABLE+" "+
			"("+FLT_KEY+","+SUBSCR_KEY+","+FLT_CLASS_NAME+") "+
			"VALUES (?,?,?)";
	static final int[] INSERT_FILTER_TYPES = 
		{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR};
	static final String UPDATE_FILTER = 
		"UPDATE "+FLT_TABLE+" SET "+SUBSCR_KEY+"=?,"+FLT_CLASS_NAME+"=?"+" "+
		"WHERE ("+FLT_KEY+"=?)";
	static final int[] UPDATE_FILTER_TYPES = 
		{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR};
	static final String DELETE_FILTER = 
		"DELETE FROM "+FLT_TABLE+" WHERE ("+FLT_KEY+"=? AND "+SUBSCR_KEY+"=?)";
	static final int[] DELETE_FILTER_TYPES = 
		{Types.VARCHAR, Types.VARCHAR};
	static final String SELECT_FLT_KEYS =
		"SELECT "+FLT_KEY+","+FLT_CLASS_NAME+" FROM "+FLT_TABLE+" WHERE ("+SUBSCR_KEY+"=?)";
	static final int[] SELECT_FLT_KEYS_TYPES=
		{Types.VARCHAR};

	// table CAF_RT_NS_FLT_TYPE
	static final String TYPE_KEY = "TYPE_KEY";
	static final String TYPE_ID = "ID";
	static final String FLT_TYPE_TABLE = "CAF_RT_NS_FLT_TYPE";
	static final String INSERT_FLT_TYPE = 
		"INSERT INTO "+FLT_TYPE_TABLE+" "+
			"("+TYPE_KEY+","+FLT_KEY+","+TYPE_ID+") " +
			"VALUES (?,?,?)";
	static final int[] INSERT_FLT_TYPE_TYPES = 
		{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR}; 
	static final String UPDATE_FLT_TYPE = 
		"UPDATE "+FLT_TYPE_TABLE+" SET "+FLT_KEY+"=?,"+TYPE_ID+"=?"+" "+
			"WHERE ("+TYPE_KEY+"=?)";
	static final int[] UPDATE_FLT_TYPE_TYPES = 
		{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR};
	static final String DELETE_FLT_TYPE = 
		"DELETE FROM "+FLT_TYPE_TABLE+" WHERE ("+TYPE_KEY+"=? AND "+FLT_KEY+"=?);";
	static final int[] DELETE_FLT_TYPE_TYPES = 
		{Types.VARCHAR, Types.VARCHAR};
	static final String SELECT_FLT_TYPES =
		"SELECT "+TYPE_KEY+" FROM "+FLT_TYPE_TABLE+" WHERE ("+FLT_KEY+"=?)";
	static final int[] SELECT_FLT_TYPES_TYPES = 
		{Types.VARCHAR};
	static final String SELECT_FLT_TYPE = 
		"SELECT "+TYPE_ID+" FROM "+FLT_TYPE_TABLE+" WHERE ("+TYPE_KEY+"=?)";
	static final int[] SELECT_FLT_TYPE_TYPES = 
		{Types.VARCHAR};

	// table CAF_RT_NS_TMPL
	static final String TEMPL_KEY = "TEMPL_KEY";	
	static final String TEMPL_ID = "ID";	
	static final String TEMPL_CLASS_NAME = "CLASS_NAME";	
	static final String TEMPL_SUBJ = "SUBJECT";	
	static final String TEMPL_TABLE = "CAF_RT_NS_TMPL";
	static final String INSERT_TEMPL = 
		"INSERT INTO "+TEMPL_TABLE+" " +
			"("+TEMPL_KEY+","+SUBSCR_KEY+","+TEMPL_ID+","+TEMPL_CLASS_NAME+","+TEMPL_SUBJ+") " +
			"VALUES (?,?,?,?,?)";
	static final int[] INSERT_TEMPL_TYPES = 
		{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR, Types.VARCHAR, Types.VARCHAR};
	static final String UPDATE_TEMPL = 
		"UPDATE "+TEMPL_TABLE+" SET "+
		SUBSCR_KEY+"=?,"+TEMPL_ID+"=?,"+TEMPL_CLASS_NAME+"=?,"+TEMPL_SUBJ+"=?"+" "+
		"WHERE ("+TEMPL_KEY+"=?)";
	static final int[] UPDATE_TEMPL_TYPES = 
		{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR, Types.VARCHAR, Types.VARCHAR};
	static final String DELETE_TEMPL = 
		"DELETE FROM "+TEMPL_TABLE+" WHERE ("+TEMPL_KEY+"=? AND "+SUBSCR_KEY+"=?)";
	static final int[] DELETE_TEMPL_TYPES = 
		{Types.VARCHAR, Types.VARCHAR};
	static final String SELECT_TEMPL_KEY =
		"SELECT "+TEMPL_KEY+","+TEMPL_CLASS_NAME+" FROM "+TEMPL_TABLE+" WHERE ("+SUBSCR_KEY+"=?)"; 
	static final int[] SELECT_TEMPL_KEY_TYPES =
		{Types.VARCHAR};
	static final String SELECT_TEMPL =
		"SELECT "+TEMPL_ID+","+TEMPL_SUBJ+" FROM "+TEMPL_TABLE+" WHERE ("+TEMPL_KEY+"=?)"; 
	static final int[] SELECT_TEMPL_TYPES =
		{Types.VARCHAR};

	// table CAF_RT_NS_TEMPLPROP
	static final String TEMPLPROP_NAME = "NAME";	
	static final String TEMPLPROP_VAL = "VAL";	
	static final String TEMPLPROP_TABLE = "CAF_RT_NS_TMPLPROP";
	static final String SELECT_TEMPLPROP =
		"SELECT "+TEMPLPROP_NAME+","+TEMPLPROP_VAL+" " +
			"FROM "+TEMPLPROP_TABLE+" WHERE ("+TEMPL_KEY+"=?)";
	static final int[] SELECT_TEMPLPROP_TYPES =
		{Types.VARCHAR};
	static final String INSERT_TEMPLPROP=
		"INSERT INTO "+TEMPLPROP_TABLE+" "+
			"("+TEMPL_KEY+","+TEMPLPROP_NAME+","+TEMPLPROP_VAL+") "+
			"VALUES (?,?,?)";
	static final int[] INSERT_TEMPLPROP_TYPES = 
		{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR};
	static final String DELETE_TEMPLPROP = 
		"DELETE FROM "+TEMPLPROP_TABLE+" " +
			"WHERE ("+TEMPL_KEY+"=? AND "+TEMPLPROP_NAME+"=?)";
	static final int[] DELETE_TEMPLPROP_TYPES = 
		{Types.VARCHAR, Types.VARCHAR};
	static final String DELETE_TEMPLPROP_TEMPL = 
		"DELETE FROM "+TEMPLPROP_TABLE+" " +
			"WHERE ("+TEMPL_KEY+"=?)";
	static final int[] DELETE_TEMPLPROP_TEMPL_TYPES = 
		{Types.VARCHAR};
	static final String UPDATE_TEMPLPROP =
		"UPDATE "+TEMPLPROP_TABLE+" SET "+TEMPLPROP_VAL+"=?"+" "+
			"WHERE ("+TEMPL_KEY+"=? AND "+TEMPLPROP_NAME+"=?)";
	static final int[] UPDATE_TEMPLPROP_TYPES = 
		{Types.VARCHAR,Types.VARCHAR,Types.VARCHAR};
		
	// table CAF_RT_NS_RECIP
	static final String RECIP_KEY = "RECIP_KEY";
	static final String RECIP_CLASS_NAME = "CLASS_NAME";
	static final String RECIP_DESCR = "DESCR";
	static final String RECIP_TABLE = "CAF_RT_NS_RECIP";
	static final String INSERT_RECIP = 
		"INSERT INTO "+RECIP_TABLE+" "+
			"("+RECIP_KEY+","+SUBSCR_KEY+","+RECIP_CLASS_NAME+","+RECIP_DESCR+") "+
			"VALUES (?,?,?,?)";
	static final int[] INSERT_RECIP_TYPES = 
		{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR, Types.VARCHAR};
	static final String UPDATE_RECIP = 
		"UPDATE "+RECIP_TABLE+" SET "+
			SUBSCR_KEY+"=?,"+RECIP_CLASS_NAME+"=?,"+RECIP_DESCR+"=?"+" "+
			"WHERE ("+RECIP_KEY+"=?)";
	static final int[] UPDATE_RECIP_TYPES = 
		{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR, Types.VARCHAR};
	static final String DELETE_RECIP = 
		"DELETE FROM "+RECIP_TABLE+" WHERE ("+RECIP_KEY+"=? AND "+SUBSCR_KEY+"=?)";
	static final int[] DELETE_RECIP_TYPES = 
		{Types.VARCHAR, Types.VARCHAR};
	static final String SELECT_RECIP_KEY =
		"SELECT "+RECIP_KEY+","+RECIP_CLASS_NAME+" FROM "+RECIP_TABLE+" WHERE ("+SUBSCR_KEY+"=?)";
	static final int[] SELECT_RECIP_KEY_TYPES =
		{Types.VARCHAR};
	static final String SELECT_RECIP =
		"SELECT "+RECIP_DESCR+" FROM "+RECIP_TABLE+" WHERE ("+RECIP_KEY+"=?)";
	static final int[] SELECT_RECIP_TYPES =
		{Types.VARCHAR};


	// table CAF_RT_NS_PREF
	static final String PREF_KEY = "PREF_KEY";
	static final String PREF_USER_ID = "USER_ID";
	static final String PREF_FLAG_ACT_INBOX = "FLAG_ACT_INBOX";
	static final String PREF_FLAG_SUBSCR = "FLAG_SUBSCR";
	static final String PREF_TABLE = "CAF_RT_NS_PREF";
	static final String INSERT_PREF =
		"INSERT INTO "+PREF_TABLE+" " +
			"("+PREF_KEY+","+SUBSCR_KEY+","+PREF_USER_ID+","+PREF_FLAG_ACT_INBOX+","+PREF_FLAG_SUBSCR+") "+
			"VALUES (?,?,?,?,?)"; 
	static final int[] INSERT_PREF_TYPES = 
		{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR, Types.INTEGER, Types.INTEGER};
	static final String SELECT_PREF =
		"SELECT B."+PREF_KEY+",B."+PREF_FLAG_ACT_INBOX+",B."+PREF_FLAG_SUBSCR+" "+
			"FROM "+SUBSCR_TABLE+" A,"+PREF_TABLE+" B"+" " +
				"WHERE A."+SUBSCR_KEY+"=B."+SUBSCR_KEY+" AND A."+SUBSCR_KEY+"=? AND B."+PREF_USER_ID+"=?";
	static final int[] SELECT_PREF_TYPES =
		{Types.VARCHAR, Types.VARCHAR};
	static final String DELETE_PREF = 
		"DELETE FROM "+PREF_TABLE+" WHERE ("+PREF_KEY+"=?)";
	static final int[] DELETE_PREF_TYPES = 
		{Types.VARCHAR};
	static final String UPDATE_PREF = 
		"UPDATE "+PREF_TABLE+" SET "+
			SUBSCR_KEY+"=?,"+PREF_USER_ID+"=?,"+PREF_FLAG_ACT_INBOX+"=?,"+PREF_FLAG_SUBSCR+"=? "+
			"WHERE ("+PREF_KEY+"=?)";
	static final int[] UPDATE_PREF_TYPES = 
		{Types.VARCHAR,Types.VARCHAR,Types.INTEGER,Types.INTEGER,Types.VARCHAR};
		
	static final String PREF_DEL_BY_SUBSCR = 
		"DELETE FROM "+PREF_TABLE+" WHERE ("+SUBSCR_KEY+"=?)";
	static final int[] PREF_DEL_BY_SUBSCR_TYPES =
		{Types.VARCHAR};
		 
}
