package com.sap.caf.rt.services.notify.subscr.persist;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public abstract class PersistManager implements IPersistManager {

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistManager#create(com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity)
	 */
	public void create(IPersistEntity entity) throws PersistException {
		if (entity!=null) {
			entity.create(this);
			entity.getState().reset();
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistManager#delete(com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity)
	 */
	public void delete(IPersistEntity entity) throws PersistException {
		if (entity!=null) {
			entity.delete(this);
			entity.getState().reset();
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistManager#load(com.sap.caf.rt.services.notify.subscr.persist.IPersistable)
	 */
	public void load(IPersistable obj) throws PersistException {
		if (obj!=null) {
			obj.load(this);
			if (obj instanceof IPersistEntity) {
				((IPersistEntity)obj).getState().reset();
			}
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistManager#store(com.sap.caf.rt.services.notify.subscr.persist.IPersistable)
	 */
	public void store(IPersistable obj) throws PersistException {
		if (obj!=null) {
			obj.store(this);
			if (obj instanceof IPersistEntity) {
				((IPersistEntity)obj).getState().reset();
			}
		}
	}
	
}
