package com.sap.caf.rt.services.notify.subscr.app.registered;

import com.sap.caf.rt.services.notify.subscr.SubscrException;
import com.sap.caf.rt.services.notify.subscr.app.GeneralSubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.app.IGeneralSubscrList;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLPersistManager;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class RegisteredSubscrListFactory extends GeneralSubscrListFactory implements IRegisteredSubscrListFactory {

	protected RegisteredSubscrListFactory() throws SubscrException {
		super();
	}

	public static synchronized RegisteredSubscrListFactory getInstance() throws SubscrException {
		if (s_factory==null) {
			s_factory = new RegisteredSubscrListFactory();
		}
		return s_factory;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.registered.IRegisteredSubscrListFactory#getPersistManager()
	 */
	public IPersistManager getPersistManager() throws PersistException {
		return new SQLPersistManager();
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.GeneralSubscrListFactory#getSubscrListInstance()
	 */
	protected IGeneralSubscrList getSubscrListInstance() {
		return new RegisteredSubscrList();
	}

	private static RegisteredSubscrListFactory s_factory;

	
	/** @link dependency 
	 * @stereotype load*/
	/*#ISubscrList lnkSubscrList;*/
}
