package com.sap.caf.rt.services.notify.subscr.app.lifecycle;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.sap.caf.rt.services.notify.common.JndiUtils;
import com.sap.caf.rt.services.notify.common.Log;
import com.sap.engine.services.deploy.DeployCallbackImpl;
import com.sap.engine.services.deploy.DeployEvent;
import com.sap.engine.services.deploy.DeployService;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class AppLifeCycleMonitor implements IAppLifeCycleMonitor {

	protected AppLifeCycleMonitor() throws AppLifeCycleException {
		try {
			ClassLoader runtimeLoader = getClass().getClassLoader();
			DeployService deplSvc = JndiUtils.getDeployService(runtimeLoader);
			DeployCallbackImpl deplCallback = new DeployCallbackImpl();
			deplCallback.addDeployListener(new AppDeployListener(this));
			deplSvc.registerDeployCallback(deplCallback, new String[] { JndiUtils.getClusterElementName(runtimeLoader)});
		} catch (Exception e) {
			Log.fatal(e);
			throw new AppLifeCycleException(e);
		}
	}

	public static synchronized IAppLifeCycleMonitor getInstance() throws AppLifeCycleException {
		if (s_monitor == null) {
			s_monitor = new AppLifeCycleMonitor();
		}
		return s_monitor;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.IAppLifeCycleMonitor#addListener(com.sap.caf.rt.services.notify.subscr.app.IAppLifeCycleListener)
	 */
	public void addListener(IAppLifeCycleListener listener) {
		m_listeners.add(listener);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.IAppLifeCycleMonitor#removeListener(com.sap.caf.rt.services.notify.subscr.app.IAppLifeCycleListener)
	 */
	public void removeListener(IAppLifeCycleListener listener) {
		m_listeners.remove(listener);
	}

	void processEvent(DeployEvent event) {
		byte type = event.getActionType();
		if (type == DeployEvent.STOP_APP || type == DeployEvent.START_APP || type == DeployEvent.REMOVE_APP || type == DeployEvent.DEPLOY_APP || type == DeployEvent.UPDATE_APP) {
			byte phase = event.getAction();
			String appId = event.getComponentName();
			IAppLifeCycleListener listener;
			for (Iterator itr = m_listeners.iterator(); itr.hasNext();) {
				listener = (IAppLifeCycleListener) itr.next();
				listener.appStateChanged(appId, phase, type);
			}
		}
	}

	protected static IAppLifeCycleMonitor s_monitor;
	protected List m_listeners = new LinkedList();
}
