package com.sap.caf.rt.services.notify.subscr.app.deployed;

import com.sap.caf.rt.services.notify.subscr.SubscrException;
import com.sap.caf.rt.services.notify.subscr.app.GeneralSubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.app.IGeneralSubscrList;
import com.sap.caf.rt.services.notify.subscr.app.IGeneralSubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.xml.XMLPersistManager;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class DeployedSubscrListFactory extends GeneralSubscrListFactory implements IGeneralSubscrListFactory {
	

	protected DeployedSubscrListFactory() throws SubscrException {
		super();
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.GeneralSubscrListFactory#getSubscrListInstance()
	 */
	protected IGeneralSubscrList getSubscrListInstance() {
		return new DeployedSubscrList();
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.IGeneralSubscrListFactory#getPersistManager()
	 */
	public IPersistManager getPersistManager() throws PersistException {
		return m_persistManager;
	}


	public static synchronized DeployedSubscrListFactory getInstance() throws SubscrException {
		if (s_factory==null) {
			s_factory = new DeployedSubscrListFactory();
		}
		return s_factory;
	}
	
	private IXMLPersistManager m_persistManager = new XMLPersistManager();
	private static DeployedSubscrListFactory s_factory;

  /** @link dependency 
   * @stereotype create*/
  /*#ISubscrList lnkSubscrList;*/
}
