package com.sap.caf.rt.services.notify.subscr.app.deployed;

import com.sap.caf.rt.services.notify.common.JndiUtils;
import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.res.IResourceKeys;
import com.sap.caf.rt.services.notify.subscr.ISubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.SubscrException;
import com.sap.caf.rt.services.notify.subscr.app.AppSubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.app.GeneralSubscrList;
import com.sap.caf.rt.services.notify.subscr.app.IAppSubscrList;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplication;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistApplication;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import com.sap.engine.services.deploy.ApplicationInformation;
import com.sap.engine.services.deploy.DeployService;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class DeployedSubscrList extends GeneralSubscrList implements IDeployedSubscrList {

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#load(com.sap.caf.rt.services.notify.subscr.persist.IPersistManager)
	 */
	public void load(IPersistManager manager) throws PersistException {
		if (manager instanceof IXMLPersistManager) {
			load((IXMLPersistManager) manager);
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistSubscrList#load(com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager)
	 */
	protected void load(IXMLPersistManager manager) throws PersistException {
		final String method = "load(IXMLPersistManager)";
		Log.enter(method);
		try {
			DeployService deplSrv = JndiUtils.getDeployService(getClass().getClassLoader());
			String[] apps = deplSrv.listApplications("EJBContainer", null);
			String appId;
			for (int i = 0; i < apps.length; i++) {
				ApplicationInformation appInfo = deplSrv.getApplicationInformation(apps[i]);
				appId = appInfo.getLoaderName();
				try {
					IPersistApplication app = new PersistApplication(appId);
					app.invalidate();
					if (!app.isValid()) {
						Log.debug("App:[" + appId + "] is not valid! Either it doesn't contain properties or it isn't possible to resolve its classLoder.");
						continue;
					}
					ISubscrListFactory appFactory = AppSubscrListFactory.getInstance(app);
					IAppSubscrList appSubscrList = (IAppSubscrList) appFactory.getSubscrList();
					if (appSubscrList == null) {
						Log.debug("It couldn't be possible to load subscrList for the app:[" + appId + "]");
						continue;
					}
					addAppSubscrList(appSubscrList);
				} catch (SubscrException e) {
					Log.fatal(new PersistException(IResourceKeys.CANT_GET_APP_SUBCR, new Object[] { appInfo.getOriginalAppName()}, e));
				}
			}
		} catch (Exception e) {
			Log.fatal(e, method);
			throw new PersistException(IResourceKeys.CANT_GET_DEPLOYED_SUBSCR, e);
		} finally {
			Log.exit(method);
		}
	}

}
