package com.sap.caf.rt.services.notify.subscr.app;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.res.IResourceKeys;
import com.sap.caf.rt.services.notify.subscr.ISubscrList;
import com.sap.caf.rt.services.notify.subscr.SubscrException;
import com.sap.caf.rt.services.notify.subscr.app.lifecycle.AppLifeCycleException;
import com.sap.caf.rt.services.notify.subscr.app.lifecycle.AppLifeCycleMonitor;
import com.sap.caf.rt.services.notify.subscr.app.lifecycle.IAppLifeCycleListener;
import com.sap.caf.rt.services.notify.subscr.app.lifecycle.IAppLifeCycleMonitor;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public abstract class GeneralSubscrListFactory implements IGeneralSubscrListFactory, IAppLifeCycleListener {

	protected GeneralSubscrListFactory() throws SubscrException {
		try {
			IAppLifeCycleMonitor monitor = AppLifeCycleMonitor.getInstance();
			monitor.addListener(this);
		} catch (AppLifeCycleException e) {
			if (Log.isDebugEnabled()) {
				Log.debug("Could not register application lifecycle listener");
			}
			throw new SubscrException(e);
		}
	}

	/**
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
//		$JL-FINALIZE$
		IAppLifeCycleMonitor monitor = AppLifeCycleMonitor.getInstance();
		monitor.removeListener(this);
		super.finalize();
	}

	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrListFactory#getSubsriptionList()
	 */
	public synchronized ISubscrList getSubscrList() throws SubscrException {
		if (m_subscrList==null) {
			createSubscrList();
		}
		return m_subscrList;
	}

	public synchronized void createSubscrList() throws SubscrException {
		try {
			m_subscrList = getSubscrListInstance();
			// load subscr list in via persistent manager
			IPersistManager manager = getPersistManager();
			manager.begin();
			try {
				manager.load(m_subscrList);
				manager.commit();
			}
			catch (PersistException e) {
				manager.revert();
				throw e;
			}
		} catch (PersistException e) {
			throw new SubscrException(IResourceKeys.CANT_LOAD_SUBSCR_LIST, e);
		}
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.lifecycle.IAppLifeCycleListener#appStateChanged(java.lang.String)
	 */
	public synchronized void appStateChanged(String appId, byte phase, byte state) {
		if (m_subscrList==null) {
			return;
		}
		IAppSubscrList appSubscrList = m_subscrList.getAppSubscrList(appId);
		if (appSubscrList==null) {
			return; // doesn't contain subscr
		}
		m_subscrList=null; 
	}
	
	protected abstract IGeneralSubscrList getSubscrListInstance();
	 
	private IGeneralSubscrList m_subscrList;

}
