package com.sap.caf.rt.services.notify.subscr.app;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import com.sap.caf.rt.services.notify.subscr.ISubscription;
import com.sap.caf.rt.services.notify.subscr.SubscrList;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplication;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplicationList;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistApplicationList;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class GeneralSubscrList extends SubscrList	implements IGeneralSubscrList {

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.IGeneralSubscrList#getApplicationIds()
	 */
	public Iterator getApplications() {
		return m_appList.getApplications();
	}

	protected void addApplication(IApplication app) {
		if (m_appList.addApplication(app)) {
			IAppSubscrList appSubscrList = getAppSubscrList(app.getId()); 			
			if (appSubscrList==null) {
				addAppSubscrList(new AppSubscrList((IPersistApplication)app));
			}
		}
	}

	protected void removeApplication(String appId) {
		IApplication app = m_appList.getApplication(appId);
		if (app!=null) {
			IAppSubscrList appSubscrList = getAppSubscrList(app.getId());
			if (appSubscrList!=null && !appSubscrList.hasChanged()) { 
				m_appList.removeApplication(appId);
				removeAppSubscrList(appId);
			}
		}
	}
	
	public IPersistApplication getApplication(String appId) {
		return (IPersistApplication)m_appList.getApplication(appId);
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.IGeneralSubscrList#getSubscrByGroup(java.lang.String)
	 */
	public Iterator getSubscrByGroup(String groupId) {
		Map subscrs = (Map)m_grps.get(groupId);
		return subscrs==null? Collections.EMPTY_LIST.iterator(): subscrs.values().iterator();
	}

	protected void addSubscrByGroup(ISubscription subscr) {
		String groupId = subscr.getGroupId();
		Map subscrs = (Map)m_grps.get(groupId);
		if (subscrs==null) {
			subscrs = new LinkedHashMap();
			m_grps.put(groupId, subscrs);
		}
		String id = subscr.getId();
		if (!subscrs.containsKey(id)) {
			subscrs.put(id, subscr);
		}
	}

	protected void removeSubscrByGroup(ISubscription subscr) {
		String groupId = subscr.getGroupId();
		Map subscrs = (Map)m_grps.get(groupId);
		if (subscrs==null) {
			return;
		}
		String subscrId = subscr.getId();
		subscrs.remove(subscrId);
		if (subscrs.isEmpty()) {
			m_grps.remove(groupId);
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.SubscrList#addSubscription(com.sap.caf.rt.services.notify.subscr.ISubscription)
	 */
	public synchronized void addSubscription(ISubscription subscr) {
		String subscrId = subscr.getId();
		if (getSubscription(subscrId)==null) {
			super.addSubscription(subscr);
			addApplication(subscr.getApplication());
			addSubscrByGroup(subscr);
			addSubscrByApp(subscr);
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrList#removeSubscription(java.lang.String)
	 */
	public synchronized void removeSubscription(String subscrId) {
		ISubscription subscr = getSubscription(subscrId);
		if (subscr!=null) {
			super.removeSubscription(subscrId);
			removeSubscrByGroup(subscr);
			removeSubscrByApp(subscr);
			removeApplication(subscr.getApplication().getId());
		}
	}
	
	protected IPersistApplicationList getApplicationList() {
		return m_appList;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#load(com.sap.caf.rt.services.notify.subscr.persist.IPersistManager)
	 */
	public synchronized void load(IPersistManager manager) throws PersistException {
		IPersistApplicationList appList = getApplicationList();
		appList.load(manager);
		for(Iterator itr=appList.getApplications(); itr.hasNext(); ) {
			IPersistApplication app = (IPersistApplication)itr.next();
			IAppSubscrList appSubscrList = new AppSubscrList(app); 
			appSubscrList.load(manager);
			addAppSubscrList(appSubscrList);
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#store(com.sap.caf.rt.services.notify.subscr.persist.IPersistManager)
	 */
	public synchronized void store(IPersistManager manager) throws PersistException {
		IPersistApplicationList appList = getApplicationList(); 
		appList.store(manager);
		IAppSubscrList appSubscrList;
		for(Iterator itr=getAppSubscrLists(); itr.hasNext(); ) {
			appSubscrList = (IAppSubscrList)itr.next(); 
			appSubscrList.store(manager);
			if (appSubscrList.isEmpty()) {
				appList.removeApplication(appSubscrList.getApplication().getId());
				itr.remove();
			}
		}
		appList.store(manager);
	}
	
	public synchronized void addAppSubscrList(IAppSubscrList appSubscrList) {
		m_appSubscrLists.put(appSubscrList.getApplication().getId(), appSubscrList);
		for(Iterator itr=appSubscrList.getSubscriptions(); itr.hasNext(); ) {
			addSubscription((ISubscription)itr.next());
		}
	}

	public IAppSubscrList getAppSubscrList(String appId) {
		return (IAppSubscrList)m_appSubscrLists.get(appId);
	}
	
	public synchronized void removeAppSubscrList(String appId) {
		IAppSubscrList appSubscrList = getAppSubscrList(appId);
		if (appSubscrList!=null) {
			m_appSubscrLists.remove(appId);
			for(Iterator itr=appSubscrList.getSubscriptions(); itr.hasNext(); ) {
				removeSubscription(((ISubscription)itr.next()).getId());
			}
		}
	}
	
	protected Iterator getAppSubscrLists() {
		return m_appSubscrLists.values().iterator();
	}
	
	protected void addSubscrByApp(ISubscription subscr) {
		String subscrId = subscr.getId();
		IAppSubscrList appSubscrList = getAppSubscrList(subscr.getApplication().getId());
		if (appSubscrList!=null && appSubscrList.getSubscription(subscrId)==null) {
			appSubscrList.addSubscription(subscr);
		}
	}
	
	protected void removeSubscrByApp(ISubscription subscr) {
		String subscrId = subscr.getId();
		IAppSubscrList appSubscrList = getAppSubscrList(subscr.getApplication().getId());
		if (appSubscrList!=null) {
			appSubscrList.removeSubscription(subscrId);
		}
	}
	
	private IPersistApplicationList m_appList = new PersistApplicationList();
	private Map m_grps = new LinkedHashMap();
	private Map m_appSubscrLists = new LinkedHashMap();
}
