package com.sap.caf.rt.services.notify.subscr.app;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class ApplicationList implements IApplicationList {

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.IApplicationList#getApplications()
	 */
	public Iterator getApplications() {
		return m_apps.values().iterator();
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.IApplicationList#getApplication(java.lang.String)
	 */
	public IApplication getApplication(String id) {
		return (IApplication)m_apps.get(id);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.IApplicationList#addApplication(com.sap.caf.rt.services.notify.subscr.app.IApplication)
	 */
	public boolean addApplication(IApplication app) {
		String id = app.getId();
		if (m_apps.containsKey(id)) {
			return false;
		}
		m_apps.put(id, app);
		return true;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.IApplicationList#removeApplication(java.lang.String)
	 */
	public void removeApplication(String id) {
		m_apps.remove(id);
	}

	protected void clearApplications() {
		m_apps.clear();
	}
	
	private Map m_apps = new LinkedHashMap();
}
