package com.sap.caf.rt.services.notify.subscr.app;

import java.util.Properties;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class Application implements IApplication {

	public Application() {
	}
	
	public Application(String id, Properties props, ClassLoader loader) {
		m_sId = id;
		m_props = props;
		setClassLoader(loader);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.IApplication#getId()
	 */
	public String getId() {
		return m_sId;
	}

	public void setId(String id) {
		m_sId = id;
	}
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.IApplication#getClassLoader()
	 */
	public ClassLoader getClassLoader() {
		return m_loader;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.IPersistable#setClassLoader(java.lang.ClassLoader)
	 */
	public void setClassLoader(ClassLoader loader) {
		m_loader = loader;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.IApplication#getProperties()
	 */
	public Properties getProperties() {
		return m_props;
	}
	
	protected void setProperties(Properties props) {
		m_props = props;
	}
	
	protected void setActive(boolean active) {
		m_bIsActive = active;
	}

	public boolean isActive() {
		return m_bIsActive;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.app.IApplication#isValid()
	 */
	public boolean isValid() {
		return m_loader!=null && m_props!=null;
	}
	
	private boolean m_bIsActive;
	private String m_sId;
	private ClassLoader m_loader;
	private Properties m_props;

}
