package com.sap.caf.rt.services.notify.subscr.app;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.w3c.dom.Node;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.res.IResourceKeys;
import com.sap.caf.rt.services.notify.subscr.ISubscription;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplication;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscription;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistSubscrList;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistSubscription;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLNames;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.xml.XMLUtils;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class AppSubscrList extends PersistSubscrList implements IAppSubscrList {

	public AppSubscrList() {
	}

	public AppSubscrList(IPersistApplication app) {
		setApplication(app);
	}

	public synchronized void addSubscription(ISubscription subscr) {
		super.addSubscription(subscr);
		subscr.setSubscrList(this);
		subscr.setApplication(getApplication());
		addSubscrByGroup(subscr);
	}

	public synchronized void removeSubscription(String id) {
		ISubscription subscr = getSubscription(id);
		if (subscr != null) {
			super.removeSubscription(id);
			removeSubscrByGroup(subscr);
		}
	}

	public Iterator getSubscrByGroup(String groupId) {
		Map keys = getGrouppedKeys(groupId);
		return keys == null ? Collections.EMPTY_LIST.iterator() : keys.values().iterator();
	}

	protected void addSubscrByGroup(ISubscription subscr) {
		String groupId = subscr.getGroupId();
		Map grouppedKeys = getGrouppedKeys(groupId);
		if (grouppedKeys == null) {
			grouppedKeys = addGroupId(groupId);
		}
		Object id = subscr.getId();
		grouppedKeys.put(id, subscr);
	}

	protected void removeSubscrByGroup(ISubscription subscr) {
		String subscrId = subscr.getId();
		if (subscr == null) {
			return;
		}
		Map grouppedKeys = getGrouppedKeys(subscr.getGroupId());
		if (grouppedKeys != null) {
			grouppedKeys.remove(subscrId);
		}
	}

	public Iterator getGroupIds() {
		return m_groups.keySet().iterator();
	}

	protected Map addGroupId(String groupId) {
		Map keys = new LinkedHashMap();
		m_groups.put(groupId, keys);
		return keys;
	}

	protected Map getGrouppedKeys(String groupId) {
		return (Map) m_groups.get(groupId);
	}

	public IPersistApplication getApplication() {
		return m_app;
	}

	public void setApplication(IPersistApplication app) {
		m_app = app;
	}

	protected void load(ISQLPersistManager manager) throws PersistException {
		try {
			IPersistApplication app = (IPersistApplication) getApplication();
			List rows = SQLUtils.execSelect(manager, ISQLNames.SELECT_SUBSCR_KEYS, ISQLNames.SELECT_SUBSCR_KEYS_TYPES, new Object[] { app.getKey()});
			for (int i = rows.size(); --i >= 0;) {
				Map row = (Map) rows.get(i);
				IPersistSubscription subscr = new PersistSubscription();
				subscr.setKey((String) row.get(ISQLNames.SUBSCR_KEY));
				subscr.setApplication(app);
				manager.load(subscr);
				addSubscription(subscr);
				subscr.getState().reset();
			}
		} catch (PersistException e) {
			throw new PersistException(IResourceKeys.CANT_LOAD_SUBSCR_LIST, e);
		}
	}

	protected void load(IXMLPersistManager manager) throws PersistException {
		try {
			ClassLoader loader = getClassLoader();
			Node root = manager.getCurrentNode();
			manager.load(XMLUtils.getChildNode(manager.getCurrentNode(), IXMLNames.TAG_APP), m_app);
			// load subscrs
			boolean bDebug = Log.isDebugEnabled();
			IApplication app = getApplication();
			List nodes = XMLUtils.getNodesAsList(root, IXMLNames.TAG_SUBSCR);
			for (int i = 0; i < nodes.size(); i++) {
				Node node = (Node) nodes.get(i);
				IPersistSubscription subscr = new PersistSubscription();
				subscr.setApplication(app);
				manager.load(node, subscr);
				addSubscription(subscr);
				subscr.getState().reset();
			}
		} catch (PersistException e) {
			throw new PersistException(IResourceKeys.CANT_LOAD_SUBSCR_LIST, e);
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistSubscrList#getClassLoader()
	 */
	protected ClassLoader getClassLoader() {
		return getApplication().getClassLoader();
	}

	private IPersistApplication m_app;
	private Map m_groups = new LinkedHashMap();
}
