package com.sap.caf.rt.services.notify.subscr;

import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.subscr.app.IApplication;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class Subscription implements ISubscription {

	public Subscription() {
	}
	
	public Subscription(String id, String groupId, 
		ISubscrFilter filter, ISubscrRecipients allUsers, ISubscrRecipients excludedUsers,
		ISubscrTemplate template) 
	{
		m_id = id;
		m_groupId = groupId;
		m_filter = filter;
		m_recips = allUsers;
		m_exclRecips = excludedUsers;
		m_templ = template;
		m_bEnabled = true;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscription.ISubscription#getFilter()
	 */
	public ISubscrFilter getFilter() {
		return m_filter;
	}

	public void setFilter(ISubscrFilter filter) {
		if (filter!=null) {
			filter.setSubscription(this);
		}
		m_filter = filter;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscription.ISubscription#getRecipients(com.sap.caf.rt.services.notify.notification.INotificationEvent)
	 */
	public ISubscrRecipients getRecipients(INotifEvent event) {
		return m_recips;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscription#getIncludedRecipients()
	 */
	public ISubscrRecipients getRecipients() {
		return m_recips;
	}

	public void setRecipients(ISubscrRecipients recipients) {
		if (recipients!=null) {
			recipients.setSubscription(this);
		}
		m_recips = recipients;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscription.ISubscription#getExcludedRecipients(com.sap.caf.rt.services.notify.notification.INotificationEvent)
	 */
	public ISubscrRecipients getExcludedRecipients(INotifEvent event) {
		return m_exclRecips;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscription#getExcludedRecipients()
	 */
	public ISubscrRecipients getExcludedRecipients() {
		return m_exclRecips;
	}
	
	public void setExcludedRecipients(ISubscrRecipients recipients) {
		if (recipients!=null) {
			recipients.setSubscription(this);
		}
		m_exclRecips = recipients;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscription.ISubscription#getTemplate()
	 */
	public ISubscrTemplate getTemplate() {
		return m_templ;
	}

	public void setTemplate(ISubscrTemplate templ) {
		if (templ!=null) {
			templ.setSubscription(this);
		}
		m_templ = templ;
	}
	 
	/**
	 * @see com.sap.caf.rt.services.notify.subscription.ISubscription#getId()
	 */
	public String getId() {
		return m_id;
	}

	public void setId(String id) {
		m_id = id;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscription.ISubscription#setEnabled(boolean)
	 */
	public void setEnabled(boolean enabled) {
		m_bEnabled = enabled;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscription.ISubscription#isEnabled()
	 */
	public boolean isEnabled() {
		return m_bEnabled;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscription.ISubscription#getGroupId()
	 */
	public String getGroupId() {
		return m_groupId;
	}

	public void setGroupId(String groupId) {
		m_groupId = groupId;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscription.ISubscription#getDescription()
	 */
	public String getDescription() {
		return m_sDescr;
	}
	
	public void setDescription(String descr) {
		m_sDescr = descr;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscription#getSubscrList()
	 */
	public ISubscrList getSubscrList() {
		return m_list;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscription#setSubscrList(com.sap.caf.rt.services.notify.subscr.ISubscrList)
	 */
	public void setSubscrList(ISubscrList list) {
		m_list = list;
	}
		 
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscription#getApplication()
	 */
	public IApplication getApplication() {
		return m_app;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscription#getApplication()
	 */
	public void setApplication(IApplication app) {
		m_app = app;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscription#getIncludedRecipients(com.sap.caf.rt.services.notify.notif.INotifEvent)
	 */
	public ISubscrRecipients getIncludedRecipients(INotifEvent event) {
		return null;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscription#getIncludedRecipients()
	 */
	public ISubscrRecipients getIncludedRecipients() {
		return null;
	}
	
	private IApplication m_app;
	private boolean m_bEnabled;
	private ISubscrRecipients m_exclRecips;
	private ISubscrRecipients m_recips;
	private ISubscrFilter m_filter;
	private ISubscrTemplate m_templ;
	private String m_groupId;
	private String m_id;
	private String m_sDescr;
	private ISubscrList m_list;
	private String m_sActInboxCategory;
}
