package com.sap.caf.rt.services.notify.subscr;

import java.sql.Date;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;

import com.sap.caf.km.proxies.svc.kmnotif.KMNotificationSvc;
import com.sap.caf.km.proxies.svc.kmnotif.KMNotificationSvcService;
import com.sap.caf.km.proxies.svc.kmnotif.types.KMTemplFile;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.res.IResourceKeys;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public abstract class SubscrTemplate implements ISubscrTemplate {

	public SubscrTemplate() {
	}

	/**
	 * @see com.sap.caf.rt.services.notify.notification.INotificationTemplate#getName()
	 */
	public String getId() {
		return m_sId;
	}

	public void setId(String id) {
		m_sId = id;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.notification.INotificationTemplate#getProperties(com.sap.caf.rt.services.notify.notification.INotificationEvent)
	 */
	public Properties getProperties(INotifEvent event) {
		Properties props = convertEventAttrs(event.getAttributes());
		// append system properties:
		props.putAll(getProperties());
		return props;
	}

	protected String getAppProperty(String name, INotifEvent event) {
		Object obj = event.getAttribute(INotifEvent.APP_PROPS);
		if (obj == null || !(obj instanceof Properties)) {
			return null;
		}
		Properties props = (Properties) obj;
		return props.getProperty(name);
	}

	private Properties convertEventAttrs(Map map) {
		Properties props = new Properties();
		Map.Entry entry;
		Object key, value;
		for (Iterator itr = map.entrySet().iterator(); itr.hasNext();) {
			entry = (Map.Entry) itr.next();
			key = entry.getKey();
			value = entry.getValue();
			if (key instanceof String) {
				if (value instanceof String) {
					props.setProperty((String) key, (String) value);
				} else if (value instanceof Date) {
					props.setProperty((String) key, formatDate((Date) value));
				}
			}
		}
		return props;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.notification.INotificationTemplate#getSubject()
	 */
	public String getSubject() {
		return m_sSubj;
	}

	public void setSubject(String subject) {
		m_sSubj = subject;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrTemplate#getFiles()
	 */
	public Iterator getFiles() throws SubscrException {
		try {
			KMNotificationSvc notifSvc = getNotifSvc();
			KMTemplFile[] kmFiles = notifSvc.getTemplateFiles(getId());
			if (kmFiles == null || kmFiles.length == 0) {
				return Collections.EMPTY_LIST.iterator();
			}
			List templFiles = new ArrayList();
			for (int i = 0; i < kmFiles.length; i++) {
				templFiles.add(new TemplateFile(kmFiles[i].getName(), kmFiles[i].getRid()));
			}
			return templFiles.iterator();
		} catch (Exception e) {
			throw new SubscrException(IResourceKeys.CANT_GET_TEMPL_FILES, e);
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrTemplate#getSubscription()
	 */
	public ISubscription getSubscription() {
		return m_subscr;
	}

	public void setSubscription(ISubscription subscr) {
		m_subscr = subscr;
	}

	protected KMNotificationSvc getNotifSvc() throws SubscrException {
		if (m_templProxy == null) {
			try {
				Context context = new InitialContext();
				KMNotificationSvcService service = (KMNotificationSvcService) context.lookup(KM_NOTIF_SVC_JNDI);
				KMNotificationSvc proxy = (KMNotificationSvc) service.getLogicalPort(KMNotificationSvc.class);
				String url = CAFContext.substEPAddress((String) proxy._getProperty("javax.xml.rpc.service.endpoint.address"));
				proxy._setProperty("javax.xml.rpc.service.endpoint.address", url);
				m_templProxy = proxy;
			} catch (Exception e) {
				throw new SubscrException(IResourceKeys.CANT_GET_NOTIF_SVC, e);
			}
		}
		return m_templProxy;
	}

	protected String formatDate(Date date) {
		return s_dateFormat.format(date);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrTemplate#addProperty(java.lang.String, java.lang.String)
	 */
	public void addProperty(String name, String value) {
		m_props.put(name, value);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrTemplate#getProperties()
	 */
	public Properties getProperties() {
		return m_props;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrTemplate#getProperty(java.lang.String)
	 */
	public String getProperty(String name) {
		return m_props.getProperty(name);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrTemplate#removeProperty(java.lang.String)
	 */
	public void removeProperty(String name) {
		m_props.remove(name);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrTemplate#setProperties(java.util.Properties)
	 */
	public void setProperties(Properties props) {
		m_props = props;
	}

	protected String m_sId;
	private Properties m_props = new Properties();
	private String m_sSubj;
	private ISubscription m_subscr;
	private KMNotificationSvc m_templProxy;
	private final static String KM_NOTIF_SVC_JNDI = "wsclients/proxies/sap.com/caf~km.proxies/KMNotificationSvc";
	private final static DateFormat s_dateFormat = DateFormat.getDateInstance(DateFormat.MEDIUM);

}
