package com.sap.caf.rt.services.notify.subscr;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import com.sap.caf.rt.services.notify.notif.INotifEvent;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public abstract class SubscrRecipients implements ISubscrRecipients {
	
	/**
	 * @see com.sap.caf.rt.services.notify.notification.INotificationRecipients#getUserIds(com.sap.caf.rt.services.notify.notification.INotificationEvent)
	 */
	public abstract Collection getUserIds(INotifEvent event);

	/**
	 * @see com.sap.caf.rt.services.notify.notification.INotificationRecipients#getUserIds(com.sap.caf.rt.services.notify.notification.INotificationEvent, com.sap.caf.rt.services.notify.notification.INotificationRecipients)
	 */
	public Collection getUserIds(INotifEvent event, ISubscrRecipients excluding) {
		Collection allUsers = getUserIds(event);
		if (allUsers==null || allUsers.isEmpty() || excluding==null) {
			return allUsers;
		}
		Collection exclUsers = excluding.getUserIds(event);
		if (exclUsers==null || exclUsers.isEmpty()) {
			return allUsers;
		}
		Set exclKeys = new HashSet(exclUsers.size());
		for (Iterator itr=exclUsers.iterator(); itr.hasNext(); ) {
			exclKeys.add(itr.next());
		}
		for (Iterator itr=allUsers.iterator(); itr.hasNext(); ) {
			if (exclKeys.contains(itr.next())) {
				itr.remove();
			}
		}
		return allUsers; 
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrRecipients#getSubscription()
	 */
	public ISubscription getSubscription() {
		return m_subscr;
	}
	
	public void setSubscription(ISubscription subscr) {
		m_subscr = subscr; 
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrRecipients#getDescription()
	 */
	public String getDescription() {
		return m_sDescr;
	}
	
	public void setDescription(String descr) {
		m_sDescr = descr;
	}
	
	private ISubscription m_subscr;
	private String m_sDescr;

}
