package com.sap.caf.rt.services.notify.subscr;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class SubscrPrefs implements ISubscrPrefs {

	/**
	 * Creates SubscrPrefs instance using given 
	 * subscription id and user id	 

	 * @param subscrId A subscription Id
	 * @param userId A user id
	 */
	public SubscrPrefs(ISubscription subscr, String userId) {
		m_subscr = subscr;
		m_sUserId = userId;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrPrefs#getSubscription()
	 */
	public ISubscription getSubscription() {
		return m_subscr;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrPrefs#getUserId()
	 */
	public String getUserId() {
		return m_sUserId;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrPrefs#setUserId(String)
	 */
	public void setUserId(String userId) {
		m_sUserId = userId;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrPrefs#isActionInboxEnabled()
	 */
	public boolean isActionInboxEnabled() {
		return m_bActionInboxEnabled;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrPrefs#setActionInboxEnabled(boolean)
	 */
	public void setActionInboxEnabled(boolean enabled) {
		m_bActionInboxEnabled = enabled;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrPrefs#isSubscribed()
	 */
	public boolean isSubscribed() {
		return m_bSubscribed;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrPrefs#setSubscribed(boolean)
	 */
	public void setSubscribed(boolean subscribed) {
		m_bSubscribed = subscribed;
	}

	private String m_sUserId;
	private boolean m_bSubscribed = true;
	private boolean m_bActionInboxEnabled = true; // TODO init from CAFContext
	private ISubscription m_subscr;

}
