/* Generated by Together */

package com.sap.caf.rt.services.notify.subscr;

import java.lang.reflect.Constructor;
import java.util.Properties;

import com.sap.caf.rt.services.notify.res.IResourceKeys;

public abstract class SubscrListFactory implements ISubscrListFactory {

  protected ISubscrList createSubscrList(Properties props, ClassLoader appLoader) throws SubscrException {
  	if (props==null || appLoader==null) {
  		return null;
  	}
		String className = getListClassName(props);
		if (className==null) {
			return null;
		}
		try {
			Class classImpl = Class.forName(className, true, appLoader);
			if (!ISubscrList.class.isAssignableFrom(classImpl)) {
				throw new SubscrException(IResourceKeys.WRONG_LISTCLASS, new Object[] {className});
			}
			Constructor constr = classImpl.getConstructor(new Class[] {});
			if (constr==null) {
				throw new SubscrException(IResourceKeys.WRONG_LISTCLASS, new Object[] {className});
			}
			ISubscrList list = (ISubscrList)constr.newInstance(new Object[] {});
		  return list;
		} catch (Exception e) {
			throw new SubscrException(IResourceKeys.CANT_GET_LISTCLASS, e);
		}
  }
  
	protected abstract String getListClassName(Properties props) throws SubscrException;

}
