package com.sap.caf.rt.services.notify.subscr;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;


/**
 * @author viachaslau_kudzinau@epam.com
 */
public class SubscrList implements ISubscrList {

	public void addSubscription(ISubscription subscr) {
		m_keys.put(subscr.getId(), subscr);
	}

	public Iterator getSubscriptions() {
		return m_keys.values().iterator();
	}
	
	public void removeSubscription(String id) {
		m_keys.remove(id);
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscription.ISubscriptionList#getSubscription(java.lang.String)
	 */
	public ISubscription getSubscription(String id) {
		return (ISubscription)m_keys.get(id);
	}

	public boolean isEmpty() {
		return m_keys.isEmpty();
	}

	protected int getSize() { 
		return m_keys.size();
	}
	
	private Map m_keys = new LinkedHashMap();

}
