package com.sap.caf.rt.services.notify.subscr;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.notif.INotifEvent;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class SubscrFilter implements ISubscrFilter {

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrFilter#getSubscription()
	 */
	public ISubscription getSubscription() {
		return m_subscr;
	}
	
	public void setSubscription(ISubscription subscr) {
		m_subscr = subscr;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrFilter#accept(com.sap.caf.rt.services.notify.notif.INotifEvent)
	 */
	public boolean accept(INotifEvent event) {
		ISubscription subscr = getSubscription();		
		if (!subscr.isEnabled()) {
			if (Log.isDebugEnabled()) {
				Log.debug("Subscription:"+subscr.getId()+" is disabled, event ignored");
			}
			return false;
		}
		ISubscrType eventType = event.getType();
		ISubscrType type;
		for (Iterator itr=getTypes(); itr.hasNext(); ) {
			type = (ISubscrType)itr.next();
			if (type.equals(eventType)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrFilter#getTypes()
	 */
	public Iterator getTypes() {
		return m_types.values().iterator();
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrFilter#getType(java.lang.String)
	 */
	public ISubscrType getType(String id) {
		return (ISubscrType)m_types.get(id);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrFilter#addType(com.sap.caf.rt.services.notify.subscr.ISubscrType)
	 */
	public void addType(ISubscrType type) {
		type.setFilter(this);
		m_types.put(type.getId(), type);
	}

	/**
	 * @see com.sap.caf.rt.services.notify.subscr.ISubscrFilter#removeType(java.lang.String)
	 */
	public void removeType(String typeId) {
		m_types.remove(typeId);
	}
	
	protected Map m_types = new LinkedHashMap();
	protected ISubscription m_subscr;
}
