package com.sap.caf.rt.services.notify.subscr;

import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.subscr.app.IApplication;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public interface ISubscription {

	IApplication getApplication();

	void setApplication(IApplication app);
	
	ISubscrList getSubscrList();
	
	void setSubscrList(ISubscrList list);
	
	String getId();	
	
	void setId(String id);
		
	String getGroupId();

	void setGroupId(String groupId);
	
	ISubscrFilter getFilter();

	void setFilter(ISubscrFilter filter);
	
	ISubscrRecipients getRecipients(INotifEvent event);

	ISubscrRecipients getRecipients();

	ISubscrRecipients getIncludedRecipients(INotifEvent event);

	ISubscrRecipients getIncludedRecipients();
	
	ISubscrRecipients getExcludedRecipients(INotifEvent event);

	ISubscrRecipients getExcludedRecipients();

	ISubscrTemplate getTemplate();

	String getDescription(); 

	void setDescription(String descr); 
	
	void setEnabled(boolean enabled);

	boolean isEnabled();

  /** @link dependency 
	 * @stereotype include*/
	/*#ISubscrFilter lnkINotificationFilter;*/
	
	/** @link dependency 
	 * @stereotype include*/
	/*#ISubscrRecipients lnkINotificationRecipient;*/
	
	/** @link dependency 
	 * @stereotype include*/
	/*#INotificationTemplate lnkINotificationTemplate;*/
	
	/** @link dependency 
	 * @stereotype include*/
	/*#IRegisteredUserRecipients lnkIRegisteredUserRecipients;*/
}
