package com.sap.caf.rt.services.notify.subscr;

/**
 * A factory interface being used to get a 
 * list of available subscriptions
 *  
 * @author viachaslau_kudzinau@epam.com
 */
public interface ISubscrListFactory {

	/**
	 * Get a list of available subscriptions
	 * @return <code>ISubscriptionList</code> instance 
	 * @throws SubscriptionException
	 */
	ISubscrList getSubscrList() throws SubscrException;

    /** @link dependency 
     * @stereotype create*/
    /*#ISubscrList lnkISubscriptionList;*/
}
