package com.sap.caf.rt.services.notify.notif.send;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.notif.NotifException;
import com.sap.caf.rt.services.notify.res.IResourceKeys;

/**
 * @author viachaslau_kudzinau@epam.com
 * @ejbHome <{none}>
 * @ejbLocal <{com.sap.caf.rt.services.notify.NotificationLocal}>
 * @ejbLocalHome <{com.sap.caf.rt.services.notify.NotificationLocalHome}>
 * @ejbRemote <{none}>
 * @stateless 
 */
public class SendingBean implements SessionBean {
	static final long serialVersionUID = 1;
	
	private transient SessionContext m_sessContext;
	private transient TopicSession m_topicSess;
	private transient TopicPublisher m_topicPubl;
	private transient TopicConnection m_topicConn;
	
	/**
	 * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
	 */
	public void setSessionContext(SessionContext context) throws EJBException, RemoteException {
		m_sessContext = context;
	}

	public void ejbCreate() throws CreateException {
		final String method = "ejbCreate()";
		Log.enter(method);
		try {
			create();
		} catch (Exception e) {
			NotifException ntfyEx = new NotifException(IResourceKeys.CANT_CREATE_SNDBEAN, e);  
			Log.fatal(ntfyEx, method);
			throw new CreateException(ntfyEx.getLocalizedMessage());
		}
		finally {
			Log.exit(method);
		}
	}
	
	/**
	 * @see javax.ejb.SessionBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
		final String method = "ejbActivate()";
		Log.enter(method);
		try {
			create();
		} catch (Exception e) {
			NotifException ntfyEx = new NotifException(IResourceKeys.CANT_CREATE_SNDBEAN, e);  
			Log.fatal(ntfyEx, method);
		}
		finally {
			Log.exit(method);
		}
	}

	/**
	 * @see javax.ejb.SessionBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		final String method = "ejbPassivate()";
		Log.enter(method);
		try {
			destroy();
		} catch (JMSException e) {
			NotifException ntfyEx = new NotifException(IResourceKeys.CANT_DESTROY_SNDBEAN, e);  
			Log.fatal(ntfyEx, method);
		}
		finally {
			Log.exit(method);
		}
	}

	/**
	 * @see javax.ejb.SessionBean#ejbRemove()
	 */
	public void ejbRemove() throws EJBException, RemoteException {
		final String method = "ejbRemove()";
		Log.enter(method);
		try {
			destroy();
		} catch (JMSException e) {
			NotifException ntfyEx = new NotifException(IResourceKeys.CANT_DESTROY_SNDBEAN, e);  
			Log.fatal(ntfyEx, method);
		}
		finally {
			Log.exit(method);
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.INotification#notifyByUserIds(java.util.List, java.lang.String, java.util.Map)
	 */
	public void send(NotifMessage notifMsg) throws NotifException {
		final String method = "send(NotifMessage)";
		final Object[] params = {notifMsg};
		Log.enter(method);
		try {
			if (!notifMsg.isValid()) {
				if (Log.isDebugEnabled()) {
					Log.debug("NotifMessage is invalid, not sending it");
				}
				return;  
			}
			ObjectMessage objMsg = m_topicSess.createObjectMessage();
			objMsg.setObject(notifMsg);					
			m_topicPubl.publish(objMsg);
		} catch (JMSException e) {
			NotifException ntfyEx = new NotifException(IResourceKeys.CANT_PUBLISH_MSG, params, e);  
			Log.fatal(ntfyEx, method);
			throw ntfyEx;
		}
		finally {
			Log.exit(method);
		}
	}

// private methods

	private void create() throws NamingException, JMSException {
		InitialContext context=new InitialContext();
		TopicConnectionFactory connFactory = (TopicConnectionFactory)context.lookup(CAFContext.JNDI_NAME_JMS);
		m_topicConn = connFactory.createTopicConnection();
		m_topicSess = m_topicConn.createTopicSession(false, Session.AUTO_ACKNOWLEDGE);
		Topic topic = (Topic)context.lookup(CAFContext.JNDI_NAME_NOTIF_JMS_TOPIC);			
		m_topicPubl = m_topicSess.createPublisher(topic);
	}

	private void destroy() throws JMSException {
		m_topicPubl.close();
		m_topicSess.close();
		m_topicConn.close();
	}
}
